# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class SourceMongoDb(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'collection_name': 'str',
        'database_name': 'str',
        'status': 'StatusMongoDb'
    }

    attribute_map = {
        'collection_name': 'collection_name',
        'database_name': 'database_name',
        'status': 'status'
    }

    def __init__(self, collection_name=None, database_name=None, status=None, local_vars_configuration=None):  # noqa: E501
        """SourceMongoDb - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._collection_name = None
        self._database_name = None
        self._status = None
        self.discriminator = None

        self.collection_name = collection_name
        self.database_name = database_name
        if status is not None:
            self.status = status

    @property
    def collection_name(self):
        """Gets the collection_name of this SourceMongoDb.  # noqa: E501

        MongoDB collection name  # noqa: E501

        :return: The collection_name of this SourceMongoDb.  # noqa: E501
        :rtype: str
        """
        return self._collection_name

    @collection_name.setter
    def collection_name(self, collection_name):
        """Sets the collection_name of this SourceMongoDb.

        MongoDB collection name  # noqa: E501

        :param collection_name: The collection_name of this SourceMongoDb.  # noqa: E501
        :type collection_name: str
        """
        if self.local_vars_configuration.client_side_validation and collection_name is None:  # noqa: E501
            raise ValueError("Invalid value for `collection_name`, must not be `None`")  # noqa: E501

        self._collection_name = collection_name

    @property
    def database_name(self):
        """Gets the database_name of this SourceMongoDb.  # noqa: E501

        MongoDB database name containing this collection  # noqa: E501

        :return: The database_name of this SourceMongoDb.  # noqa: E501
        :rtype: str
        """
        return self._database_name

    @database_name.setter
    def database_name(self, database_name):
        """Sets the database_name of this SourceMongoDb.

        MongoDB database name containing this collection  # noqa: E501

        :param database_name: The database_name of this SourceMongoDb.  # noqa: E501
        :type database_name: str
        """
        if self.local_vars_configuration.client_side_validation and database_name is None:  # noqa: E501
            raise ValueError("Invalid value for `database_name`, must not be `None`")  # noqa: E501

        self._database_name = database_name

    @property
    def status(self):
        """Gets the status of this SourceMongoDb.  # noqa: E501


        :return: The status of this SourceMongoDb.  # noqa: E501
        :rtype: StatusMongoDb
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this SourceMongoDb.


        :param status: The status of this SourceMongoDb.  # noqa: E501
        :type status: StatusMongoDb
        """

        self._status = status

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SourceMongoDb):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SourceMongoDb):
            return True

        return self.to_dict() != other.to_dict()
