# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class SourceKinesis(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'aws_region': 'str',
        'dms_primary_key': 'list[str]',
        'offset_reset_policy': 'str',
        'stream_name': 'str'
    }

    attribute_map = {
        'aws_region': 'aws_region',
        'dms_primary_key': 'dms_primary_key',
        'offset_reset_policy': 'offset_reset_policy',
        'stream_name': 'stream_name'
    }

    def __init__(self, aws_region=None, dms_primary_key=None, offset_reset_policy=None, stream_name=None, local_vars_configuration=None):  # noqa: E501
        """SourceKinesis - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._aws_region = None
        self._dms_primary_key = None
        self._offset_reset_policy = None
        self._stream_name = None
        self.discriminator = None

        if aws_region is not None:
            self.aws_region = aws_region
        if dms_primary_key is not None:
            self.dms_primary_key = dms_primary_key
        if offset_reset_policy is not None:
            self.offset_reset_policy = offset_reset_policy
        self.stream_name = stream_name

    @property
    def aws_region(self):
        """Gets the aws_region of this SourceKinesis.  # noqa: E501

        AWS region name of Kinesis stream, by default us-west-2 is used  # noqa: E501

        :return: The aws_region of this SourceKinesis.  # noqa: E501
        :rtype: str
        """
        return self._aws_region

    @aws_region.setter
    def aws_region(self, aws_region):
        """Sets the aws_region of this SourceKinesis.

        AWS region name of Kinesis stream, by default us-west-2 is used  # noqa: E501

        :param aws_region: The aws_region of this SourceKinesis.  # noqa: E501
        :type aws_region: str
        """

        self._aws_region = aws_region

    @property
    def dms_primary_key(self):
        """Gets the dms_primary_key of this SourceKinesis.  # noqa: E501

        set of fields that correspond to a DMS primary key  # noqa: E501

        :return: The dms_primary_key of this SourceKinesis.  # noqa: E501
        :rtype: list[str]
        """
        return self._dms_primary_key

    @dms_primary_key.setter
    def dms_primary_key(self, dms_primary_key):
        """Sets the dms_primary_key of this SourceKinesis.

        set of fields that correspond to a DMS primary key  # noqa: E501

        :param dms_primary_key: The dms_primary_key of this SourceKinesis.  # noqa: E501
        :type dms_primary_key: list[str]
        """

        self._dms_primary_key = dms_primary_key

    @property
    def offset_reset_policy(self):
        """Gets the offset_reset_policy of this SourceKinesis.  # noqa: E501

        For non-DMS streams, Rockset can tail from the earliest end or latest end of kinesis source.  # noqa: E501

        :return: The offset_reset_policy of this SourceKinesis.  # noqa: E501
        :rtype: str
        """
        return self._offset_reset_policy

    @offset_reset_policy.setter
    def offset_reset_policy(self, offset_reset_policy):
        """Sets the offset_reset_policy of this SourceKinesis.

        For non-DMS streams, Rockset can tail from the earliest end or latest end of kinesis source.  # noqa: E501

        :param offset_reset_policy: The offset_reset_policy of this SourceKinesis.  # noqa: E501
        :type offset_reset_policy: str
        """
        allowed_values = ["LATEST", "EARLIEST"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and offset_reset_policy not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `offset_reset_policy` ({0}), must be one of {1}"  # noqa: E501
                .format(offset_reset_policy, allowed_values)
            )

        self._offset_reset_policy = offset_reset_policy

    @property
    def stream_name(self):
        """Gets the stream_name of this SourceKinesis.  # noqa: E501

        name of kinesis stream  # noqa: E501

        :return: The stream_name of this SourceKinesis.  # noqa: E501
        :rtype: str
        """
        return self._stream_name

    @stream_name.setter
    def stream_name(self, stream_name):
        """Sets the stream_name of this SourceKinesis.

        name of kinesis stream  # noqa: E501

        :param stream_name: The stream_name of this SourceKinesis.  # noqa: E501
        :type stream_name: str
        """
        if self.local_vars_configuration.client_side_validation and stream_name is None:  # noqa: E501
            raise ValueError("Invalid value for `stream_name`, must not be `None`")  # noqa: E501

        self._stream_name = stream_name

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SourceKinesis):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SourceKinesis):
            return True

        return self.to_dict() != other.to_dict()
