# coding: utf-8

"""
    REST API

    Rockset's REST API allows for creating and managing all resources in Rockset. Each supported endpoint is documented below.  All requests must be authorized with a Rockset API key, which can be created in the [Rockset console](https://console.rockset.com). The API key must be provided as `ApiKey <api_key>` in the `Authorization` request header. For example: ``` Authorization: ApiKey aB35kDjg93J5nsf4GjwMeErAVd832F7ad4vhsW1S02kfZiab42sTsfW5Sxt25asT ```  All endpoints are only accessible via https.  Build something awesome!  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from rockset.configuration import Configuration


class GcsSourceWrapper(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'format_params': 'FormatParams',
        'integration_name': 'str',
        'status': 'Status',
        'bucket': 'str',
        'object_bytes_total': 'int',
        'object_count_downloaded': 'int',
        'object_count_total': 'int',
        'pattern': 'str',
        'prefix': 'str'
    }

    attribute_map = {
        'format_params': 'format_params',
        'integration_name': 'integration_name',
        'status': 'status',
        'bucket': 'bucket',
        'object_bytes_total': 'object_bytes_total',
        'object_count_downloaded': 'object_count_downloaded',
        'object_count_total': 'object_count_total',
        'pattern': 'pattern',
        'prefix': 'prefix'
    }

    def __init__(self, format_params=None, integration_name=None, status=None, bucket=None, object_bytes_total=None, object_count_downloaded=None, object_count_total=None, pattern=None, prefix=None, local_vars_configuration=None):  # noqa: E501
        """GcsSourceWrapper - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._format_params = None
        self._integration_name = None
        self._status = None
        self._bucket = None
        self._object_bytes_total = None
        self._object_count_downloaded = None
        self._object_count_total = None
        self._pattern = None
        self._prefix = None
        self.discriminator = None

        if format_params is not None:
            self.format_params = format_params
        self.integration_name = integration_name
        if status is not None:
            self.status = status
        if bucket is not None:
            self.bucket = bucket
        if object_bytes_total is not None:
            self.object_bytes_total = object_bytes_total
        if object_count_downloaded is not None:
            self.object_count_downloaded = object_count_downloaded
        if object_count_total is not None:
            self.object_count_total = object_count_total
        if pattern is not None:
            self.pattern = pattern
        if prefix is not None:
            self.prefix = prefix

    @property
    def format_params(self):
        """Gets the format_params of this GcsSourceWrapper.  # noqa: E501


        :return: The format_params of this GcsSourceWrapper.  # noqa: E501
        :rtype: FormatParams
        """
        return self._format_params

    @format_params.setter
    def format_params(self, format_params):
        """Sets the format_params of this GcsSourceWrapper.


        :param format_params: The format_params of this GcsSourceWrapper.  # noqa: E501
        :type format_params: FormatParams
        """

        self._format_params = format_params

    @property
    def integration_name(self):
        """Gets the integration_name of this GcsSourceWrapper.  # noqa: E501

        name of integration to use  # noqa: E501

        :return: The integration_name of this GcsSourceWrapper.  # noqa: E501
        :rtype: str
        """
        return self._integration_name

    @integration_name.setter
    def integration_name(self, integration_name):
        """Sets the integration_name of this GcsSourceWrapper.

        name of integration to use  # noqa: E501

        :param integration_name: The integration_name of this GcsSourceWrapper.  # noqa: E501
        :type integration_name: str
        """
        if self.local_vars_configuration.client_side_validation and integration_name is None:  # noqa: E501
            raise ValueError("Invalid value for `integration_name`, must not be `None`")  # noqa: E501

        self._integration_name = integration_name

    @property
    def status(self):
        """Gets the status of this GcsSourceWrapper.  # noqa: E501


        :return: The status of this GcsSourceWrapper.  # noqa: E501
        :rtype: Status
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this GcsSourceWrapper.


        :param status: The status of this GcsSourceWrapper.  # noqa: E501
        :type status: Status
        """

        self._status = status

    @property
    def bucket(self):
        """Gets the bucket of this GcsSourceWrapper.  # noqa: E501

        name of GCS bucket you want to ingest from  # noqa: E501

        :return: The bucket of this GcsSourceWrapper.  # noqa: E501
        :rtype: str
        """
        return self._bucket

    @bucket.setter
    def bucket(self, bucket):
        """Sets the bucket of this GcsSourceWrapper.

        name of GCS bucket you want to ingest from  # noqa: E501

        :param bucket: The bucket of this GcsSourceWrapper.  # noqa: E501
        :type bucket: str
        """

        self._bucket = bucket

    @property
    def object_bytes_total(self):
        """Gets the object_bytes_total of this GcsSourceWrapper.  # noqa: E501


        :return: The object_bytes_total of this GcsSourceWrapper.  # noqa: E501
        :rtype: int
        """
        return self._object_bytes_total

    @object_bytes_total.setter
    def object_bytes_total(self, object_bytes_total):
        """Sets the object_bytes_total of this GcsSourceWrapper.


        :param object_bytes_total: The object_bytes_total of this GcsSourceWrapper.  # noqa: E501
        :type object_bytes_total: int
        """

        self._object_bytes_total = object_bytes_total

    @property
    def object_count_downloaded(self):
        """Gets the object_count_downloaded of this GcsSourceWrapper.  # noqa: E501


        :return: The object_count_downloaded of this GcsSourceWrapper.  # noqa: E501
        :rtype: int
        """
        return self._object_count_downloaded

    @object_count_downloaded.setter
    def object_count_downloaded(self, object_count_downloaded):
        """Sets the object_count_downloaded of this GcsSourceWrapper.


        :param object_count_downloaded: The object_count_downloaded of this GcsSourceWrapper.  # noqa: E501
        :type object_count_downloaded: int
        """

        self._object_count_downloaded = object_count_downloaded

    @property
    def object_count_total(self):
        """Gets the object_count_total of this GcsSourceWrapper.  # noqa: E501


        :return: The object_count_total of this GcsSourceWrapper.  # noqa: E501
        :rtype: int
        """
        return self._object_count_total

    @object_count_total.setter
    def object_count_total(self, object_count_total):
        """Sets the object_count_total of this GcsSourceWrapper.


        :param object_count_total: The object_count_total of this GcsSourceWrapper.  # noqa: E501
        :type object_count_total: int
        """

        self._object_count_total = object_count_total

    @property
    def pattern(self):
        """Gets the pattern of this GcsSourceWrapper.  # noqa: E501

        Glob-style pattern that selects keys to ingest. Only either prefix or pattern can be specified.  # noqa: E501

        :return: The pattern of this GcsSourceWrapper.  # noqa: E501
        :rtype: str
        """
        return self._pattern

    @pattern.setter
    def pattern(self, pattern):
        """Sets the pattern of this GcsSourceWrapper.

        Glob-style pattern that selects keys to ingest. Only either prefix or pattern can be specified.  # noqa: E501

        :param pattern: The pattern of this GcsSourceWrapper.  # noqa: E501
        :type pattern: str
        """

        self._pattern = pattern

    @property
    def prefix(self):
        """Gets the prefix of this GcsSourceWrapper.  # noqa: E501

        Prefix that selects keys to ingest.  # noqa: E501

        :return: The prefix of this GcsSourceWrapper.  # noqa: E501
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """Sets the prefix of this GcsSourceWrapper.

        Prefix that selects keys to ingest.  # noqa: E501

        :param prefix: The prefix of this GcsSourceWrapper.  # noqa: E501
        :type prefix: str
        """

        self._prefix = prefix

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GcsSourceWrapper):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GcsSourceWrapper):
            return True

        return self.to_dict() != other.to_dict()
