# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['sys_vars']
setup_kwargs = {
    'name': 'sys-vars',
    'version': '4.0.1',
    'description': 'Access system variables in your code as native Python data types.',
    'long_description': '# sys-vars\n\n> Access system variables in your code as native Python data types.\n\n## Usage\n\nRequires Python 3.7+\n\nPrefers the Linux Docker secrets directory (`/run/secrets`)\nover system environment variables.\nIf an alternate sys vars path is required,\nset the following key-value in your OS environment:\n`SYS_VARS_PATH="<directory-path-to-vars>"`\n\n```python\nimport sys_vars\n\n\n# Returns <class \'str\'>\n# Default values can be specified if the key is missing\nsys_vars.get("HOST_ADDRESS", default="localhost")\n\n# Returns <class \'bool\'>\n# Default values are supported for casting methods too\n# Also treats "t", "true", "y", "yes" as True value\nsys_vars.get_bool("DEBUG_MODE", default=False)\n\n# Returns <class \'datetime.datetime\'>\nsys_vars.get_datetime("LAST_SYNC_RUN")\n\n# Returns <class \'float\'>\nsys_vars.get_float("pi")\n\n# Returns <class \'int\'>\nsys_vars.get_int("THE_MEANING_OF_LIFE")\n\n# Returns <class \'dict\'> or <class \'list\'>\n# Automatically decodes JSON strings into dictionaries/lists\nsys_vars.get_json("CONFIGURED_TERMS")\n\n# Returns <class \'pathlib.Path\'>\nsys_vars.get_path("CONFIG_PATH")\n```\n\n## Building\n\n1. Install [Poetry](https://python-poetry.org/)\n\n1. Run `poetry install`\n\n1. Run `poetry build`\n\nThe .whl file will be located at `./dist/sys_vars-<x.y.z>-py3-none-any.whl`\n',
    'author': 'Caleb Ely',
    'author_email': 'le717@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/le717/sys-vars',
    'py_modules': modules,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
