"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const appscaling = require("@aws-cdk/aws-applicationautoscaling");
/**
 * A scalable table attribute
 */
class ScalableTableAttribute extends appscaling.BaseScalableAttribute {
    /**
     * Scale out or in based on time
     */
    scaleOnSchedule(id, action) {
        super.doScaleOnSchedule(id, action);
    }
    /**
     * Scale out or in to keep utilization at a given level
     */
    scaleOnUtilization(props) {
        if (props.targetUtilizationPercent < 10 || props.targetUtilizationPercent > 90) {
            // tslint:disable-next-line:max-line-length
            throw new RangeError(`targetUtilizationPercent for DynamoDB scaling must be between 10 and 90 percent, got: ${props.targetUtilizationPercent}`);
        }
        const predefinedMetric = this.props.dimension.indexOf('ReadCapacity') === -1
            ? appscaling.PredefinedMetric.DYANMODB_WRITE_CAPACITY_UTILIZATION
            : appscaling.PredefinedMetric.DYNAMODB_READ_CAPACITY_UTILIZATION;
        super.doScaleToTrackMetric('Tracking', {
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
            targetValue: props.targetUtilizationPercent,
            predefinedMetric,
        });
    }
}
exports.ScalableTableAttribute = ScalableTableAttribute;
//# sourceMappingURL=data:application/json;base64,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