"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerBuild = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf_local_exec_1 = require("cdktf-local-exec");
/**
 * @stability stable
 */
class DockerBuild extends cdktf_local_exec_1.LocalExec {
    /**
     * @stability stable
     */
    constructor(scope, name, { cwd, dockerfile, tag, push, auth }) {
        const commands = [];
        if (auth) {
            commands.push(`docker login -u ${auth.userName} -p ${auth.password} ${auth.proxyEndpoint}`);
        }
        commands.push(`docker build ${dockerfile ? `-f ${dockerfile}` : ""} -t ${tag} .`);
        if (push !== false) {
            commands.push(`docker push ${tag}`);
        }
        super(scope, name, {
            cwd: cwd,
            command: commands.join(" && "),
            copyBeforeRun: false,
        });
    }
}
exports.DockerBuild = DockerBuild;
_a = JSII_RTTI_SYMBOL_1;
DockerBuild[_a] = { fqn: "cdktf-local-build.DockerBuild", version: "0.0.11" };
//# sourceMappingURL=data:application/json;base64,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