"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractAsyncToJSON = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
/**
 * combines the potentially paginated response from async Textract calls and stores as one combines JSON.
 *
 * This construct is not memory optimzed (yet) and will combine all JSON by loading them to memory.
 * Large responses could exceed the memory potentially, the memory size is set to Lambda max.
 *
 * Reduce the memory size to your needs if your processing does not yield large responses to save Lamda cost.
 *
 *
 * Input: "textract_result"."TextractTempOutputJsonPath"
 * Output: "TextractOutputJsonPath"
 *
 * Example (Python)
 * ```python
    textract_async_to_json = tcdk.TextractAsyncToJSON(
        self,
        "TextractAsyncToJSON2",
        s3_output_prefix=s3_output_prefix,
        s3_output_bucket=s3_output_bucket)
  ```
 */
class TextractAsyncToJSON extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var lambdaLogLevel = props.lambdaLogLevel === undefined ? 'DEBUG' : props.lambdaLogLevel;
        var lambdaTimeout = props.lambdaTimeout === undefined ? 900 : props.lambdaTimeout;
        var lambdaMemoryMB = props.lambdaMemoryMB === undefined ? 10240 : props.lambdaMemoryMB;
        const asyncToJSONFunction = new lambda.DockerImageFunction(this, 'TextractAsyncToJSON', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/async_to_json/')),
            memorySize: lambdaMemoryMB,
            environment: {
                S3_OUTPUT_BUCKET: props.s3OutputBucket,
                S3_OUTPUT_PREFIX: props.s3OutputPrefix,
                LOG_LEVEL: lambdaLogLevel,
            },
            timeout: aws_cdk_lib_1.Duration.seconds(lambdaTimeout),
        });
        asyncToJSONFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['s3:Get*', 's3:List*', 's3:Put*'],
            resources: ['*'],
        }));
        const asyncToJSON = new tasks.LambdaInvoke(this, id, {
            lambdaFunction: asyncToJSONFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(900),
            outputPath: '$.Payload',
        });
        this.startState = asyncToJSON;
        this.endStates = [asyncToJSON];
    }
}
exports.TextractAsyncToJSON = TextractAsyncToJSON;
_a = JSII_RTTI_SYMBOL_1;
TextractAsyncToJSON[_a] = { fqn: "amazon-textract-idp-cdk-constructs.TextractAsyncToJSON", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,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