"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractPOCDecider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
/**
 * This construct takes in a manifest definition or a plain JSON with a s3Path:
 *
 * example s3Path:
 * {"s3Path": "s3://bucketname/prefix/image.png"}
 *
 *
 * Then it generated the numberOfPages attribute and the mime on the context.
 * The mime types checked against the supported mime types for Textract and if fails, will raise an Exception failing the workflow.
 *
 * Example (Python)
 * ```python
   decider_task_id = tcdk.TextractPOCDecider(
        self,
        f"InsuranceDecider",
   )
  ```

 *
 */
class TextractPOCDecider extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var lambdaMemoryMB = props.lambdaMemoryMB === undefined ? 1024 : props.lambdaMemoryMB;
        var lambdaTimeout = props.lambdaTimeout === undefined ? 900 : props.lambdaTimeout;
        const deciderFunction = new lambda.DockerImageFunction(this, 'TextractDecider', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/decider/')),
            memorySize: lambdaMemoryMB,
            timeout: aws_cdk_lib_1.Duration.seconds(lambdaTimeout),
        });
        deciderFunction.addToRolePolicy(new iam.PolicyStatement({ actions: ['s3:GetObject'], resources: ['*'] }));
        const deciderLambdaInvoke = new tasks.LambdaInvoke(this, id, {
            lambdaFunction: deciderFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            outputPath: '$.Payload',
        });
        this.startState = deciderLambdaInvoke;
        this.endStates = [deciderLambdaInvoke];
    }
}
exports.TextractPOCDecider = TextractPOCDecider;
_a = JSII_RTTI_SYMBOL_1;
TextractPOCDecider[_a] = { fqn: "amazon-textract-idp-cdk-constructs.TextractPOCDecider", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,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