"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractClassificationConfigurator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
const cfnCustomResourceConfiguratorPrefill_1 = require("./cfnCustomResourceConfiguratorPrefill");
/**
 * Looks for a matching DOCYMENT_TYPE in the configurationTableName
 * and sets the CONFIG value (when found) to the context, so subsequent calls to
 * Textract use those values.
 *
 * This is an entry from the default config
 * AWS_PAYSTUBS,"{""queriesConfig"": [{""alias"": ""PAYSTUB_PERIOD_START_DATE"", ""text"": ""What is the Pay Period Start Date?""}, {""alias"": ""PAYSTUB_PERIOD_END_DATE"", ""text"": ""What is the Pay Period End Date?""}, {""alias"": ""PAYSTUB_PERIOD_PAY_DATE"", ""text"": ""What is the Pay Date?""}, {""alias"": ""PAYSTUB_PERIOD_EMPLOYEE_NAME"", ""text"": ""What is the Employee Name?""}, {""alias"": ""PAYSTUB_PERIOD_COMPANY_NAME"", ""text"": ""What is the company Name?""}, {""alias"": ""PAYSTUB_PERIOD_CURRENT_GROSS_PAY"", ""text"": ""What is the Current Gross Pay?""}, {""alias"": ""PAYSTUB_PERIOD_YTD_GROSS_PAY"", ""text"": ""What is the YTD Gross Pay?""}, {""alias"": ""PAYSTUB_PERIOD_REGULAR_HOURLY_RATE"", ""text"": ""What is the regular hourly rate?""}, {""alias"": ""PAYSTUB_PERIOD_HOLIDAY_RATE"", ""text"": ""What is the holiday rate?""}], ""textractFeatures"": [""QUERIES""]}"
 *
 * So, if the "classification"."documentType" in the Step Function Input is AWS_PAYSTUBS
 * then it will set the queriesConfig in the manifest for the subsequent Textract Calls in the Step Function flow
 *
 * Input: "classification"."documentType"
 * Output: config set to manifest
 *
 * Example (Python)
 * ```
    configurator_task = tcdk.TextractClassificationConfigurator(
        self, f"{workflow_name}-Configurator",
    )

 * ```
 */
class TextractClassificationConfigurator extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        const configurationTable = new dynamodb.Table(this, 'TextractConfigurationTable', {
            partitionKey: {
                name: 'DOCUMENT_TYPE',
                type: dynamodb.AttributeType.STRING,
            },
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
        });
        this.configurationTableName = configurationTable.tableName;
        const textractDocTypeConfig = new cfnCustomResourceConfiguratorPrefill_1.TextractConfiguration(this, 'DocTypeConfig', {
            configuration_table: configurationTable.tableName,
        });
        textractDocTypeConfig.node.addDependency(configurationTable);
        var lambdaMemoryMB = props.lambdaMemoryMB === undefined ? 1024 : props.lambdaMemoryMB;
        var lambdaTimeout = props.lambdaTimeout === undefined ? 900 : props.lambdaTimeout;
        var lambdaLogLevel = props.lambdaLogLevel === undefined ? 'DEBUG' : props.lambdaLogLevel;
        this.configuratorFunction = new lambda.DockerImageFunction(this, 'ClassificationConfigurator', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/configurator/')),
            memorySize: lambdaMemoryMB,
            timeout: aws_cdk_lib_1.Duration.seconds(lambdaTimeout),
            environment: {
                CONFIGURATION_TABLE: configurationTable.tableName,
                LOG_LEVEL: lambdaLogLevel,
            },
        });
        this.configuratorFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['dynamodb:PutItem', 'dynamodb:GetItem'],
            resources: [configurationTable.tableArn],
        }));
        this.configuratorFunctionLogGroupName = this.configuratorFunction.logGroup.logGroupName;
        const configuratorLambdaInvoke = new tasks.LambdaInvoke(this, id, {
            lambdaFunction: this.configuratorFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            outputPath: '$.Payload',
        });
        this.startState = configuratorLambdaInvoke;
        this.endStates = [configuratorLambdaInvoke];
    }
}
exports.TextractClassificationConfigurator = TextractClassificationConfigurator;
_a = JSII_RTTI_SYMBOL_1;
TextractClassificationConfigurator[_a] = { fqn: "amazon-textract-idp-cdk-constructs.TextractClassificationConfigurator", version: "0.0.5" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGV4dHJhY3RDbGFzc2lmaWNhdGlvbkNvbmZpZ3VyYXRvci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy90ZXh0cmFjdENsYXNzaWZpY2F0aW9uQ29uZmlndXJhdG9yLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkJBQTZCO0FBQzdCLDZDQUFzRDtBQUN0RCxxREFBcUQ7QUFDckQsMkNBQTJDO0FBQzNDLGlEQUFpRDtBQUNqRCxxREFBcUQ7QUFDckQsNkRBQTZEO0FBRTdELGlHQUErRTtBQVMvRTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBcUJHO0FBQ0gsTUFBYSxrQ0FBbUMsU0FBUSxHQUFHLENBQUMsb0JBQW9CO0lBTzlFLFlBQVksTUFBaUIsRUFBRSxFQUFVLEVBQUUsS0FBOEM7UUFDdkYsS0FBSyxDQUFDLE1BQU0sRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVsQixNQUFNLGtCQUFrQixHQUFHLElBQUksUUFBUSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsNEJBQTRCLEVBQUU7WUFDaEYsWUFBWSxFQUFFO2dCQUNaLElBQUksRUFBRSxlQUFlO2dCQUNyQixJQUFJLEVBQUUsUUFBUSxDQUFDLGFBQWEsQ0FBQyxNQUFNO2FBQ3BDO1lBQ0QsYUFBYSxFQUFFLDJCQUFhLENBQUMsT0FBTztZQUNwQyxXQUFXLEVBQUUsUUFBUSxDQUFDLFdBQVcsQ0FBQyxlQUFlO1NBQ2xELENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxzQkFBc0IsR0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUM7UUFFekQsTUFBTSxxQkFBcUIsR0FBRyxJQUFJLDREQUFxQixDQUFDLElBQUksRUFBRSxlQUFlLEVBQUU7WUFDN0UsbUJBQW1CLEVBQUUsa0JBQWtCLENBQUMsU0FBUztTQUNsRCxDQUFDLENBQUM7UUFDSCxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFFN0QsSUFBSSxjQUFjLEdBQUUsS0FBSyxDQUFDLGNBQWMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUNyRixJQUFJLGFBQWEsR0FBRSxLQUFLLENBQUMsYUFBYSxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDO1FBQ2pGLElBQUksY0FBYyxHQUFFLEtBQUssQ0FBQyxjQUFjLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxjQUFjLENBQUM7UUFFeEYsSUFBSSxDQUFDLG9CQUFvQixHQUFHLElBQUksTUFBTSxDQUFDLG1CQUFtQixDQUFDLElBQUksRUFBRSw0QkFBNEIsRUFBRTtZQUM3RixJQUFJLEVBQUUsTUFBTSxDQUFDLGVBQWUsQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUseUJBQXlCLENBQUMsQ0FBQztZQUM1RixVQUFVLEVBQUUsY0FBYztZQUMxQixPQUFPLEVBQUUsc0JBQVEsQ0FBQyxPQUFPLENBQUMsYUFBYSxDQUFDO1lBQ3hDLFdBQVcsRUFBRTtnQkFDWCxtQkFBbUIsRUFBRSxrQkFBa0IsQ0FBQyxTQUFTO2dCQUNqRCxTQUFTLEVBQUUsY0FBYzthQUMxQjtTQUNGLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxlQUFlLENBQUMsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO1lBQ2hFLE9BQU8sRUFBRSxDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixDQUFDO1lBQ2pELFNBQVMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQztTQUN6QyxDQUFDLENBQUMsQ0FBQztRQUNKLElBQUksQ0FBQyxnQ0FBZ0MsR0FBb0IsSUFBSSxDQUFDLG9CQUFxQixDQUFDLFFBQVEsQ0FBQyxZQUFZLENBQUM7UUFFMUcsTUFBTSx3QkFBd0IsR0FBRyxJQUFJLEtBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRTtZQUNoRSxjQUFjLEVBQUUsSUFBSSxDQUFDLG9CQUFvQjtZQUN6QyxPQUFPLEVBQUUsc0JBQVEsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDO1lBQzlCLFVBQVUsRUFBRSxXQUFXO1NBQ3hCLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxVQUFVLEdBQUMsd0JBQXdCLENBQUM7UUFDekMsSUFBSSxDQUFDLFNBQVMsR0FBQyxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDNUMsQ0FBQzs7QUFuREgsZ0ZBb0RDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCB7IER1cmF0aW9uLCBSZW1vdmFsUG9saWN5IH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0ICogYXMgZHluYW1vZGIgZnJvbSAnYXdzLWNkay1saWIvYXdzLWR5bmFtb2RiJztcbmltcG9ydCAqIGFzIGlhbSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIHNmbiBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtc3RlcGZ1bmN0aW9ucyc7XG5pbXBvcnQgKiBhcyB0YXNrcyBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtc3RlcGZ1bmN0aW9ucy10YXNrcyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IFRleHRyYWN0Q29uZmlndXJhdGlvbiB9IGZyb20gJy4vY2ZuQ3VzdG9tUmVzb3VyY2VDb25maWd1cmF0b3JQcmVmaWxsJztcblxuZXhwb3J0IGludGVyZmFjZSBUZXh0cmFjdENsYXNzaWZpY2F0aW9uQ29uZmlndXJhdG9yUHJvcHMge1xuICAvKiogbWVtb3J5IG9mIExhbWJkYSBmdW5jdGlvbiAobWF5IG5lZWQgdG8gaW5jcmVhc2UgZm9yIGxhcmdlciBkb2N1bWVudHMpICovXG4gIHJlYWRvbmx5IGxhbWJkYU1lbW9yeU1CPzpudW1iZXI7XG4gIHJlYWRvbmx5IGxhbWJkYVRpbWVvdXQ/Om51bWJlcjtcbiAgcmVhZG9ubHkgbGFtYmRhTG9nTGV2ZWw/OnN0cmluZztcbn1cblxuLyoqXG4gKiBMb29rcyBmb3IgYSBtYXRjaGluZyBET0NZTUVOVF9UWVBFIGluIHRoZSBjb25maWd1cmF0aW9uVGFibGVOYW1lXG4gKiBhbmQgc2V0cyB0aGUgQ09ORklHIHZhbHVlICh3aGVuIGZvdW5kKSB0byB0aGUgY29udGV4dCwgc28gc3Vic2VxdWVudCBjYWxscyB0b1xuICogVGV4dHJhY3QgdXNlIHRob3NlIHZhbHVlcy5cbiAqXG4gKiBUaGlzIGlzIGFuIGVudHJ5IGZyb20gdGhlIGRlZmF1bHQgY29uZmlnXG4gKiBBV1NfUEFZU1RVQlMsXCJ7XCJcInF1ZXJpZXNDb25maWdcIlwiOiBbe1wiXCJhbGlhc1wiXCI6IFwiXCJQQVlTVFVCX1BFUklPRF9TVEFSVF9EQVRFXCJcIiwgXCJcInRleHRcIlwiOiBcIlwiV2hhdCBpcyB0aGUgUGF5IFBlcmlvZCBTdGFydCBEYXRlP1wiXCJ9LCB7XCJcImFsaWFzXCJcIjogXCJcIlBBWVNUVUJfUEVSSU9EX0VORF9EQVRFXCJcIiwgXCJcInRleHRcIlwiOiBcIlwiV2hhdCBpcyB0aGUgUGF5IFBlcmlvZCBFbmQgRGF0ZT9cIlwifSwge1wiXCJhbGlhc1wiXCI6IFwiXCJQQVlTVFVCX1BFUklPRF9QQVlfREFURVwiXCIsIFwiXCJ0ZXh0XCJcIjogXCJcIldoYXQgaXMgdGhlIFBheSBEYXRlP1wiXCJ9LCB7XCJcImFsaWFzXCJcIjogXCJcIlBBWVNUVUJfUEVSSU9EX0VNUExPWUVFX05BTUVcIlwiLCBcIlwidGV4dFwiXCI6IFwiXCJXaGF0IGlzIHRoZSBFbXBsb3llZSBOYW1lP1wiXCJ9LCB7XCJcImFsaWFzXCJcIjogXCJcIlBBWVNUVUJfUEVSSU9EX0NPTVBBTllfTkFNRVwiXCIsIFwiXCJ0ZXh0XCJcIjogXCJcIldoYXQgaXMgdGhlIGNvbXBhbnkgTmFtZT9cIlwifSwge1wiXCJhbGlhc1wiXCI6IFwiXCJQQVlTVFVCX1BFUklPRF9DVVJSRU5UX0dST1NTX1BBWVwiXCIsIFwiXCJ0ZXh0XCJcIjogXCJcIldoYXQgaXMgdGhlIEN1cnJlbnQgR3Jvc3MgUGF5P1wiXCJ9LCB7XCJcImFsaWFzXCJcIjogXCJcIlBBWVNUVUJfUEVSSU9EX1lURF9HUk9TU19QQVlcIlwiLCBcIlwidGV4dFwiXCI6IFwiXCJXaGF0IGlzIHRoZSBZVEQgR3Jvc3MgUGF5P1wiXCJ9LCB7XCJcImFsaWFzXCJcIjogXCJcIlBBWVNUVUJfUEVSSU9EX1JFR1VMQVJfSE9VUkxZX1JBVEVcIlwiLCBcIlwidGV4dFwiXCI6IFwiXCJXaGF0IGlzIHRoZSByZWd1bGFyIGhvdXJseSByYXRlP1wiXCJ9LCB7XCJcImFsaWFzXCJcIjogXCJcIlBBWVNUVUJfUEVSSU9EX0hPTElEQVlfUkFURVwiXCIsIFwiXCJ0ZXh0XCJcIjogXCJcIldoYXQgaXMgdGhlIGhvbGlkYXkgcmF0ZT9cIlwifV0sIFwiXCJ0ZXh0cmFjdEZlYXR1cmVzXCJcIjogW1wiXCJRVUVSSUVTXCJcIl19XCJcbiAqXG4gKiBTbywgaWYgdGhlIFwiY2xhc3NpZmljYXRpb25cIi5cImRvY3VtZW50VHlwZVwiIGluIHRoZSBTdGVwIEZ1bmN0aW9uIElucHV0IGlzIEFXU19QQVlTVFVCU1xuICogdGhlbiBpdCB3aWxsIHNldCB0aGUgcXVlcmllc0NvbmZpZyBpbiB0aGUgbWFuaWZlc3QgZm9yIHRoZSBzdWJzZXF1ZW50IFRleHRyYWN0IENhbGxzIGluIHRoZSBTdGVwIEZ1bmN0aW9uIGZsb3dcbiAqXG4gKiBJbnB1dDogXCJjbGFzc2lmaWNhdGlvblwiLlwiZG9jdW1lbnRUeXBlXCJcbiAqIE91dHB1dDogY29uZmlnIHNldCB0byBtYW5pZmVzdFxuICpcbiAqIEV4YW1wbGUgKFB5dGhvbilcbiAqIGBgYFxuICAgIGNvbmZpZ3VyYXRvcl90YXNrID0gdGNkay5UZXh0cmFjdENsYXNzaWZpY2F0aW9uQ29uZmlndXJhdG9yKFxuICAgICAgICBzZWxmLCBmXCJ7d29ya2Zsb3dfbmFtZX0tQ29uZmlndXJhdG9yXCIsXG4gICAgKVxuXG4gKiBgYGBcbiAqL1xuZXhwb3J0IGNsYXNzIFRleHRyYWN0Q2xhc3NpZmljYXRpb25Db25maWd1cmF0b3IgZXh0ZW5kcyBzZm4uU3RhdGVNYWNoaW5lRnJhZ21lbnQge1xuICBwdWJsaWMgcmVhZG9ubHkgc3RhcnRTdGF0ZTogc2ZuLlN0YXRlO1xuICBwdWJsaWMgcmVhZG9ubHkgZW5kU3RhdGVzOiBzZm4uSU5leHRhYmxlW107XG4gIHB1YmxpYyBjb25maWd1cmF0b3JGdW5jdGlvbjpsYW1iZGEuSUZ1bmN0aW9uO1xuICBwdWJsaWMgY29uZmlndXJhdG9yRnVuY3Rpb25Mb2dHcm91cE5hbWU6c3RyaW5nO1xuICBwdWJsaWMgY29uZmlndXJhdGlvblRhYmxlTmFtZTpzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IocGFyZW50OiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBUZXh0cmFjdENsYXNzaWZpY2F0aW9uQ29uZmlndXJhdG9yUHJvcHMpIHtcbiAgICBzdXBlcihwYXJlbnQsIGlkKTtcblxuICAgIGNvbnN0IGNvbmZpZ3VyYXRpb25UYWJsZSA9IG5ldyBkeW5hbW9kYi5UYWJsZSh0aGlzLCAnVGV4dHJhY3RDb25maWd1cmF0aW9uVGFibGUnLCB7XG4gICAgICBwYXJ0aXRpb25LZXk6IHtcbiAgICAgICAgbmFtZTogJ0RPQ1VNRU5UX1RZUEUnLFxuICAgICAgICB0eXBlOiBkeW5hbW9kYi5BdHRyaWJ1dGVUeXBlLlNUUklORyxcbiAgICAgIH0sXG4gICAgICByZW1vdmFsUG9saWN5OiBSZW1vdmFsUG9saWN5LkRFU1RST1ksXG4gICAgICBiaWxsaW5nTW9kZTogZHluYW1vZGIuQmlsbGluZ01vZGUuUEFZX1BFUl9SRVFVRVNULFxuICAgIH0pO1xuICAgIHRoaXMuY29uZmlndXJhdGlvblRhYmxlTmFtZT1jb25maWd1cmF0aW9uVGFibGUudGFibGVOYW1lO1xuXG4gICAgY29uc3QgdGV4dHJhY3REb2NUeXBlQ29uZmlnID0gbmV3IFRleHRyYWN0Q29uZmlndXJhdGlvbih0aGlzLCAnRG9jVHlwZUNvbmZpZycsIHtcbiAgICAgIGNvbmZpZ3VyYXRpb25fdGFibGU6IGNvbmZpZ3VyYXRpb25UYWJsZS50YWJsZU5hbWUsXG4gICAgfSk7XG4gICAgdGV4dHJhY3REb2NUeXBlQ29uZmlnLm5vZGUuYWRkRGVwZW5kZW5jeShjb25maWd1cmF0aW9uVGFibGUpO1xuXG4gICAgdmFyIGxhbWJkYU1lbW9yeU1CPSBwcm9wcy5sYW1iZGFNZW1vcnlNQiA9PT0gdW5kZWZpbmVkID8gMTAyNCA6IHByb3BzLmxhbWJkYU1lbW9yeU1CO1xuICAgIHZhciBsYW1iZGFUaW1lb3V0PSBwcm9wcy5sYW1iZGFUaW1lb3V0ID09PSB1bmRlZmluZWQgPyA5MDAgOiBwcm9wcy5sYW1iZGFUaW1lb3V0O1xuICAgIHZhciBsYW1iZGFMb2dMZXZlbD0gcHJvcHMubGFtYmRhTG9nTGV2ZWwgPT09IHVuZGVmaW5lZCA/ICdERUJVRycgOiBwcm9wcy5sYW1iZGFMb2dMZXZlbDtcblxuICAgIHRoaXMuY29uZmlndXJhdG9yRnVuY3Rpb24gPSBuZXcgbGFtYmRhLkRvY2tlckltYWdlRnVuY3Rpb24odGhpcywgJ0NsYXNzaWZpY2F0aW9uQ29uZmlndXJhdG9yJywge1xuICAgICAgY29kZTogbGFtYmRhLkRvY2tlckltYWdlQ29kZS5mcm9tSW1hZ2VBc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnLi4vbGFtYmRhL2NvbmZpZ3VyYXRvci8nKSksXG4gICAgICBtZW1vcnlTaXplOiBsYW1iZGFNZW1vcnlNQixcbiAgICAgIHRpbWVvdXQ6IER1cmF0aW9uLnNlY29uZHMobGFtYmRhVGltZW91dCksXG4gICAgICBlbnZpcm9ubWVudDoge1xuICAgICAgICBDT05GSUdVUkFUSU9OX1RBQkxFOiBjb25maWd1cmF0aW9uVGFibGUudGFibGVOYW1lLFxuICAgICAgICBMT0dfTEVWRUw6IGxhbWJkYUxvZ0xldmVsLFxuICAgICAgfSxcbiAgICB9KTtcbiAgICB0aGlzLmNvbmZpZ3VyYXRvckZ1bmN0aW9uLmFkZFRvUm9sZVBvbGljeShuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICBhY3Rpb25zOiBbJ2R5bmFtb2RiOlB1dEl0ZW0nLCAnZHluYW1vZGI6R2V0SXRlbSddLFxuICAgICAgcmVzb3VyY2VzOiBbY29uZmlndXJhdGlvblRhYmxlLnRhYmxlQXJuXSxcbiAgICB9KSk7XG4gICAgdGhpcy5jb25maWd1cmF0b3JGdW5jdGlvbkxvZ0dyb3VwTmFtZT0oPGxhbWJkYS5GdW5jdGlvbj4gdGhpcy5jb25maWd1cmF0b3JGdW5jdGlvbikubG9nR3JvdXAubG9nR3JvdXBOYW1lO1xuXG4gICAgY29uc3QgY29uZmlndXJhdG9yTGFtYmRhSW52b2tlID0gbmV3IHRhc2tzLkxhbWJkYUludm9rZSh0aGlzLCBpZCwge1xuICAgICAgbGFtYmRhRnVuY3Rpb246IHRoaXMuY29uZmlndXJhdG9yRnVuY3Rpb24sXG4gICAgICB0aW1lb3V0OiBEdXJhdGlvbi5zZWNvbmRzKDEwMCksXG4gICAgICBvdXRwdXRQYXRoOiAnJC5QYXlsb2FkJyxcbiAgICB9KTtcbiAgICB0aGlzLnN0YXJ0U3RhdGU9Y29uZmlndXJhdG9yTGFtYmRhSW52b2tlO1xuICAgIHRoaXMuZW5kU3RhdGVzPVtjb25maWd1cmF0b3JMYW1iZGFJbnZva2VdO1xuICB9XG59XG4iXX0=