"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextractConfiguration = void 0;
const path = require("path");
const cdk = require("aws-cdk-lib");
//import * as dynamodb from 'aws-cdk-lib/aws-dynamodb';
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const customResources = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
/**
 * CloudFormation Custom Resources importing default configuration values from default_config.csv
 * into DynamoDB table.
 * Used by the Configuration Construct to configure Textrat features.
 * The DynamoDB table can be configured to your requirements.
 * The configuration has to match the manifest format.
 * Essentially the Configuration construct looks up the classification
 * and if a match is found in the DynamoDB table, configures the context
 * manifest object to include the configuration.
 *
 */
class TextractConfiguration extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.configurationInit = new lambda.DockerImageFunction(this, id, {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/cfn_custom_configurator_prefill/')),
            memorySize: 128,
            timeout: cdk.Duration.seconds(600),
            environment: {
                LOG_LEVEL: 'DEBUG',
                CONFIGURATION_TABLE: props.configuration_table,
            },
        });
        this.configurationInit.addToRolePolicy(new iam.PolicyStatement({
            actions: ['dynamodb:PutItem', 'dynamodb:GetItem'],
            resources: ['*'],
        }));
        const provider = new customResources.Provider(this, 'Provider', {
            onEventHandler: this.configurationInit,
        });
        const resource = new cdk.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            properties: props,
        });
        this.response = resource.getAtt('Response').toString();
    }
}
exports.TextractConfiguration = TextractConfiguration;
//# sourceMappingURL=data:application/json;base64,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