# mypy-boto3-elb<a id="mypy-boto3-elb"></a>

[![PyPI - mypy-boto3-elb](https://img.shields.io/pypi/v/mypy-boto3-elb.svg?color=blue)](https://pypi.org/project/mypy-boto3-elb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-elb.svg?color=blue)](https://pypi.org/project/mypy-boto3-elb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-elb?color=blue)](https://pypistats.org/packages/mypy-boto3-elb)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ElasticLoadBalancing 1.17.84](https://boto3.amazonaws.com/v1/documentation/api/1.17.84/reference/services/elb.html#ElasticLoadBalancing)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.14.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-elb docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_elb/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-elb](#mypy-boto3-elb)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `ElasticLoadBalancing` service.

```bash
python -m pip install boto3-stubs[elb]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[elb]` in your environment:
  `python -m pip install 'boto3-stubs[elb]'`

Both type checking and auto-complete should work for `ElasticLoadBalancing`
service. No explicit type annotations required, write your `boto3` code as
usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[elb]` in your environment:
  `python -m pip install 'boto3-stubs[elb]'`

Both type checking and auto-complete should work for `ElasticLoadBalancing`
service. No explicit type annotations required, write your `boto3` code as
usual. Auto-complete can be slow on big projects or if you have a lot of
installed `boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[elb]` in your environment:
  `python -m pip install 'boto3-stubs[elb]'`
- Run `mypy` as usual

Type checking should work for `ElasticLoadBalancing` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[elb]` in your environment:
  `python -m pip install 'boto3-stubs[elb]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ElasticLoadBalancing` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`ElasticLoadBalancingClient` provides annotations for `boto3.client("elb")`.

```python
import boto3

from mypy_boto3_elb import ElasticLoadBalancingClient

client: ElasticLoadBalancingClient = boto3.client("elb")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ElasticLoadBalancingClient = session.client("elb")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_elb.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_elb import ElasticLoadBalancingClient
from mypy_boto3_elb.paginator import (
    DescribeAccountLimitsPaginator,
    DescribeLoadBalancersPaginator,
)

client: ElasticLoadBalancingClient = boto3.client("elb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_account_limits_paginator: DescribeAccountLimitsPaginator = client.get_paginator("describe_account_limits")
describe_load_balancers_paginator: DescribeLoadBalancersPaginator = client.get_paginator("describe_load_balancers")
```

### Waiters annotations<a id="waiters-annotations"></a>

`mypy_boto3_elb.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_elb import ElasticLoadBalancingClient
from mypy_boto3_elb.waiter import (
    AnyInstanceInServiceWaiter,
    InstanceDeregisteredWaiter,
    InstanceInServiceWaiter,
)

client: ElasticLoadBalancingClient = boto3.client("elb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
any_instance_in_service_waiter: AnyInstanceInServiceWaiter = client.get_waiter("any_instance_in_service")
instance_deregistered_waiter: InstanceDeregisteredWaiter = client.get_waiter("instance_deregistered")
instance_in_service_waiter: InstanceInServiceWaiter = client.get_waiter("instance_in_service")
```

### Literals<a id="literals"></a>

`mypy_boto3_elb.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_elb.literals import (
    AnyInstanceInServiceWaiterName,
    DescribeAccountLimitsPaginatorName,
    DescribeLoadBalancersPaginatorName,
    InstanceDeregisteredWaiterName,
    InstanceInServiceWaiterName,
)

def check_value(value: AnyInstanceInServiceWaiterName) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_elb.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_elb.type_defs import (
    AccessLogTypeDef,
    AddAvailabilityZonesOutputTypeDef,
    AdditionalAttributeTypeDef,
    AppCookieStickinessPolicyTypeDef,
    ApplySecurityGroupsToLoadBalancerOutputTypeDef,
    AttachLoadBalancerToSubnetsOutputTypeDef,
    BackendServerDescriptionTypeDef,
    ConfigureHealthCheckOutputTypeDef,
    ConnectionDrainingTypeDef,
    ConnectionSettingsTypeDef,
    CreateAccessPointOutputTypeDef,
    CrossZoneLoadBalancingTypeDef,
    DeregisterEndPointsOutputTypeDef,
    DescribeAccessPointsOutputTypeDef,
    DescribeAccountLimitsOutputTypeDef,
    DescribeEndPointStateOutputTypeDef,
    DescribeLoadBalancerAttributesOutputTypeDef,
    DescribeLoadBalancerPoliciesOutputTypeDef,
    DescribeLoadBalancerPolicyTypesOutputTypeDef,
    DescribeTagsOutputTypeDef,
    DetachLoadBalancerFromSubnetsOutputTypeDef,
    HealthCheckTypeDef,
    InstanceStateTypeDef,
    InstanceTypeDef,
    LBCookieStickinessPolicyTypeDef,
    LimitTypeDef,
    ListenerDescriptionTypeDef,
    ListenerTypeDef,
    LoadBalancerAttributesTypeDef,
    LoadBalancerDescriptionTypeDef,
    ModifyLoadBalancerAttributesOutputTypeDef,
    PaginatorConfigTypeDef,
    PoliciesTypeDef,
    PolicyAttributeDescriptionTypeDef,
    PolicyAttributeTypeDef,
    PolicyAttributeTypeDescriptionTypeDef,
    PolicyDescriptionTypeDef,
    PolicyTypeDescriptionTypeDef,
    RegisterEndPointsOutputTypeDef,
    RemoveAvailabilityZonesOutputTypeDef,
    ResponseMetadataTypeDef,
    SourceSecurityGroupTypeDef,
    TagDescriptionTypeDef,
    TagKeyOnlyTypeDef,
    TagTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AccessLogTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-elb` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-elb docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_elb/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
