# PyKaTeX

A Python wrapper for the [KaTeX](https://katex.org/) library, providing fast server-side rendering of mathematical expressions.

PyKaTeX uses a C extension module with [QuickJS-NG](https://github.com/quickjs-ng/quickjs) to enable Python to call into KaTeX, which is written in Javascript. The current version of PyKaTeX uses KaTeX v0.16.22 and QuickJS-NG v0.10.1.

⚠️ **PyKaTex is currently in alpha**. Some options are only partially supported  (see the "usage" section for more information) and KaTeX exceptions are not handled gracefully yet.


## Installation

```bash
pip install pykatex
```

Or, to install from source, clone the repository and run
```bash
pip install .
```

in the root of this repository.


## Usage

PyKaTeX provides a single function `renderToString` that takes a LaTeX string and optional keyword arguments:

```python
pykatex.renderToString(input, **options)
```

It can be used as follows:
```python
import pykatex as katex

html = katex.renderToString("E = mc^2",
                            displayMath=True,
                            output="html")

print(html)
```

Refer to the [KaTeX documentation](https://katex.org/docs/options) for the available options and their defaults.

Currently, there are the following limitations:
-  The `macros` option is not yet implemented
- Currently only string and boolean values are supported for the `strict` option (functions are not supported)


## Using the output

To view the rendered formula, you need to include KaTeX CSS in your HTML. You can use the following template:
```
<!-- KaTeX requires the use of the HTML5 doctype. Without it, KaTeX may not render properly -->
<!DOCTYPE html>
<html>
  <head>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/katex@0.16.22/dist/katex.min.css" integrity="sha384-5TcZemv2l/9On385z///+d7MSYlvIEw9FuZTIdZ14vJLqWphw7e7ZPuOiCHJcFCP" crossorigin="anonymous">
  </head>
  <body>
    <!-- include the output from renderToString here -->
  </body>
</html>
```

The stylesheet `katex.min.css` that the template links to is also vendored in the source here, as `src/katex/katex.min.css`. You can also host it yourself and use that, if you like.


## Architecture

PyKaTeX consists of:
- A Python C extension module (`pykatex.c`) that provides the Python interface
- QuickJS JavaScript engine (`src/quickjs/`) for executing KaTeX
- A wrapper script (`katex.js`) that calls into the KaTeX library (`src/katex/`)
- QuickJS bytecode (`katex.bytecode.h`) for the wrapper script, generated by the QuickJS-NG compiler `qjs`
- C wrapper code (`katex.c`) that bridges Python and JavaScript

The `katex.bytecode.h` file is generated by running
```
quickjs/build/qjsc -e -N katex -o katex.bytecode.h katex.js
```

in the `src/` folder, and manually remove the `JS_NewCustomContext` and `main` functions. This needs to be done again when the wrapper script or KaTeX library is changed (for example, when KaTeX is updated to a new version).


## License

This project bundles KaTeX and QuickJS-NG. Please refer to their respective licenses for terms and conditions.
