# Caer, in modules

`caer` contains functions to simplify common tasks used when developing and evaluating computer vision systems. A short description of the sub-modules is provided below. For more details about what functions are available and how to use them, please review the doc-strings provided with the code.

## Sub-modules

### [data](data)
Test images and example data.

### [distance](distance)
Distance-computing algorithms

### [exposure](exposure)
Image intensity adjustment, e.g., histogram equalization, etc.

### [features](features)
Feature detection and extraction, e.g., texture analysis corners, etc.

### [filters](filters)
Sharpening, edge finding, rank filters, thresholding, etc.

### [morph](morph)
Morphological operations, e.g., skeletonization.

### [path](path)
OS-specific Path Manipulations

### [preprocessing](preprocessing)
Image preprocessing utilities

### [segmentation](segmentation)
Partitioning an image into multiple regions.  

### [utils](utils)
Generic utilities.

### [video](video)
Video processing utilities