# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['gaphor',
 'gaphor.UML',
 'gaphor.UML.tests',
 'gaphor.diagram',
 'gaphor.diagram.actions',
 'gaphor.diagram.actions.tests',
 'gaphor.diagram.classes',
 'gaphor.diagram.classes.tests',
 'gaphor.diagram.components',
 'gaphor.diagram.components.tests',
 'gaphor.diagram.general',
 'gaphor.diagram.general.tests',
 'gaphor.diagram.interactions',
 'gaphor.diagram.interactions.tests',
 'gaphor.diagram.profiles',
 'gaphor.diagram.profiles.tests',
 'gaphor.diagram.states',
 'gaphor.diagram.states.tests',
 'gaphor.diagram.tests',
 'gaphor.diagram.usecases',
 'gaphor.diagram.usecases.tests',
 'gaphor.misc',
 'gaphor.misc.tests',
 'gaphor.plugins',
 'gaphor.plugins.console',
 'gaphor.plugins.console.tests',
 'gaphor.plugins.diagramexport',
 'gaphor.plugins.diagramexport.tests',
 'gaphor.plugins.xmiexport',
 'gaphor.plugins.xmiexport.tests',
 'gaphor.services',
 'gaphor.services.helpservice',
 'gaphor.services.tests',
 'gaphor.storage',
 'gaphor.storage.tests',
 'gaphor.tests',
 'gaphor.tools',
 'gaphor.ui',
 'gaphor.ui.tests']

package_data = \
{'': ['*'], 'gaphor': ['locale/*'], 'gaphor.ui': ['icons/*']}

install_requires = \
['PyGObject>=3.30,<4.0',
 'gaphas>=2.0,<3.0',
 'generic>=1.0.0,<2.0.0',
 'importlib_metadata>=1.4,<2.0',
 'pycairo>=1.18,<2.0',
 'typing_extensions>=3.7.4,<4.0.0']

entry_points = \
{'console_scripts': ['gaphor = gaphor.ui:main',
                     'gaphorconvert = gaphor.tools.gaphorconvert:main'],
 'gaphor.appservices': ['app_file_manager = '
                        'gaphor.ui.appfilemanager:AppFileManager',
                        'help = gaphor.services.helpservice:HelpService',
                        'session = gaphor.services.session:Session'],
 'gaphor.services': ['component_registry = '
                     'gaphor.services.componentregistry:ComponentRegistry',
                     'consolewindow = gaphor.plugins.console:ConsoleWindow',
                     'copy = gaphor.services.copyservice:CopyService',
                     'diagram_export = '
                     'gaphor.plugins.diagramexport:DiagramExport',
                     'diagrams = gaphor.ui.mainwindow:Diagrams',
                     'element_factory = '
                     'gaphor.UML.elementfactory:ElementFactory',
                     'elementeditor = gaphor.ui.elementeditor:ElementEditor',
                     'event_manager = '
                     'gaphor.services.eventmanager:EventManager',
                     'export_menu = gaphor.ui.menufragment:MenuFragment',
                     'file_manager = gaphor.ui.filemanager:FileManager',
                     'main_window = gaphor.ui.mainwindow:MainWindow',
                     'namespace = gaphor.ui.namespace:Namespace',
                     'preferences = gaphor.ui.preferences:Preferences',
                     'properties = gaphor.services.properties:Properties',
                     'recent_files = gaphor.ui.recentfiles:RecentFiles',
                     'sanitizer = '
                     'gaphor.services.sanitizerservice:SanitizerService',
                     'toolbox = gaphor.ui.toolbox:Toolbox',
                     'tools_menu = gaphor.ui.menufragment:MenuFragment',
                     'undo_manager = gaphor.services.undomanager:UndoManager',
                     'xmi_export = gaphor.plugins.xmiexport:XMIExport']}

setup_kwargs = {
    'name': 'gaphor',
    'version': '1.2.0',
    'description': 'Gaphor is the simple modeling tool written in Python.',
    'long_description': '# Gaphor <img src="logos/gaphor.svg" width="48">\n\n[![Build state](https://github.com/gaphor/gaphor/workflows/Build/badge.svg)](https://github.com/gaphor/gaphor/actions)\n[![Maintainability](https://api.codeclimate.com/v1/badges/f00974f5d7fe69fe4ecd/maintainability)](https://codeclimate.com/github/gaphor/gaphor/maintainability)\n[![Test Coverage](https://api.codeclimate.com/v1/badges/f00974f5d7fe69fe4ecd/test_coverage)](https://codeclimate.com/github/gaphor/gaphor/test_coverage)\n[![Docs build state](https://readthedocs.org/projects/gaphor/badge/?version=latest)](https://gaphor.readthedocs.io)\n[![PyPI](https://img.shields.io/pypi/v/gaphor.svg)](https://pypi.org/project/gaphor)\n[![Downloads](https://pepy.tech/badge/gaphor)](https://pepy.tech/project/gaphor)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)\n[![standard-readme compliant](https://img.shields.io/badge/readme%20style-standard-brightgreen.svg?style=flat)](https://github.com/RichardLitt/standard-readme)\n[![Gitter](https://img.shields.io/gitter/room/nwjs/nw.js.svg)](https://gitter.im/Gaphor/Lobby?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)\n[![All Contributors](https://img.shields.io/badge/all_contributors-24-orange.svg?style=flat-square)](#contributors)\n\n\n> Gaphor is the simple modeling tool for UML.\n\n![Gaphor Demo](docs/images/gaphor-demo.gif)\n\nGaphor is a simple and easy to use modeling tool for UML. It is aimed at\nbeginning modelers who want a simple and fast tool so that they can focus on\nlearning modeling of software and systems. It is not a full featured enterprise\ntool.\n\n## :bookmark_tabs: Table of Contents\n\n- [Background](#background)\n- [Install](#install)\n- [Usage](#usage)\n- [Contributing](#contributing)\n- [License](#license)\n\n## :scroll: Background\n\nGaphor is a UML modeling application written in Python. It is designed to be\neasy to use, while still being powerful. Gaphor implements a fully-compliant UML\n2 data model, so it is much more than a picture drawing tool. You can use Gaphor\nto quickly visualize different aspects of a system as well as create complete,\nhighly complex models.\n\nGaphor is designed around the following principles:\n\n- Simplicity: The application should be easy to use. Only some basic knowledge of UML is required.\n- Consistency: UML is a graphical modeling language, so all modeling is done in a diagram.\n- Workability: The application should not bother the user every time they do something non-UML-ish.\n\nGaphor is built on [Gaphas](https://github.com/gaphor/gaphas), which provides\nthe foundational diagramming library. It is a GUI application that is built on\nGTK and cairo, [PyGObject](https://pygobject.readthedocs.io/) provides access\nto the GUI toolkit, and [PyCairo](https://pycairo.readthedocs.io/) to the 2D\ngraphics library.\n\n## :floppy_disk: Install\n\n### Windows\nTo install Gaphor on Windows you an use the [latest Gaphor.exe installer](https://github.com/gaphor/gaphor/releases).\nThere are two versions:\n1. Full Windows installation\n2. Portable installation\n\n### Linux\nTo install Gaphor in Linux use Flatpak:\n1. [Install Flatpak](https://flatpak.org/setup)\n1. `flatpak remote-add --user --if-not-exists flathub https://dl.flathub.org/repo/flathub.flatpakrepo`\n1. `flatpak install --user flathub org.gaphor.Gaphor`\n\n### macOS\nWe are still working on packaging GTK with Gaphor and it is currently an\ninstallation pre-requisite.\n1. Install [homebrew](https://brew.sh)\n1. Open a terminal and execute:\n```bash\n$ brew install gobject-introspection gtk+3\n```\n\nThen install Gaphor on macOS using the [latest gaphor-macOS.dmg\ninstaller](https://github.com/gaphor/gaphor/releases).\n\n\nNote: Sometimes launching the app the first time after installation fails due\nto macOS security settings, please attempt to launch it a 2nd time if this\nhappens.\n\n### PyPI\nIf you have the latest stable version of Python installed and the Gaphor\ndependencies installed, you can also install Gaphor using a wheel from PyPI.\n\nIf you don\'t have the latest stable version of Python and the Gaphor dependencies\ninstalled, follow the development environment setup instructions in the next\nsection and instead of cloning the repository, create a\n[virtual environment](https://packaging.python.org/tutorials/installing-packages/#creating-virtual-environments),\nand then execute the following:\n\n```bash\n$ pip install gaphor\n$ gaphor\n```\n\n### Development\n\n#### Windows\n\nTo setup a development environment in Windows:\n1) Go to http://www.msys2.org/ and download the x86_64 installer\n1) Follow the instructions on the page for setting up the basic environment\n1) Run ``C:\\msys64\\mingw64.exe`` - a terminal window should pop up\n```bash\n$ pacman -Suy\n$ pacman -S git mingw-w64-x86-64-gcc mingw-w64-x86-64-gtk3 \\\nmingw-w64-x86-64-pkg-config mingw-w64-x86-64-cairo \\\nmingw-w64-x86-64-gobject-introspection mingw-w64-x86-64-python3 \\\nmingw-w64-x86-64-python3-importlib-metadata mingw-w64-x86-64-python3-gobject \\\nmingw-w64-x86-64-python3-cairo mingw-w64-x86-64-python3-pip \\\nmingw-w64-x86-64-python3-setuptools mingw-w64-x86-64-python3-zope.interface \\\nmingw-w64-x86-64-python3-coverage mingw-w64-x86-64-python3-pytest\n```\n\nEnsure `/mingw64/bin` is added to your `PATH`:\n```bash\n$ export PATH=/mingw64/bin:$PATH\n```\n\n[Clone the\nrepository](https://help.github.com/en/github/creating-cloning-and-archiving-repositories/cloning-a-repository).\n\n```bash\n$ cd gaphor\n$ source ./venv -S\n$ poetry run gaphor\n```\n\n#### Linux\nTo setup a development environment with Linux, you first need the latest\nstable version of Python. In order to get the latest stable version, we\nrecommend that you install [pyenv](https://github.com/pyenv/pyenv).\nInstall the pyenv\n[prerequisites](https://github.com/pyenv/pyenv/wiki/Common-build-problems#prerequisites)\nfirst, and then install pyenv:\n\n```bash\n$ curl https://pyenv.run | bash\n```\n\nMake sure you follow the instruction at the end of the installation script\nto install the commands in your shell\'s rc file. Finally install the latest\nversion of Python by executing:\n\n```bash\n$ pyenv install 3.x.x\n```\nWhere 3.x.x is replaced by the latest stable version of Python.\n\nNext install the Gaphor prerequisites by installing the gobject introspection\nand cairo build dependencies, for example, in Ubuntu execute:\n\n```bash\n$ sudo apt-get install -y python3-dev python3-gi python3-gi-cairo\n    gir1.2-gtk-3.0 libgirepository1.0-dev libcairo2-dev\n```\n[Clone the\nrepository](https://help.github.com/en/github/creating-cloning-and-archiving-repositories/cloning-a-repository).\n\n```\n$ cd gaphor\n$ source ./venv\n$ poetry run gaphor\n```\n\n#### macOS\nTo setup a development environment with macOS:\n1. Install [homebrew](https://brew.sh)\n1. Open a terminal and execute:\n```bash\n$ brew install python3 gobject-introspection gtk+3\n```\n[Clone the\nrepository](https://help.github.com/en/github/creating-cloning-and-archiving-repositories/cloning-a-repository).\n```\n$ cd gaphor\n$ source ./venv\n$ poetry run gaphor\n```\n\n## :flashlight: Usage\n### Creating models\n\nOnce Gaphor is started a new empty model is automatically created. The main\ndiagram is already open in the Diagram section.\n\nSelect an element you want to place, for example a Class, by clicking on the icon in\nthe Toolbox and click on the diagram. This will place a new\nClass item instance on the diagram and add a new Class to the model (it shows\nup in the Navigation). The selected tool will reset itself to\nthe Pointer tool if the option \'\'Diagram -> Reset tool\'\' is selected.\n\nSome elements are not directly visible. The section in the toolbox is collapsed\nand needs to be clicked first to reveal its contents.\n\nGaphor only has one diagram type, and it does not enforce which elements should\nbe placed on a diagram.\n\n### Create a New Diagram\n\n1. Use the Navigation to select an element that can contain a diagram (a\nPackage or Profile)\n1. Select Diagram, and New diagram. A new diagram is created.\n\n### Copy and Paste\n\nItems in a diagram can be copied and pasted in the same diagram or other\ndiagrams. Pasting places an existing item in the diagram, but the item itself\nis not duplicated. In other words, if you paste a Class object in a diagram,\nthe Class will be added to the diagram, but there will be no new Class in the\nNavigation.\n\n### Drag and Drop\n\nAdding an existing element to a diagram is done by dragging the element from\nthe Navigation section onto a diagram. Diagrams and attribute/operations of a\nClass show up in the Navigation but can not be added to a diagram.\n\nElements can also be dragged within the Navigation in order to rearrange them\nin to different packages.\n\n\n## :heart: Contributing\n\nThanks goes to these wonderful people ([emoji key](https://github.com/kentcdodds/all-contributors#emoji-key)):\n\n<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->\n<!-- prettier-ignore -->\n<table><tr><td align="center"><a href="https://github.com/amolenaar"><img src="https://avatars0.githubusercontent.com/u/96249?v=4" width="100px;" alt="Arjan Molenaar"/><br /><sub><b>Arjan Molenaar</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/commits?author=amolenaar" title="Code">💻</a> <a href="https://github.com/gaphor/gaphor/issues?q=author%3Aamolenaar" title="Bug reports">🐛</a> <a href="https://github.com/gaphor/gaphor/commits?author=amolenaar" title="Documentation">📖</a> <a href="#review-amolenaar" title="Reviewed Pull Requests">👀</a> <a href="#question-amolenaar" title="Answering Questions">💬</a> <a href="https://github.com/gaphor/gaphor/issues?q=author%3Aamolenaar" title="Bug reports">🐛</a> <a href="#plugin-amolenaar" title="Plugin/utility libraries">🔌</a> <a href="https://github.com/gaphor/gaphor/commits?author=amolenaar" title="Tests">⚠️</a></td><td align="center"><a href="https://github.com/wrobell"><img src="https://avatars2.githubusercontent.com/u/105664?v=4" width="100px;" alt="wrobell"/><br /><sub><b>wrobell</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/commits?author=wrobell" title="Code">💻</a> <a href="https://github.com/gaphor/gaphor/commits?author=wrobell" title="Tests">⚠️</a> <a href="https://github.com/gaphor/gaphor/issues?q=author%3Awrobell" title="Bug reports">🐛</a> <a href="#design-wrobell" title="Design">🎨</a></td><td align="center"><a href="https://ghuser.io/danyeaw"><img src="https://avatars1.githubusercontent.com/u/10014976?v=4" width="100px;" alt="Dan Yeaw"/><br /><sub><b>Dan Yeaw</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/commits?author=danyeaw" title="Code">💻</a> <a href="https://github.com/gaphor/gaphor/commits?author=danyeaw" title="Tests">⚠️</a> <a href="https://github.com/gaphor/gaphor/commits?author=danyeaw" title="Documentation">📖</a> <a href="#platform-danyeaw" title="Packaging/porting to new platform">📦</a> <a href="#infra-danyeaw" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/gaphor/gaphor/issues?q=author%3Adanyeaw" title="Bug reports">🐛</a> <a href="#question-danyeaw" title="Answering Questions">💬</a></td><td align="center"><a href="https://github.com/melisdogan"><img src="https://avatars2.githubusercontent.com/u/33630433?v=4" width="100px;" alt="melisdogan"/><br /><sub><b>melisdogan</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/commits?author=melisdogan" title="Documentation">📖</a></td><td align="center"><a href="http://www.boduch.ca"><img src="https://avatars2.githubusercontent.com/u/114619?v=4" width="100px;" alt="Adam Boduch"/><br /><sub><b>Adam Boduch</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/commits?author=adamboduch" title="Code">💻</a> <a href="https://github.com/gaphor/gaphor/commits?author=adamboduch" title="Tests">⚠️</a> <a href="https://github.com/gaphor/gaphor/issues?q=author%3Aadamboduch" title="Bug reports">🐛</a></td><td align="center"><a href="https://github.com/egroeper"><img src="https://avatars3.githubusercontent.com/u/535113?v=4" width="100px;" alt="Enno Gröper"/><br /><sub><b>Enno Gröper</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/commits?author=egroeper" title="Code">💻</a></td><td align="center"><a href="https://pfeifle.tech"><img src="https://avatars2.githubusercontent.com/u/23027708?v=4" width="100px;" alt="JensPfeifle"/><br /><sub><b>JensPfeifle</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/commits?author=JensPfeifle" title="Documentation">📖</a></td></tr><tr><td align="center"><a href="http://www.aejh.co.uk"><img src="https://avatars1.githubusercontent.com/u/927233?v=4" width="100px;" alt="Alexis Howells"/><br /><sub><b>Alexis Howells</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/commits?author=aejh" title="Documentation">📖</a></td><td align="center"><a href="http://encolpe.wordpress.com"><img src="https://avatars1.githubusercontent.com/u/124361?v=4" width="100px;" alt="Encolpe DEGOUTE"/><br /><sub><b>Encolpe DEGOUTE</b></sub></a><br /><a href="#translation-encolpe" title="Translation">🌍</a></td><td align="center"><a href="https://github.com/choff"><img src="https://avatars1.githubusercontent.com/u/309979?v=4" width="100px;" alt="Christian Hoff"/><br /><sub><b>Christian Hoff</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/commits?author=choff" title="Code">💻</a></td><td align="center"><a href="https://oskuro.net/"><img src="https://avatars3.githubusercontent.com/u/929712?v=4" width="100px;" alt="Jordi Mallach"/><br /><sub><b>Jordi Mallach</b></sub></a><br /><a href="#translation-jmallach" title="Translation">🌍</a></td><td align="center"><a href="https://github.com/tonytheleg"><img src="https://avatars3.githubusercontent.com/u/43508092?v=4" width="100px;" alt="Tony"/><br /><sub><b>Tony</b></sub></a><br /><a href="#maintenance-tonytheleg" title="Maintenance">🚧</a></td><td align="center"><a href="https://github.com/jischebeck"><img src="https://avatars0.githubusercontent.com/u/3011242?v=4" width="100px;" alt="Jan"/><br /><sub><b>Jan</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/issues?q=author%3Ajischebeck" title="Bug reports">🐛</a></td><td align="center"><a href="http://btibert3.github.io"><img src="https://avatars2.githubusercontent.com/u/203343?v=4" width="100px;" alt="Brock Tibert"/><br /><sub><b>Brock Tibert</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/issues?q=author%3ABtibert3" title="Bug reports">🐛</a></td></tr><tr><td align="center"><a href="http://www.rmunoz.net"><img src="https://avatars2.githubusercontent.com/u/23944?v=4" width="100px;" alt="Rafael Muñoz Cárdenas"/><br /><sub><b>Rafael Muñoz Cárdenas</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/issues?q=author%3AMenda" title="Bug reports">🐛</a></td><td align="center"><a href="https://github.com/mbessonov"><img src="https://avatars2.githubusercontent.com/u/172974?v=4" width="100px;" alt="Mikhail Bessonov"/><br /><sub><b>Mikhail Bessonov</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/issues?q=author%3Ambessonov" title="Bug reports">🐛</a></td><td align="center"><a href="http://twitter.com/kapilvt"><img src="https://avatars3.githubusercontent.com/u/21650?v=4" width="100px;" alt="Kapil Thangavelu"/><br /><sub><b>Kapil Thangavelu</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/issues?q=author%3Akapilt" title="Bug reports">🐛</a></td><td align="center"><a href="https://github.com/DimShadoWWW"><img src="https://avatars2.githubusercontent.com/u/25516?v=4" width="100px;" alt="DimShadoWWW"/><br /><sub><b>DimShadoWWW</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/issues?q=author%3ADimShadoWWW" title="Bug reports">🐛</a></td><td align="center"><a href="http://nedko.arnaudov.name"><img src="https://avatars2.githubusercontent.com/u/96399?v=4" width="100px;" alt="Nedko Arnaudov"/><br /><sub><b>Nedko Arnaudov</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/issues?q=author%3Anedko" title="Bug reports">🐛</a></td><td align="center"><a href="https://github.com/Alexander-Wilms"><img src="https://avatars2.githubusercontent.com/u/3226457?v=4" width="100px;" alt="Alexander Wilms"/><br /><sub><b>Alexander Wilms</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/issues?q=author%3AAlexander-Wilms" title="Bug reports">🐛</a></td><td align="center"><a href="http://stevenliu216.github.io"><img src="https://avatars3.githubusercontent.com/u/1274417?v=4" width="100px;" alt="Steven Liu"/><br /><sub><b>Steven Liu</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/issues?q=author%3Astevenliu216" title="Bug reports">🐛</a></td></tr><tr><td align="center"><a href="https://github.com/ruimaciel"><img src="https://avatars3.githubusercontent.com/u/169121?v=4" width="100px;" alt="Rui Maciel"/><br /><sub><b>Rui Maciel</b></sub></a><br /><a href="#ideas-ruimaciel" title="Ideas, Planning, & Feedback">🤔</a></td><td align="center"><a href="https://github.com/ezickler"><img src="https://avatars3.githubusercontent.com/u/3604310?v=4" width="100px;" alt="Enno Zickler"/><br /><sub><b>Enno Zickler</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/issues?q=author%3Aezickler" title="Bug reports">🐛</a></td><td align="center"><a href="https://github.com/tronta"><img src="https://avatars1.githubusercontent.com/u/5135577?v=4" width="100px;" alt="tronta"/><br /><sub><b>tronta</b></sub></a><br /><a href="https://github.com/gaphor/gaphor/issues?q=author%3Atronta" title="Bug reports">🐛</a></td></tr></table>\n\n<!-- ALL-CONTRIBUTORS-LIST:END -->\n\nThis project follows the\n[all-contributors](https://github.com/kentcdodds/all-contributors)\nspecification. Contributions of any kind are welcome!\n\n1.  Check for open issues or open a fresh issue to start a discussion\n    around a feature idea or a bug. There is a\n    [first-timers-only](https://github.com/gaphor/gaphor/issues?utf8=%E2%9C%93&q=is%3Aissue+is%3Aopen+label%3Afirst-timers-only)\n    tag for issues that should be ideal for people who are not very\n    familiar with the codebase yet.\n2.  Fork [the repository](https://github.com/gaphor/gaphor) on\n    GitHub to start making your changes to the **master** branch (or\n    branch off of it).\n3.  Write a test which shows that the bug was fixed or that the feature\n    works as expected.\n4.  Send a pull request and bug the maintainers until it gets merged and\n    published. :smile:\n\nSee [the contributing file](CONTRIBUTING.md)!\n\n\n## :copyright: License\nCopyright (C) Arjan Molenaar and Dan Yeaw\n\nLicensed under the [Apache License v2](LICENSE.txt).\n\nSummary: You can do what you like with Gaphor, as long as you include the\nrequired notices. This permissive license contains a patent license from the\ncontributors of the code.\n',
    'author': 'Arjan J. Molenaar',
    'author_email': 'gaphor@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gaphor.readthedocs.io/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
