"""Support for MySensors binary sensors."""
from openpeerpower.components import mysensors
from openpeerpower.components.binary_sensor import (
    DEVICE_CLASSES,
    DOMAIN,
    BinarySensorDevice,
)
from openpeerpower.const import STATE_ON

SENSORS = {
    "S_DOOR": "door",
    "S_MOTION": "motion",
    "S_SMOKE": "smoke",
    "S_SPRINKLER": "safety",
    "S_WATER_LEAK": "safety",
    "S_SOUND": "sound",
    "S_VIBRATION": "vibration",
    "S_MOISTURE": "moisture",
}


async def async_setup_platform(opp, config, async_add_entities, discovery_info=None):
    """Set up the mysensors platform for binary sensors."""
    mysensors.setup_mysensors_platform(
        opp,
        DOMAIN,
        discovery_info,
        MySensorsBinarySensor,
        async_add_entities=async_add_entities,
    )


class MySensorsBinarySensor(mysensors.device.MySensorsEntity, BinarySensorDevice):
    """Representation of a MySensors Binary Sensor child node."""

    @property
    def is_on(self):
        """Return True if the binary sensor is on."""
        return self._values.get(self.value_type) == STATE_ON

    @property
    def device_class(self):
        """Return the class of this sensor, from DEVICE_CLASSES."""
        pres = self.gateway.const.Presentation
        device_class = SENSORS.get(pres(self.child_type).name)
        if device_class in DEVICE_CLASSES:
            return device_class
        return None
