# Copyright (C) 2020 FireEye, Inc. All Rights Reserved.

ARCH_X86 = 32
ARCH_AMD64 = 64
PAGE_SIZE = 0x1000
BITS_32 = 32
BITS_64 = 64

LSTAR = 0xC0000082

X86_REG_CS = 1001
X86_REG_DS = 1002
X86_REG_EAX = 1003
X86_REG_EBP = 1004
X86_REG_EBX = 1005
X86_REG_ECX = 1006
X86_REG_EDI = 1007
X86_REG_EDX = 1008
X86_REG_EFLAGS = 1009
X86_REG_EIP = 1010
X86_REG_EIZ = 1011
X86_REG_ESI = 1012
X86_REG_ESP = 1013

# Segment registers
X86_REG_FS = 1014
X86_REG_GS = 1015
X86_REG_ES = 1016
X86_REG_SS = 1017
X86_REG_CS = 1018
X86_REG_DS = 1019

X86_REG_MSR = 1020

# AMD64
AMD64_REG_RAX = 1021
AMD64_REG_RBP = 1022
AMD64_REG_RBX = 1023
AMD64_REG_RCX = 1024
AMD64_REG_RDI = 1025
AMD64_REG_RDX = 1026
AMD64_REG_RIP = 1027
AMD64_REG_RIZ = 1028
AMD64_REG_RSI = 1029
AMD64_REG_RSP = 1030
AMD64_REG_SIL = 1031
AMD64_REG_DIL = 1032
AMD64_REG_BPL = 1033
AMD64_REG_SPL = 1034
AMD64_REG_R8 = 1035
AMD64_REG_R9 = 1036
AMD64_REG_R10 = 1037
AMD64_REG_R11 = 1038
AMD64_REG_R12 = 1039
AMD64_REG_R13 = 1040
AMD64_REG_R14 = 1041
AMD64_REG_R15 = 1042

# Control Registers
X86_REG_CR0 = 1043
X86_REG_CR1 = 1044
X86_REG_CR2 = 1045
X86_REG_CR3 = 1046
X86_REG_CR4 = 1047
X86_REG_CR5 = 1048
X86_REG_CR6 = 1049
X86_REG_CR7 = 1050
X86_REG_CR8 = 1051

# Debug registers
X86_REG_DR0 = 1052
X86_REG_DR1 = 1053
X86_REG_DR2 = 1054
X86_REG_DR3 = 1055
X86_REG_DR4 = 1056
X86_REG_DR5 = 1057
X86_REG_DR6 = 1058
X86_REG_DR7 = 1059
X86_REG_DR8 = 1060

X86_REG_IDTR = 1061
X86_REG_GDTR = 1062

X86_REG_XMM0 = 1063
X86_REG_XMM1 = 1064
X86_REG_XMM2 = 1065
X86_REG_XMM3 = 1066
X86_REG_XMM4 = 1067

# Calling conventions
CALL_CONV_CDECL = 0
CALL_CONV_STDCALL = 1
CALL_CONV_FASTCALL = 2
CALL_CONV_FLOAT = 3
VAR_ARGS = -1

# Register string constants
REG_LOOKUP = {
    # x86 registers
    'eax': X86_REG_EAX, 'ebx': X86_REG_EBX, 'ecx': X86_REG_ECX, 'edx': X86_REG_EDX,
    'edi': X86_REG_EDI, 'esi': X86_REG_ESI, 'ebp': X86_REG_EBP, 'esp': X86_REG_ESP,
    'eip': X86_REG_EIP, 'eflags': X86_REG_EFLAGS,
    # amd64 registers
    'rax': AMD64_REG_RAX, 'rbx': AMD64_REG_RBX, 'rcx': AMD64_REG_RCX, 'rdx': AMD64_REG_RDX,
    'rdi': AMD64_REG_RDI, 'rsi': AMD64_REG_RSI, 'rsp': AMD64_REG_RSP, 'rbp': AMD64_REG_RBP,
    'r8': AMD64_REG_R8, 'r9': AMD64_REG_R9, 'r10': AMD64_REG_R10, 'r11': AMD64_REG_R11,
    'r12': AMD64_REG_R12, 'r13': AMD64_REG_R13, 'r14': AMD64_REG_R14, 'r15': AMD64_REG_R15,
    'rip': AMD64_REG_RIP
}
