"""AiiDA-ORCA input generator"""

from copy import deepcopy


class OrcaInput:
    """Transforms dictionary into ORCA input"""

    def __init__(self, params):
        """Initializing OrcaInput object"""

        self._params = deepcopy(params)

    def render(self):
        output = ['### Generated by AiiDA-ORCA Plugin ###']
        self._render_input(output, deepcopy(self._params))
        return '\n'.join(output)

    @staticmethod
    def _render_input(output, params):
        """
        Rendering differnt sections
        """
        #pylint: disable = too-many-branches
        if 'input_keywords' in params:
            keywords = params['input_keywords']
        else:
            keywords = {'SP': None}  # as a default

        if 'extra_input_keywords' in params:
            extra_keywords = params['extra_input_keywords']

        if 'input_blocks' in params:
            blocks = params['input_blocks']

        inp_keyword = '! '

        for keyword in keywords:
            inp_keyword += keyword + ' '

        output.append(inp_keyword)

        if extra_keywords:
            xtrainp_keyword = '! '
            for keyword in extra_keywords:
                xtrainp_keyword += keyword + ' '

            output.append(xtrainp_keyword)

        inp_block = ''
        if blocks:
            for key in blocks.keys():
                inp_block += f'%{key} \n'
                for keyword, val in blocks[key].items():
                    if val is None:
                        inp_block += '\t' + keyword + '\n'
                    else:
                        inp_block += '\t' + str(keyword) + ' ' + str(val) + '\n'
                inp_block += 'end\n'
        output.append(inp_block)

        #     coordinate section
        coord_sec = '* xyzfile'
        coord_sec += f" {params['charge']} {params['multiplicity']} aiida.coords.xyz\n"
        output.append(coord_sec)


#EOF
