"""Bureau of Labor Statistics Client Configuration File."""
from enum import Enum


class ExtendedEnum(Enum):
    """Allows access to overloaded functions for standard Enum"""

    @classmethod
    def list(cls):
        """Interface to provide all allowed values for an Enumeration. """
        return list(map(lambda c: c.value, cls))


class SeriesID(ExtendedEnum):
    """
    Enumeration for available Series IDs for BLS Public API.
    see (https://www.bls.gov/help/hlpforma.htm)

    Registered ID's are available via BLS Public API

    (e.g.)
        >>> SeriesID.NATIONAL_EMPLOYMENT_HOURS_AND_EARNINGS.value
        >>> "CEU0800000003"
    """

    NATIONAL_EMPLOYMENT_HOURS_AND_EARNINGS = "CEU0800000003"
    NATIONAL_EMPLOYMENT_HOURS_AND_EARNINGS_SIC_BASIS = "EES10140001"
    STATE_AND_AREA_EMPLOYMENT_HOURS_AND_EARNINGS = "SMU19197802023800001"
    STATE_AND_AREA_EMPLOYMENT_HOURS_AND_EARNINGS_SIC_BASIS = "SAS0800002000011"
    STATE_AND_COUNTY_EMPLOYMENT_AND_WAGES_FROM_QUARTERLY_CENSUS_OF_EMPLOYMENT_AND_WAGES = (
        "ENU04013105111150"
    )
    STATE_AND_COUNTY_EMPLOYMENT_AND_WAGES_FROM_QUARTERLY_CENSUS_OF_EMPLOYMENT_AND_WAGES_1997_2000_SIC_BASIS = (
        "EWU040131050A0115"
    )
    OCCUPATIONAL_EMPLOYMENT_STATISTICS_OES = "OEUN000000011100011000001"
    BUSINESS_EMPLOYMENT_DYNAMICS = "BDS0000000000000000110101LQ5"
    LOCAL_AREA_UNEMPLOYMENT_STATISTICS = "LAUCN281070000000003"
    MASS_LAYOFF_STATISTICS = "MLUMS00NN0001003"
    JOB_OPENINGS_AND_LABOR_TURNOVER_SURVEY_SIC_BASIS = "JLU00000000HIL"
    JOB_OPENINGS_AND_LABOR_TURNOVER_SURVEY = "JTU00000000HIL"
    GREEN_GOODS_AND_SERVICES = "GGUQO100000000000050010L"
    AMERICAN_TIME_USE_SURVEY = "TUU10101AA01011987"
    CONSUMER_EXPENDITURE_SURVEY = "CXUMENBOYSLB0101M"
    AVERAGE_PRICE_DATA = "APU000070111"
    CONSUMER_PRICE_INDEX_ALL_URBAN_CONSUMERS = "CUUR0000SA0L1E"
    CONSUMER_PRICE_INDEX_URBAN_WAGE_EARNERS_AND_CLERICAL_WORKERS = "CWSR0000SA111211"
    CONSUMER_PRICE_INDEX_ALL_URBAN_CONSUMERS_OLD_SERIES = "MUSR0000SA111211"
    CONSUMER_PRICE_INDEX_URBAN_WAGE_EARNERS_AND_CLERICAL_WORKERS_OLD_SERIES = (
        "MWSR0000SA111211"
    )
    DEPARTMENT_STORE_INVENTORY_PRICE_INDEX = "LIUR0000SL00019"
    CHAINED_CPI_ALL_URBAN_CONSUMERS = "SUUR0000SA0"
    PRODUCER_PRICE_INDEX_INDUSTRY_DATA_CURRENT_SERIES = "PCU22112222112241"
    PRODUCER_PRICE_INDEX_INDUSTRY_DATA_DISCONTINUED_SERIES_NAICS_BASIS = (
        "NDU1051111051112345"
    )
    PRODUCER_PRICE_INDEX_INDUSTRY_DATA_DISCONTINUED_SERIES_SIC_BASIS = "PDU1031#214"
    PRODUCER_PRICE_INDEX_COMMODITY_DATA_CURRENT_SERIES = "WPS141101"
    PRODUCER_PRICE_INDEX_COMMODITY_DATA_DISCONTINUED_SERIES = "WDU062201"
    WORK_STOPPAGE_DATA = "WSUB00"
    EMPLOYEE_BENEFITS_SURVEY = "EBU401KINC0000ML"
    EMPLOYMENT_COST_INDEX_SIC = "ECS10001I"
    EMPLOYER_COST_FOR_EMPLOYEE_COMPENSATION_SIC = "CCU010000100000P"
    NATIONAL_COMPENSATION_SURVEY = "NCU5306633300003"
    NATIONAL_COMPENSATION_SURVEY_BENEFITS_BEGINNING_WITH_2010_DATA = (
        "NBU10000000000000028007"
    )
    MODELED_WAGE_ESTIMATES = "WMU40000011020000004130992500"
    MAJOR_SECTOR_PRODUCTIVITY_AND_COSTS = "PRS85006032"
    MAJOR_SECTOR_MULTIFACTOR_PRODUCTIVITY = "MPU4900012"
    INDUSTRY_PRODUCTIVITY = "IPUBN212__W000"
    OCCUPATIONAL_INJURIES_AND_ILLNESSES_INDUSTRY_DATA_2014_FORWARD = "ISU00X00000060N00"
    CENSUS_OF_FATAL_OCCUPATIONAL_INJURIES_2011_FORWARD = "FWU00X00000080M70"
    CENSUS_OF_FATAL_OCCUPATIONAL_INJURIES_2003_2010 = "FIU00X00000080N00"
    CENSUS_OF_FATAL_OCCUPATIONAL_INJURIES_1992_2002 = "CFU00000080"
    NONFATAL_CASES_INVOLVING_DAYS_AWAY_FROM_WORK_SELECTED_CHARACTERISTICS_2011_FORWARD = (
        "CSUSDX031XXX6E000"
    )
    NONFATAL_CASES_INVOLVING_DAYS_AWAY_FROM_WORK_SELECTED_CHARACTERISTICS_2003_2010 = (
        "CHUSDX031XXX6E000"
    )
    NONFATAL_CASES_INVOLVING_DAYS_AWAY_FROM_WORK_SELECTED_CHARACTERISTICS_2002 = (
        "HCU0012123N"
    )
    NONFATAL_CASES_INVOLVING_DAYS_AWAY_FROM_WORK_SELECTED_CHARACTERISTICS_1992_2001 = (
        "CDUDMM10073"
    )
    OCCUPATIONAL_INJURIES_AND_ILLNESSES_INDUSTRY_DATA_PRE1989 = "HSU09020018"
    OCCUPATIONAL_INJURIES_AND_ILLNESSES_INDUSTRY_DATA_1989_2001 = "SHU00000034"
    OCCUPATIONAL_INJURIES_AND_ILLNESSES_INDUSTRY_DATA_2002 = "SIU00000001"
    OCCUPATIONAL_INJURIES_AND_ILLNESSES_INDUSTRY_DATA_2003_2013 = "IIU00X00000060N00"
    OCCUPATIONAL_REQUIREMENTS_SURVEY = "ORUV1000000000001029"
    IMPORT_EXPORT_PRICE_INDEXES = "EIUCOCANMANU"
