"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RiskTrackingStatus = exports.RiskTracking = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class RiskTracking {
    constructor(id, props) {
        this.id = id;
        this.status = props.status ?? RiskTrackingStatus.UNCHECKED;
        this.justification = props.justification;
        this.ticket = props.ticket;
        if (props.date) {
            this.date = new Date(props.date).toISOString().split("T")[0];
        }
        this.checkedBy = props.checkedBy;
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.id]: {
                status: this.status,
                justification: this.justification,
                ticket: this.ticket,
                date: this.date,
                checked_by: this.checkedBy,
            },
        };
    }
}
exports.RiskTracking = RiskTracking;
_a = JSII_RTTI_SYMBOL_1;
RiskTracking[_a] = { fqn: "cdktg.RiskTracking", version: "0.0.22" };
var RiskTrackingStatus;
(function (RiskTrackingStatus) {
    RiskTrackingStatus["UNCHECKED"] = "unchecked";
    RiskTrackingStatus["IN_DISCUSSION"] = "in-discussion";
    RiskTrackingStatus["ACCEPTED"] = "accepted";
    RiskTrackingStatus["IN_PROGRESS"] = "in-progress";
    RiskTrackingStatus["MITIGATED"] = "mitigated";
    RiskTrackingStatus["FALSE_POSITIVE"] = "false-positive";
})(RiskTrackingStatus = exports.RiskTrackingStatus || (exports.RiskTrackingStatus = {}));
//# sourceMappingURL=data:application/json;base64,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