export interface RiskTrackingProps {
    readonly status?: RiskTrackingStatus;
    readonly justification?: string;
    readonly ticket?: string;
    readonly date?: string;
    readonly checkedBy?: string;
}
export declare class RiskTracking {
    readonly id: string;
    readonly status: RiskTrackingStatus;
    readonly justification?: string;
    readonly ticket?: string;
    readonly date?: string;
    readonly checkedBy?: string;
    constructor(id: string, props: RiskTrackingProps);
    /**
     * @internal
     */
    _toThreagile(): {
        [x: string]: {
            status: RiskTrackingStatus;
            justification: string | undefined;
            ticket: string | undefined;
            date: string | undefined;
            checked_by: string | undefined;
        };
    };
}
export declare enum RiskTrackingStatus {
    UNCHECKED = "unchecked",
    IN_DISCUSSION = "in-discussion",
    ACCEPTED = "accepted",
    IN_PROGRESS = "in-progress",
    MITIGATED = "mitigated",
    FALSE_POSITIVE = "false-positive"
}
