"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataBreachProbability = exports.ExploitationImpact = exports.ExploitationLikelihood = exports.Severity = exports.Stride = exports.RiskFunction = exports.RiskCategory = exports.Risk = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_asset_1 = require("./data-asset");
const resource_1 = require("./resource");
const shared_runtime_1 = require("./shared-runtime");
const technical_asset_1 = require("./technical-asset");
const trust_boundary_1 = require("./trust-boundary");
class Risk {
    constructor(id, props) {
        this.id = id;
        this.severity = props.severity;
        this.exploitationLikelihood = props.exploitationLikelihood;
        this.exploitationImpact = props.exploitationImpact;
        this.dataBreachProbability = props.dataBreachProbability;
        this.dataBreachTechnicalAssets = props.dataBreachTechnicalAssets;
        this.mostRelevantTechnicalAsset = props.mostRelevantTechnicalAsset;
        this.mostRelevantDataAsset = props.mostRelevantDataAsset;
        this.mostRelevantCommunicationLink = props.mostRelevantCommunicationLink;
        this.mostRelevantTrustBoundary = props.mostRelevantTrustBoundary;
        this.mostRelevantSharedRuntime = props.mostRelevantSharedRuntime;
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.id]: {
                severity: this.severity,
                exploitation_likelihood: this.exploitationLikelihood,
                exploitation_impact: this.exploitationImpact,
                data_breach_probability: this.dataBreachProbability,
                data_breach_technical_assets: this.dataBreachTechnicalAssets.map((a) => a.uuid),
                most_relevant_data_asset: this.mostRelevantDataAsset?.uuid,
                most_relevant_technical_asset: this.mostRelevantTechnicalAsset?.uuid,
                most_relevant_communication_link: this.mostRelevantCommunicationLink?.id,
                most_relevant_trust_boundary: this.mostRelevantTrustBoundary?.uuid,
                most_relevant_shared_runtime: this.mostRelevantSharedRuntime?.uuid,
            },
        };
    }
}
exports.Risk = Risk;
_a = JSII_RTTI_SYMBOL_1;
Risk[_a] = { fqn: "cdktg.Risk", version: "0.0.22" };
class RiskCategory extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.impact = props.impact;
        this.asvs = props.asvs;
        this.cheatSheat = props.cheatSheat;
        this.action = props.action;
        this.mitigation = props.mitigation;
        this.check = props.check;
        this.function = props.function;
        this.stride = props.stride;
        this.detectionLogic = props.detectionLogic;
        this.riskAssessment = props.riskAssessment;
        this.falsePositives = props.falsePositives;
        this.modelFailurePossibleReason = props.modelFailurePossibleReason;
        this.cwe = props.cwe;
        this.risks = new Array();
    }
    identifiedAtDataAsset(target, options) {
        this.identifiedAtResource(target, options);
    }
    identifiedAtTechnicalAsset(target, options) {
        this.identifiedAtResource(target, options);
    }
    identifiedAtTrustBoundary(target, options) {
        this.identifiedAtResource(target, options);
    }
    identifiedAtSharedRuntime(target, options) {
        this.identifiedAtResource(target, options);
    }
    addIdentifiedRisk(risk) {
        this.risks.push(risk);
    }
    identifiedAtResource(target, options) {
        this.addIdentifiedRisk(new Risk(`<b>${this.node.id}</b> risk at <b>${target.node.id}</b>`, {
            ...options,
            mostRelevantDataAsset: target instanceof data_asset_1.DataAsset ? target : undefined,
            mostRelevantTechnicalAsset: target instanceof technical_asset_1.TechnicalAsset ? target : undefined,
            mostRelevantTrustBoundary: target instanceof trust_boundary_1.TrustBoundary ? target : undefined,
            mostRelevantSharedRuntime: target instanceof shared_runtime_1.SharedRuntime ? target : undefined,
        }));
    }
    /**
     * @internal
     */
    _toThreagile() {
        const threagile = {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                impact: this.impact,
                asvs: this.asvs,
                cheat_sheet: this.cheatSheat,
                action: this.action,
                mitigation: this.mitigation,
                check: this.check,
                function: this.function,
                stride: this.stride,
                detection_logic: this.detectionLogic,
                risk_assessment: this.riskAssessment,
                false_positives: this.falsePositives,
                model_failure_possible_reason: this.modelFailurePossibleReason ?? false,
                cwe: this.cwe,
            },
        };
        threagile[this.node.id].risks_identified = this.risks.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        return threagile;
    }
}
exports.RiskCategory = RiskCategory;
_b = JSII_RTTI_SYMBOL_1;
RiskCategory[_b] = { fqn: "cdktg.RiskCategory", version: "0.0.22" };
var RiskFunction;
(function (RiskFunction) {
    RiskFunction["BUSINESS_SIDE"] = "business-side";
    RiskFunction["ARCHITECTURE"] = "architecture";
    RiskFunction["DEVELOPMENT"] = "development";
    RiskFunction["OPERATIONS"] = "operations";
})(RiskFunction = exports.RiskFunction || (exports.RiskFunction = {}));
var Stride;
(function (Stride) {
    Stride["SPOOFING"] = "spoofing";
    Stride["TAMPERING"] = "tampering";
    Stride["REPUDIATION"] = "repudiation";
    Stride["INFORMATION_DISCLOSURE"] = "information-disclosure";
    Stride["DENIAL_OF_SERVICE"] = "denial-of-service";
    Stride["ELEVATION_OF_PRIVILEGE"] = "elevation-of-privilege";
})(Stride = exports.Stride || (exports.Stride = {}));
var Severity;
(function (Severity) {
    Severity["LOW"] = "low";
    Severity["MEDIUM"] = "medium";
    Severity["ELEVATED"] = "elevated";
    Severity["HIGH"] = "high";
    Severity["CRITICAL"] = "critical";
})(Severity = exports.Severity || (exports.Severity = {}));
var ExploitationLikelihood;
(function (ExploitationLikelihood) {
    ExploitationLikelihood["UNLIKELY"] = "unlikely";
    ExploitationLikelihood["LIKELY"] = "likely";
    ExploitationLikelihood["VERY_LIKELY"] = "very-likely";
    ExploitationLikelihood["FREQUENT"] = "frequent";
})(ExploitationLikelihood = exports.ExploitationLikelihood || (exports.ExploitationLikelihood = {}));
var ExploitationImpact;
(function (ExploitationImpact) {
    ExploitationImpact["LOW"] = "low";
    ExploitationImpact["MEDIUM"] = "medium";
    ExploitationImpact["HIGH"] = "high";
    ExploitationImpact["VERY_HIGH"] = "very-high";
})(ExploitationImpact = exports.ExploitationImpact || (exports.ExploitationImpact = {}));
var DataBreachProbability;
(function (DataBreachProbability) {
    DataBreachProbability["IMPROBABLE"] = "improbable";
    DataBreachProbability["POSSIBLE"] = "possible";
    DataBreachProbability["PROBABLE"] = "probable";
})(DataBreachProbability = exports.DataBreachProbability || (exports.DataBreachProbability = {}));
//# sourceMappingURL=data:application/json;base64,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