# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['pymeter', 'pymeter.api']

package_data = \
{'': ['*'], 'pymeter': ['resources/jars/*']}

install_requires = \
['pyjnius>=1.4.2,<2.0.0', 'typing-extensions>=4.3.0,<5.0.0']

setup_kwargs = {
    'name': 'py-jmeter-dsl',
    'version': '0.2a1',
    'description': 'Simple JMeter performance tests API for python',
    'long_description': '# pymeter\nSimple JMeter performance tests API for python\n\n#### Powered by [JMeter-DSL](https://abstracta.github.io/jmeter-java-dsl/) and [pyjnius](https://github.com/kivy/pyjnius) \n\n\n[![Version](https://img.shields.io/pypi/v/py-jmeter-dsl.svg)](https://pypi.python.org/pypi/py-jmeter-dsl)\n![](https://raw.githubusercontent.com/eldaduzman/pymeter/main/docs/badges/coverage-badge.svg)\n![](https://raw.githubusercontent.com/eldaduzman/pymeter/main/docs/badges/pylint.svg)\n![](https://raw.githubusercontent.com/eldaduzman/pymeter/main/docs/badges/mutscore.svg)\n\n[![Documentation Status](https://readthedocs.org/projects/pymeter/badge/?version=latest)](https://pymeter.readthedocs.io/en/latest/?badge=latest)\n\n\n\n[![License](https://img.shields.io/badge/License-Apache_2.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)\n\n\n<br/>\n\n<div style="text-align:center"><img src="https://raw.githubusercontent.com/eldaduzman/pymeter/main/docs/user-guide/source/_static/pymeter-logo-full.jpg" width="70%" /></div>\n\n<br/>\n<br/>\n<br/>\n<br/>\n\n\n\n## Load testing with JMeter using python!\n\n\nRead the documentation [here](https://pymeter.readthedocs.io/en/latest/)\n\n**JMeter** is one of the most popular and long standing load testing tools.\nThe original implementation is a gui based tool to script load test scenarios in a hierarchical structure, however this came with limitations and short comings.\n\nFor once, upgrading JMeter versions is painful, as it involved manually downloading and deploying executable files.\nThis became very clear when [log4j](https://en.wikipedia.org/wiki/Log4Shell) vulnerability was discovered, and software developers needed to instantly upgrade their log4j versions.\nWith JMeter, this was even more painful without a proper package management system such as maven or gradel.\n\nOther limitations include difficulty to share code between different projects, using source control management tools such as git or svn.\nIt is quite difficult to extend JMeter and it requires a GUI editor which means to use additional development environment instead of using a single IDE for all needs.\n\nThe awesome folks at [abstracta](https://abstracta.us/) have put up an amazing amount of work to deliver [JMeter-DSL](https://abstracta.github.io/jmeter-java-dsl/), which allows developers to use plain Java to script their load test scenarios, and pretty much solve all the pain mentioned above.\n\n`pymeter` project is aimed to capitalize on the success of JMeter-DSL and extend it to the python community!\nUsing [pyjnius](https://github.com/kivy/pyjnius) developed by Kivy, it is possible to bridge between JMeter-DSLs classes written in Java and reflect them into python\'s runtime environment without spawning up java runtime and relying on costly inter-process communication.\n\n\n### Pre-requisites:\n1. python version 3.9 or higher - [download](https://www.python.org/)\n2. Java version 8 or 11 - [download](https://adoptium.net/temurin/releases)\n3. JAVA_HOME environment variable set - [read](https://confluence.atlassian.com/doc/setting-the-java_home-variable-in-windows-8895.html)\n\n### Install pymeter\n```\n>>> pip install py-jmeter-dsl\n```\n\n### simple pymeter script:\n\n```\n"""unittest module"""\nfrom unittest import TestCase, main\n\nfrom pymeter.api.config import TestPlan, ThreadGroupWithRampUpAndHold\nfrom pymeter.api.postprocessors import JsonExtractor\nfrom pymeter.api.reporters import HtmlReporter\nfrom pymeter.api.samplers import DummySampler, HttpSampler\nfrom pymeter.api.timers import UniformRandomTimer\n\n\nclass TestTestPlanClass(TestCase):\n    def test_1(self):\n        json_extractor = JsonExtractor("variable", "args.var")\n        timer = UniformRandomTimer(1000, 2000)\n        http_sampler = HttpSampler(\n            "Echo",\n            "https://postman-echo.com/get?var=${__Random(0,10)}",\n            timer,\n            json_extractor,\n        )\n        dummy_sampler = DummySampler("dummy ${variable}", "hi dummy")\n        tg = ThreadGroupWithRampUpAndHold(\n            10, 1, 60, http_sampler, dummy_sampler, name="Some Name"\n        )\n        html_reporter = HtmlReporter()\n        tp = TestPlan(tg, html_reporter)\n        stats = tp.run()\n        print(\n            f"duration= {stats.duration_milliseconds}",\n            f"mean= {stats.sample_time_mean_milliseconds}",\n            f"min= {stats.sample_time_min_milliseconds}",\n            f"median= {stats.sample_time_median_milliseconds}",\n            f"90p= {stats.sample_time_90_percentile_milliseconds}",\n            f"95p= {stats.sample_time_95_percentile_milliseconds}",\n            f"99p= {stats.sample_time_99_percentile_milliseconds}",\n            f"max= {stats.sample_time_max_milliseconds}",\n            sep="\\t",\n        )\n        self.assertLess(stats.sample_time_99_percentile_milliseconds, 2000)\n\n\nif __name__ == "__main__":\n    main()\n\n```\n\nIn this example, the standard python unittest was used to execute the test code, however pymeter is framework agnostic and can be used by any other testing framework\n\n## File Structure\n\n```\n|   .coverage\n|   .gitignore\n|   .pylintrc\n|   cosmic-ray-config.ini\n|   LICENSE\n|   make.bat\n|   Makefile\n|   poetry.lock\n|   pyproject.toml\n|   README.md\n|   tox.ini               \n+---source\n|   |   conf.py\n|   |   index.rst\n|   |   \n|   +---_static\n|   \\---_templates\n+---src\n|   \\---pymeter\n|       |   __init__.py\n|       |   \n|       +---api\n|       |   |   config.py\n|       |   |   postprocessors.py\n|       |   |   reporters.py\n|       |   |   samplers.py\n|       |   |   timers.py\n|       |   |   __init__.py\n|       |   |   \n+---utests\n|   |   test_postprocessors.py\n|   |   test_reporter.py\n|   |   test_sampler.py\n|   |   test_test_plan.py\n|   |   test_thread_group.py\n|   |   test_timers.py\n|   |   __init__.py\n|   |   \n```\n## Code styling\n### `black` used for auto-formatting code [read](https://pypi.org/project/black/),\n### `pylint` used for code linting and pep8 compliance [read](https://pypi.org/project/pylint/),\n### `mypy` used for type hinting [read](https://pypi.org/project/mypy/),\n### `perflint` pylint extension for performance linting [read](https://betterprogramming.pub/use-perflint-a-performance-linter-for-python-eae8e54f1e99)\n### `cosmic-ray` Python tool for mutation testing [read](https://python.plainenglish.io/python-mutation-testing-with-cosmic-ray-4b78eb9e0676)\n\n## links\n1. [JMeter Dsl](https://abstracta.github.io/jmeter-java-dsl/)\n2. [pyjnius](https://github.com/kivy/pyjnius)',
    'author': 'Eldad Uzman',
    'author_email': 'eldadu1985@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/eldaduzman/pymeter',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
