/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jmeter.extractor.XPath2Extractor;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.XPathUtil;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderAsXPath2
implements ResultRenderer,
ActionListener {
    private static final Logger log = LoggerFactory.getLogger(RenderAsXPath2.class);
    private static final String XPATH_TESTER_COMMAND = "xpath_tester";
    private static final String XPATH_NAMESPACES_COMMAND = "xpath_namespaces";
    private JPanel xmlWithXPathPane;
    private JSyntaxTextArea xmlDataField;
    private JTextField xpathExpressionField;
    private JSyntaxTextArea xpathResultField;
    private JTabbedPane rightSide;
    private final JCheckBox getFragment = new JCheckBox(JMeterUtils.getResString((String)"xpath_tester_fragment"));
    private JSyntaxTextArea namespacesTA;

    @Override
    public void clearData() {
        this.xmlDataField.setText("");
        this.xpathResultField.setText("");
    }

    @Override
    public void init() {
        this.xmlWithXPathPane = this.createXpathExtractorPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        String xmlDataFieldText = this.xmlDataField.getText();
        if (StringUtils.isEmpty((CharSequence)xmlDataFieldText)) {
            return;
        }
        if (XPATH_TESTER_COMMAND.equals(command)) {
            XPath2Extractor extractor = new XPath2Extractor();
            extractor.setFragment(this.getFragment.isSelected());
            this.executeAndShowXPathTester(xmlDataFieldText, extractor);
        } else if (XPATH_NAMESPACES_COMMAND.equals(command)) {
            this.xpathResultField.setText(this.getDocumentNamespaces(xmlDataFieldText));
        }
    }

    private void executeAndShowXPathTester(String textToParse, XPath2Extractor extractor) {
        if (textToParse != null && textToParse.length() > 0 && this.xpathExpressionField.getText().length() > 0) {
            this.xpathResultField.setText(this.process(textToParse, extractor));
            this.xpathResultField.setCaretPosition(0);
        }
    }

    private String process(String textToParse, XPath2Extractor extractor) {
        try {
            ArrayList matchStrings = new ArrayList();
            XPathUtil.putValuesForXPathInListUsingSaxon((String)textToParse, (String)this.xpathExpressionField.getText(), matchStrings, (boolean)extractor.getFragment(), (int)-1, (String)this.namespacesTA.getText());
            StringBuilder builder = new StringBuilder();
            int nbFound = matchStrings.size();
            builder.append("Match count: ").append(nbFound).append("\n");
            for (int i = 0; i < nbFound; ++i) {
                builder.append("Match[").append(i + 1).append("]=").append((String)matchStrings.get(i)).append("\n");
            }
            return builder.toString();
        }
        catch (Exception e) {
            return "Exception:" + ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    private String getDocumentNamespaces(String textToParse) {
        StringBuilder result = new StringBuilder();
        try {
            List namespaces = XPathUtil.getNamespaces((String)textToParse);
            for (int i = 0; i < namespaces.size(); ++i) {
                result.append(((String[])namespaces.get(i))[0]).append('=').append(((String[])namespaces.get(i))[1]).append('\n');
            }
            return result.toString();
        }
        catch (Exception e) {
            return "Exception:" + ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    @Override
    public void renderResult(SampleResult sampleResult) {
        String response = ViewResultsFullVisualizer.getResponseAsString(sampleResult);
        response = ViewResultsFullVisualizer.wrapLongLines(response);
        try {
            this.xmlDataField.setText(response == null ? "" : response);
            this.xmlDataField.setCaretPosition(0);
        }
        catch (Exception e) {
            log.error("Exception converting to XML: {}, message: {}", new Object[]{response, e.getMessage(), e});
            this.xmlDataField.setText("Exception converting to XML:" + response + ", message:" + e.getMessage());
            this.xmlDataField.setCaretPosition(0);
        }
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString((String)"xpath2_tester");
    }

    @Override
    public void setupTabPane() {
        if (this.rightSide.indexOfTab(JMeterUtils.getResString((String)"xpath_tester_title")) < 0) {
            this.rightSide.addTab(JMeterUtils.getResString((String)"xpath_tester_title"), this.xmlWithXPathPane);
        }
        this.clearData();
    }

    private JPanel createXpathExtractorPanel() {
        this.xmlDataField = JSyntaxTextArea.getInstance((int)50, (int)80, (boolean)true);
        this.xmlDataField.setCodeFoldingEnabled(true);
        this.xmlDataField.setEditable(true);
        this.xmlDataField.setBracketMatchingEnabled(false);
        this.xmlDataField.setSyntaxEditingStyle("text/xml");
        this.xmlDataField.setLanguage("text/xml");
        this.xmlDataField.setLineWrap(true);
        this.xmlDataField.setWrapStyleWord(true);
        JTextScrollPane xmlDataPane = JTextScrollPane.getInstance((JSyntaxTextArea)this.xmlDataField, (boolean)true);
        xmlDataPane.setMinimumSize(new Dimension(0, 100));
        xmlDataPane.setPreferredSize(new Dimension(0, 200));
        JPanel highPane = new JPanel(new GridLayout(1, 1));
        highPane.add((Component)xmlDataPane);
        JPanel pane = new JPanel(new GridLayout(1, 1));
        JSplitPane mainSplit = new JSplitPane(0, highPane, this.createXpathExtractorTasksPanel());
        mainSplit.setDividerLocation(0.5);
        mainSplit.setOneTouchExpandable(true);
        pane.add(mainSplit);
        return pane;
    }

    private JPanel createXpathExtractorTasksPanel() {
        this.xpathExpressionField = new JTextField(20);
        this.xpathExpressionField.setMinimumSize(new Dimension(50, 20));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"xpath_tester_field"));
        JButton xpathTester = new JButton(JMeterUtils.getResString((String)"xpath_tester_button_test"));
        xpathTester.setActionCommand(XPATH_TESTER_COMMAND);
        xpathTester.addActionListener(this);
        JButton xpathTesterNamespaces = new JButton(JMeterUtils.getResString((String)XPATH_NAMESPACES_COMMAND));
        xpathTesterNamespaces.setActionCommand(XPATH_NAMESPACES_COMMAND);
        xpathTesterNamespaces.addActionListener(this);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.initConstraints(gbc);
        panel.add((Component)label, gbc.clone());
        ++gbc.gridx;
        gbc.gridwidth = 2;
        panel.add((Component)this.xpathExpressionField, gbc.clone());
        gbc.gridx += 2;
        gbc.gridwidth = 2;
        panel.add((Component)xpathTester, gbc.clone());
        gbc.gridx += 2;
        gbc.gridwidth = 2;
        panel.add((Component)xpathTesterNamespaces, gbc.clone());
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        panel.add((Component)new JLabel(JMeterUtils.getResString((String)"xpath_extractor_user_namespaces")), gbc.clone());
        ++gbc.gridx;
        gbc.gridwidth = 6;
        this.namespacesTA = JSyntaxTextArea.getInstance((int)5, (int)40);
        panel.add((Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.namespacesTA, (boolean)true), gbc.clone());
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 8;
        panel.add((Component)this.getFragment, gbc.clone());
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 8;
        this.xpathResultField = JSyntaxTextArea.getInstance((int)10, (int)70, (boolean)true);
        this.xpathResultField.setEditable(false);
        this.xpathResultField.setLineWrap(true);
        this.xpathResultField.setWrapStyleWord(true);
        gbc.fill = 2;
        panel.add((Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.xpathResultField, (boolean)true), gbc.clone());
        return panel;
    }

    private void initConstraints(GridBagConstraints gbc) {
        gbc.fill = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
    }

    @Override
    public synchronized void setRightSide(JTabbedPane side) {
        this.rightSide = side;
    }

    @Override
    public void setSamplerResult(Object userObject) {
    }

    @Override
    public void setLastSelectedTab(int index) {
    }

    @Override
    public void renderImage(SampleResult sampleResult) {
        this.clearData();
        this.xmlDataField.setText(JMeterUtils.getResString((String)"xpath_tester_no_text"));
    }

    @Override
    public void setBackgroundColor(Color backGround) {
    }
}

