/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.base.scale.ScaleUtil;
import jetbrains.datalore.plot.builder.guide.AxisComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ4\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/AxisUtil;", "", "()V", "breaksData", "Ljetbrains/datalore/plot/builder/guide/AxisComponent$BreaksData;", "scale", "Ljetbrains/datalore/plot/base/Scale;", "", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "horizontal", "", "toAxisCoord", "", "scaleBreaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "plot-builder-portable"})
public final class AxisUtil {
    @NotNull
    public static final AxisUtil INSTANCE = new AxisUtil();

    private AxisUtil() {
    }

    @NotNull
    public final AxisComponent.BreaksData breaksData(@NotNull Scale<Double> scale, @NotNull CoordinateSystem coord, boolean horizontal) {
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        ScaleBreaks scaleBreaks = scale.getScaleBreaks();
        List<Double> mappedBreaks = this.toAxisCoord(scaleBreaks, scale, coord, horizontal);
        return new AxisComponent.BreaksData(mappedBreaks, scaleBreaks.getLabels(), null, 4, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final List<Double> toAxisCoord(ScaleBreaks scaleBreaks, Scale<Double> scale, CoordinateSystem coord, boolean horizontal) {
        double axisBr;
        boolean bl;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ScaleUtil.INSTANCE.map(scaleBreaks.getTransformedValues(), scale);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Double d = (Double)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            if (it == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            Double d2 = it.doubleValue();
            collection.add(d2);
        }
        List breaksMapped = (List)destination$iv$iv;
        ArrayList<Double> axisBreaks = new ArrayList<Double>();
        Iterator iterator = breaksMapped.iterator();
        do {
            DoubleVector doubleVector;
            if (!iterator.hasNext()) {
                return axisBreaks;
            }
            double br = ((Number)iterator.next()).doubleValue();
            boolean bl3 = horizontal;
            if (bl3) {
                doubleVector = new DoubleVector(br, 0.0);
            } else {
                if (bl3) {
                    throw new NoWhenBranchMatchedException();
                }
                doubleVector = new DoubleVector(0.0, br);
            }
            DoubleVector mappedBrPoint = doubleVector;
            DoubleVector axisBrPoint = coord.toClient(mappedBrPoint);
            axisBr = horizontal ? axisBrPoint.getX() : axisBrPoint.getY();
            axisBreaks.add(axisBr);
            double d = axisBr;
            boolean bl4 = false;
            double d3 = d;
            boolean bl5 = false;
            if (!Double.isInfinite(d3)) {
                d3 = d;
                bl5 = false;
                if (!Double.isNaN(d3)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (bl);
        throw new IllegalStateException("Illegal axis '" + scale.getName() + "' break position " + axisBr + " at index " + (axisBreaks.size() - 1) + "\nsource breaks    : " + scaleBreaks.getDomainValues() + "\ntranslated breaks: " + breaksMapped + "\naxis breaks      : " + axisBreaks);
    }
}

