/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.aes.AestheticsDefaults;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.base.scale.ScaleUtil;
import jetbrains.datalore.plot.base.scale.breaks.ScaleBreaksUtil;
import jetbrains.datalore.plot.builder.VarBinding;
import jetbrains.datalore.plot.builder.assemble.GuideOptions;
import jetbrains.datalore.plot.builder.assemble.LegendAssemblerUtil;
import jetbrains.datalore.plot.builder.assemble.LegendOptions;
import jetbrains.datalore.plot.builder.assemble.TypedScaleMap;
import jetbrains.datalore.plot.builder.guide.LegendBox;
import jetbrains.datalore.plot.builder.guide.LegendBreak;
import jetbrains.datalore.plot.builder.guide.LegendComponent;
import jetbrains.datalore.plot.builder.guide.LegendComponentLayout;
import jetbrains.datalore.plot.builder.guide.LegendComponentSpec;
import jetbrains.datalore.plot.builder.guide.LegendDirection;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0002 !B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJb\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0016\u0010\u0016\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u001c\u0010\u001b\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u0005J\u0006\u0010\u001e\u001a\u00020\u001fR\u001e\u0010\u0004\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ljetbrains/datalore/plot/builder/assemble/LegendAssembler;", "", "legendTitle", "", "guideOptionsMap", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/builder/assemble/GuideOptions;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "(Ljava/lang/String;Ljava/util/Map;Ljetbrains/datalore/plot/builder/theme/LegendTheme;)V", "legendLayers", "Ljava/util/ArrayList;", "Ljetbrains/datalore/plot/builder/assemble/LegendAssembler$LegendLayer;", "Lkotlin/collections/ArrayList;", "addLayer", "", "keyFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "varBindings", "", "Ljetbrains/datalore/plot/builder/VarBinding;", "constantByAes", "aestheticsDefaults", "Ljetbrains/datalore/plot/base/aes/AestheticsDefaults;", "scaleByAes", "Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;", "transformedDomainByAes", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "createLegend", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "Companion", "LegendLayer", "plot-builder-portable"})
public final class LegendAssembler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String legendTitle;
    @NotNull
    private final Map<Aes<?>, GuideOptions> guideOptionsMap;
    @NotNull
    private final LegendTheme theme;
    @NotNull
    private final ArrayList<LegendLayer> legendLayers;
    private static final boolean DEBUG_DRAWING = false;

    public LegendAssembler(@NotNull String legendTitle, @NotNull Map<Aes<?>, ? extends GuideOptions> guideOptionsMap, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter((Object)legendTitle, (String)"legendTitle");
        Intrinsics.checkNotNullParameter(guideOptionsMap, (String)"guideOptionsMap");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.legendTitle = legendTitle;
        this.guideOptionsMap = guideOptionsMap;
        this.theme = theme;
        this.legendLayers = new ArrayList();
    }

    public final void addLayer(@NotNull LegendKeyElementFactory keyFactory, @NotNull List<VarBinding> varBindings, @NotNull Map<Aes<?>, ? extends Object> constantByAes, @NotNull AestheticsDefaults aestheticsDefaults, @NotNull TypedScaleMap scaleByAes2, @NotNull Map<Aes<?>, ? extends ClosedRange<Double>> transformedDomainByAes) {
        Intrinsics.checkNotNullParameter((Object)keyFactory, (String)"keyFactory");
        Intrinsics.checkNotNullParameter(varBindings, (String)"varBindings");
        Intrinsics.checkNotNullParameter(constantByAes, (String)"constantByAes");
        Intrinsics.checkNotNullParameter((Object)aestheticsDefaults, (String)"aestheticsDefaults");
        Intrinsics.checkNotNullParameter((Object)scaleByAes2, (String)"scaleByAes");
        Intrinsics.checkNotNullParameter(transformedDomainByAes, (String)"transformedDomainByAes");
        this.legendLayers.add(new LegendLayer(keyFactory, varBindings, constantByAes, aestheticsDefaults, scaleByAes2, transformedDomainByAes));
    }

    @NotNull
    public final LegendBoxInfo createLegend() {
        LinkedHashMap legendBreaksByLabel = new LinkedHashMap();
        for (LegendLayer legendLayer : this.legendLayers) {
            LegendKeyElementFactory keyElementFactory = legendLayer.getKeyElementFactory$plot_builder_portable();
            Iterator<DataPointAesthetics> dataPoints2 = legendLayer.getKeyAesthetics$plot_builder_portable().dataPoints().iterator();
            for (String label : legendLayer.getKeyLabels$plot_builder_portable()) {
                Object object;
                Map $this$getOrPut$iv = legendBreaksByLabel;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(label);
                if (value$iv == null) {
                    boolean bl = false;
                    LegendBreak answer$iv = new LegendBreak(label);
                    $this$getOrPut$iv.put(label, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((LegendBreak)object).addLayer(dataPoints2.next(), keyElementFactory);
            }
        }
        ArrayList<LegendBreak> legendBreaks = new ArrayList<LegendBreak>();
        for (Object legendBreak : legendBreaksByLabel.values()) {
            if (((LegendBreak)legendBreak).isEmpty()) continue;
            legendBreaks.add((LegendBreak)legendBreak);
        }
        if (legendBreaks.isEmpty()) {
            return LegendBoxInfo.Companion.getEMPTY();
        }
        ArrayList<LegendOptions> arrayList = new ArrayList<LegendOptions>();
        for (LegendLayer legendLayer : this.legendLayers) {
            List<Aes<?>> aesList = legendLayer.getAesList$plot_builder_portable();
            for (Aes<?> aes : aesList) {
                if (!(this.guideOptionsMap.get(aes) instanceof LegendOptions)) continue;
                GuideOptions guideOptions = this.guideOptionsMap.get(aes);
                if (guideOptions == null) {
                    throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.builder.assemble.LegendOptions");
                }
                arrayList.add((LegendOptions)guideOptions);
            }
        }
        LegendComponentSpec spec = Companion.createLegendSpec(this.legendTitle, (List<LegendBreak>)legendBreaks, this.theme, LegendOptions.Companion.combine((List<LegendOptions>)arrayList));
        DoubleVector doubleVector = spec.getSize();
        return new LegendBoxInfo(spec, doubleVector){
            final /* synthetic */ LegendComponentSpec $spec;
            {
                this.$spec = $spec;
                super($super_call_param$1);
            }

            @NotNull
            public LegendBox createLegendBox() {
                LegendComponent c = new LegendComponent(this.$spec);
                c.setDebug(false);
                return c;
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0016\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u001c\u0010\u000e\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\b\u00a2\u0006\u0002\u0010\u0011R\u001e\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/builder/assemble/LegendAssembler$LegendLayer;", "", "keyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "varBindings", "", "Ljetbrains/datalore/plot/builder/VarBinding;", "constantByAes", "", "Ljetbrains/datalore/plot/base/Aes;", "aestheticsDefaults", "Ljetbrains/datalore/plot/base/aes/AestheticsDefaults;", "scaleMap", "Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;", "transformedDomainByAes", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "(Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;Ljava/util/List;Ljava/util/Map;Ljetbrains/datalore/plot/base/aes/AestheticsDefaults;Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;Ljava/util/Map;)V", "aesList", "getAesList$plot_builder_portable", "()Ljava/util/List;", "keyAesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "getKeyAesthetics$plot_builder_portable", "()Ljetbrains/datalore/plot/base/Aesthetics;", "getKeyElementFactory$plot_builder_portable", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "keyLabels", "", "getKeyLabels$plot_builder_portable", "plot-builder-portable"})
    private static final class LegendLayer {
        @NotNull
        private final LegendKeyElementFactory keyElementFactory;
        @NotNull
        private final List<VarBinding> varBindings;
        @NotNull
        private final Map<Aes<?>, Object> constantByAes;
        @NotNull
        private final AestheticsDefaults aestheticsDefaults;
        @NotNull
        private final TypedScaleMap scaleMap;
        @NotNull
        private final Aesthetics keyAesthetics;
        @NotNull
        private final List<String> keyLabels;

        public LegendLayer(@NotNull LegendKeyElementFactory keyElementFactory, @NotNull List<VarBinding> varBindings, @NotNull Map<Aes<?>, ? extends Object> constantByAes, @NotNull AestheticsDefaults aestheticsDefaults, @NotNull TypedScaleMap scaleMap, @NotNull Map<Aes<?>, ? extends ClosedRange<Double>> transformedDomainByAes) {
            Intrinsics.checkNotNullParameter((Object)keyElementFactory, (String)"keyElementFactory");
            Intrinsics.checkNotNullParameter(varBindings, (String)"varBindings");
            Intrinsics.checkNotNullParameter(constantByAes, (String)"constantByAes");
            Intrinsics.checkNotNullParameter((Object)aestheticsDefaults, (String)"aestheticsDefaults");
            Intrinsics.checkNotNullParameter((Object)scaleMap, (String)"scaleMap");
            Intrinsics.checkNotNullParameter(transformedDomainByAes, (String)"transformedDomainByAes");
            this.keyElementFactory = keyElementFactory;
            this.varBindings = varBindings;
            this.constantByAes = constantByAes;
            this.aestheticsDefaults = aestheticsDefaults;
            this.scaleMap = scaleMap;
            LinkedHashMap aesValuesByLabel = new LinkedHashMap();
            for (VarBinding varBinding : this.varBindings) {
                Aes<?> aes = varBinding.getAes();
                Scale<?> scale = this.scaleMap.get(aes);
                if (!scale.hasBreaks()) {
                    scale = ScaleBreaksUtil.INSTANCE.withBreaks(scale, (ClosedRange)MapsKt.getValue(transformedDomainByAes, aes), 5);
                }
                boolean bl = scale.hasBreaks();
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = Intrinsics.stringPlus((String)"No breaks were defined for scale ", aes);
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                ScaleBreaks scaleBreaks = scale.getScaleBreaks();
                List<?> aesValues = ScaleUtil.INSTANCE.map(scaleBreaks.getTransformedValues(), scale);
                List<String> labels = scaleBreaks.getLabels();
                for (Pair pair2 : CollectionsKt.zip((Iterable)labels, (Iterable)aesValues)) {
                    Object object;
                    Object object2;
                    String label = (String)pair2.component1();
                    Object aesValue = pair2.component2();
                    Map $this$getOrPut$iv = aesValuesByLabel;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(label);
                    if (value$iv == null) {
                        boolean bl5 = false;
                        Map answer$iv = new HashMap();
                        $this$getOrPut$iv.put(label, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    Map map2 = (Map)object2;
                    Intrinsics.checkNotNull((Object)aesValue);
                    boolean bl6 = false;
                    map2.put(aes, object);
                }
            }
            Collection collection = aesValuesByLabel.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"aesValuesByLabel.values");
            this.keyAesthetics = LegendAssemblerUtil.INSTANCE.mapToAesthetics(collection, this.constantByAes, this.aestheticsDefaults);
            this.keyLabels = new ArrayList(aesValuesByLabel.keySet());
        }

        @NotNull
        public final LegendKeyElementFactory getKeyElementFactory$plot_builder_portable() {
            return this.keyElementFactory;
        }

        @NotNull
        public final Aesthetics getKeyAesthetics$plot_builder_portable() {
            return this.keyAesthetics;
        }

        @NotNull
        public final List<String> getKeyLabels$plot_builder_portable() {
            return this.keyLabels;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Aes<?>> getAesList$plot_builder_portable() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.varBindings;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VarBinding varBinding = (VarBinding)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Aes<?> aes = it.getAes();
                collection.add(aes);
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/assemble/LegendAssembler$Companion;", "", "()V", "DEBUG_DRAWING", "", "createLegendSpec", "Ljetbrains/datalore/plot/builder/guide/LegendComponentSpec;", "title", "", "breaks", "", "Ljetbrains/datalore/plot/builder/guide/LegendBreak;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "options", "Ljetbrains/datalore/plot/builder/assemble/LegendOptions;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LegendComponentSpec createLegendSpec(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull LegendTheme theme, @NotNull LegendOptions options) {
            double d;
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            LegendDirection legendDirection = LegendAssemblerUtil.INSTANCE.legendDirection(theme);
            DoubleVector keySize = new DoubleVector(theme.keySize(), theme.keySize());
            for (LegendBreak br : breaks) {
                DoubleVector minimumKeySize = br.getMinimumKeySize();
                keySize = keySize.max(jetbrains.datalore.plot.builder.assemble.LegendAssembler$Companion.createLegendSpec$pretty(minimumKeySize));
            }
            int breakCount = breaks.size();
            int colCount = 0;
            int rowCount = 0;
            if (options.isByRow()) {
                boolean bl;
                int n;
                if (options.hasColCount()) {
                    int n2 = options.getColCount();
                    boolean bl2 = false;
                    n = Math.min(n2, breakCount);
                } else if (options.hasRowCount()) {
                    double d2 = (double)breakCount / (double)options.getRowCount();
                    bl = false;
                    n = (int)Math.ceil(d2);
                } else {
                    n = legendDirection == LegendDirection.HORIZONTAL ? breakCount : 1;
                }
                colCount = n;
                d = (double)breakCount / (double)colCount;
                bl = false;
                rowCount = (int)Math.ceil(d);
            } else {
                boolean bl;
                int n;
                if (options.hasRowCount()) {
                    int n3 = options.getRowCount();
                    boolean bl3 = false;
                    n = Math.min(n3, breakCount);
                } else if (options.hasColCount()) {
                    double d3 = (double)breakCount / (double)options.getColCount();
                    bl = false;
                    n = (int)Math.ceil(d3);
                } else {
                    n = legendDirection != LegendDirection.HORIZONTAL ? breakCount : 1;
                }
                rowCount = n;
                d = (double)breakCount / (double)rowCount;
                bl = false;
                colCount = (int)Math.ceil(d);
            }
            LegendComponentLayout layout = null;
            layout = legendDirection == LegendDirection.HORIZONTAL ? (options.hasRowCount() || options.hasColCount() && options.getColCount() < breakCount ? LegendComponentLayout.Companion.horizontalMultiRow(title, breaks, keySize) : LegendComponentLayout.Companion.horizontal(title, breaks, keySize)) : LegendComponentLayout.Companion.vertical(title, breaks, keySize);
            layout.setColCount(colCount);
            layout.setRowCount(rowCount);
            layout.setFillByRow(options.isByRow());
            return new LegendComponentSpec(title, breaks, theme, layout, false);
        }

        public static /* synthetic */ LegendComponentSpec createLegendSpec$default(Companion companion, String string, List list2, LegendTheme legendTheme, LegendOptions legendOptions, int n, Object object) {
            if ((n & 8) != 0) {
                legendOptions = new LegendOptions();
            }
            return companion.createLegendSpec(string, list2, legendTheme, legendOptions);
        }

        private static final DoubleVector createLegendSpec$pretty(DoubleVector v) {
            double margin = 1.0;
            double d = v.getX() / (double)2;
            boolean bl = false;
            double d2 = Math.floor(d) * (double)2 + 1.0 + margin;
            d = v.getY() / (double)2;
            bl = false;
            return new DoubleVector(d2, Math.floor(d) * (double)2 + 1.0 + margin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

