/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.stat.BaseStat;
import jetbrains.datalore.plot.base.stat.CorrelationStat;
import jetbrains.datalore.plot.base.stat.CorrelationUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0003\"#$B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ;\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e0\u0019H\u0016J\u0012\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Ljetbrains/datalore/plot/base/stat/CorrelationStat;", "Ljetbrains/datalore/plot/base/stat/BaseStat;", "correlationMethod", "Ljetbrains/datalore/plot/base/stat/CorrelationStat$Method;", "type", "Ljetbrains/datalore/plot/base/stat/CorrelationStat$Type;", "fillDiagonal", "", "threshold", "", "(Ljetbrains/datalore/plot/base/stat/CorrelationStat$Method;Ljetbrains/datalore/plot/base/stat/CorrelationStat$Type;ZD)V", "getCorrelationMethod", "()Ljetbrains/datalore/plot/base/stat/CorrelationStat$Method;", "getFillDiagonal", "()Z", "getThreshold", "()D", "getType", "()Ljetbrains/datalore/plot/base/stat/CorrelationStat$Type;", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "consumes", "", "Ljetbrains/datalore/plot/base/Aes;", "Companion", "Method", "Type", "plot-base-portable"})
public final class CorrelationStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Method correlationMethod;
    @NotNull
    private final Type type;
    private final boolean fillDiagonal;
    private final double threshold;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;
    @NotNull
    private static final Method DEF_CORRELATION_METHOD;
    @NotNull
    private static final Type DEF_TYPE;
    public static final boolean DEF_FILL_DIAGONAL = true;
    public static final double DEF_THRESHOLD = 0.0;

    public CorrelationStat(@NotNull Method correlationMethod, @NotNull Type type, boolean fillDiagonal, double threshold) {
        Intrinsics.checkNotNullParameter((Object)((Object)correlationMethod), (String)"correlationMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(DEF_MAPPING);
        this.correlationMethod = correlationMethod;
        this.type = type;
        this.fillDiagonal = fillDiagonal;
        this.threshold = threshold;
    }

    @NotNull
    public final Method getCorrelationMethod() {
        return this.correlationMethod;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final boolean getFillDiagonal() {
        return this.fillDiagonal;
    }

    public final double getThreshold() {
        return this.threshold;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        boolean bl = this.correlationMethod == Method.PEARSON;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unsupported correlation method: " + (Object)((Object)this.getCorrelationMethod()) + " (only Pearson is currently available)";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        double d = this.threshold;
        boolean bl5 = 0.0 <= d ? d <= 1.0 : false;
        bl2 = false;
        bl3 = false;
        if (!bl5) {
            boolean bl6 = false;
            String string = "Threshold value:  " + this.getThreshold() + " must be in interval [0.0, 1.0]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        messageConsumer.invoke((Object)"WARN (!): \"corr stat\" is deprecated. Please use \"corr_plot()\"");
        DataFrame cm2 = CorrelationUtil.INSTANCE.correlationMatrix(data, this.type, this.fillDiagonal, (Function2<? super double[], ? super double[], Double>)((Function2)apply.cm.1.INSTANCE), this.threshold);
        List<Double> values2 = cm2.getNumeric(Stats.INSTANCE.getCORR());
        Iterable $this$map$iv = values2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Double d2;
            void it;
            Double d3 = (Double)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl7 = false;
            void var16_25 = it;
            if (var16_25 == null) {
                d2 = null;
            } else {
                void var17_26 = var16_25;
                boolean bl8 = false;
                boolean bl9 = false;
                double p0 = ((Number)var17_26).doubleValue();
                boolean bl10 = false;
                boolean bl11 = false;
                d2 = Math.abs(p0);
            }
            Double d4 = d2;
            collection.add(d4);
        }
        List abs = (List)destination$iv$iv;
        return cm2.builder().putNumeric(Stats.INSTANCE.getCORR_ABS(), abs).build();
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY()), TuplesKt.to(Aes.Companion.getCOLOR(), (Object)Stats.INSTANCE.getCORR()), TuplesKt.to(Aes.Companion.getFILL(), (Object)Stats.INSTANCE.getCORR()), TuplesKt.to(Aes.Companion.getLABEL(), (Object)Stats.INSTANCE.getCORR())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
        DEF_CORRELATION_METHOD = Method.PEARSON;
        DEF_TYPE = Type.FULL;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/base/stat/CorrelationStat$Method;", "", "(Ljava/lang/String;I)V", "PEARSON", "SPEARMAN", "KENDALL", "plot-base-portable"})
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method PEARSON = new Method();
        public static final /* enum */ Method SPEARMAN = new Method();
        public static final /* enum */ Method KENDALL = new Method();
        private static final /* synthetic */ Method[] $VALUES;

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String value) {
            return Enum.valueOf(Method.class, value);
        }

        static {
            $VALUES = methodArray = new Method[]{Method.PEARSON, Method.SPEARMAN, Method.KENDALL};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ljetbrains/datalore/plot/base/stat/CorrelationStat$Type;", "", "(Ljava/lang/String;I)V", "FULL", "UPPER", "LOWER", "plot-base-portable"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type FULL = new Type();
        public static final /* enum */ Type UPPER = new Type();
        public static final /* enum */ Type LOWER = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.FULL, Type.UPPER, Type.LOWER};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/base/stat/CorrelationStat$Companion;", "", "()V", "DEF_CORRELATION_METHOD", "Ljetbrains/datalore/plot/base/stat/CorrelationStat$Method;", "getDEF_CORRELATION_METHOD", "()Ljetbrains/datalore/plot/base/stat/CorrelationStat$Method;", "DEF_FILL_DIAGONAL", "", "DEF_MAPPING", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "DEF_THRESHOLD", "", "DEF_TYPE", "Ljetbrains/datalore/plot/base/stat/CorrelationStat$Type;", "getDEF_TYPE", "()Ljetbrains/datalore/plot/base/stat/CorrelationStat$Type;", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Method getDEF_CORRELATION_METHOD() {
            return DEF_CORRELATION_METHOD;
        }

        @NotNull
        public final Type getDEF_TYPE() {
            return DEF_TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

