/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.vis.svg.SvgImageElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/plot/base/geom/ImageGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "imageUrl", "", "(Ljava/lang/String;)V", "buildIntern", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "Companion", "plot-base-portable"})
public final class ImageGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String imageUrl;
    public static final boolean HANDLES_GROUPS = false;

    public ImageGeom(@NotNull String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        this.imageUrl = imageUrl;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        if (aesthetics.isEmpty()) {
            return;
        }
        DataPointAesthetics p = aesthetics.dataPointAt(0);
        Double d = p.xmin();
        Intrinsics.checkNotNull((Object)d);
        double d2 = d;
        Double d3 = p.ymin();
        Intrinsics.checkNotNull((Object)d3);
        DoubleVector doubleVector = new DoubleVector(d2, d3);
        Double d4 = p.xmax();
        Intrinsics.checkNotNull((Object)d4);
        double d5 = d4;
        Double d6 = p.ymax();
        Intrinsics.checkNotNull((Object)d6);
        DoubleRectangle boundsAes = DoubleRectangle.Companion.span(doubleVector, new DoubleVector(d5, d6));
        GeomHelper helper = new GeomHelper(pos, coord, ctx2);
        DoubleRectangle boundsClient = helper.toClient(boundsAes, p);
        SvgImageElement svgImageElement = new SvgImageElement(boundsClient.getOrigin().getX(), boundsClient.getOrigin().getY(), boundsClient.getDimension().getX(), boundsClient.getDimension().getY());
        svgImageElement.href().set(this.imageUrl);
        root.add(svgImageElement);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/geom/ImageGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

