/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.control;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.TransactionController;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class WeightedSwitchController
extends GenericController
implements Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String WEIGHTS = "Weights";
    public static final String IS_RANDOM_CHOICE = "IsRandomChoice";
    private boolean chosen = false;
    protected long[] counts = null;
    protected long totalCount = 0L;
    protected transient int currentCopy;

    public void setData(PowerTableModel model) {
        CollectionProperty prop = JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)model, (String)WEIGHTS);
        this.setProperty((JMeterProperty)prop);
    }

    public CollectionProperty getData() {
        JMeterProperty prop = this.getProperty(WEIGHTS);
        if (prop instanceof CollectionProperty) {
            return this.setEnabledSubGroups((CollectionProperty)prop);
        }
        log.warn("Returning empty collection");
        return new CollectionProperty();
    }

    public void setIsRandomChoice(boolean value) {
        this.setProperty(IS_RANDOM_CHOICE, value);
    }

    public boolean isRandomChoice() {
        return this.getPropertyAsBoolean(IS_RANDOM_CHOICE, false);
    }

    public Sampler next() {
        if (this.chosen) {
            Sampler result = super.next();
            if (result == null || this.currentCopy != this.current) {
                this.reset();
                for (TestElement element : super.getSubControllers()) {
                    if (!(element instanceof Controller)) continue;
                    this.resetController((Controller)element);
                }
                return null;
            }
            return result;
        }
        this.chosen = true;
        this.choose();
        return super.next();
    }

    private void resetController(Controller element) {
        if (element instanceof TransactionController) {
            if (element.getPropertyAsBoolean("TransactionController.parent")) {
                this.reInitializeController((TransactionController)element);
                return;
            }
            this.nullifyRes((TransactionController)element);
        } else if (element instanceof GenericController) {
            GenericController ctrl = (GenericController)element;
            List<TestElement> subControllersAndSamplers = this.getSubControllersAndSamplers(ctrl);
            for (TestElement te : subControllersAndSamplers) {
                if (!(te instanceof Controller)) continue;
                this.resetController((Controller)te);
            }
        }
        element.triggerEndOfLoop();
    }

    private List<TestElement> getSubControllersAndSamplers(GenericController ctrl) {
        try {
            Field subControllersAndSamplers = GenericController.class.getDeclaredField("subControllersAndSamplers");
            subControllersAndSamplers.setAccessible(true);
            return (List)subControllersAndSamplers.get(ctrl);
        }
        catch (Throwable ex) {
            log.warn("Failed to get SubControllers And Samplers", ex);
            return Collections.emptyList();
        }
    }

    private void reInitializeController(TransactionController element) {
        try {
            Method reInitialize = GenericController.class.getDeclaredMethod("reInitialize", new Class[0]);
            reInitialize.setAccessible(true);
            reInitialize.invoke((Object)element, new Object[0]);
        }
        catch (Throwable ex) {
            log.warn("Failed to reInitialize TransactionController", ex);
        }
    }

    private void nullifyRes(TransactionController element) {
        try {
            Field res = TransactionController.class.getDeclaredField("res");
            res.setAccessible(true);
            res.set(element, null);
        }
        catch (Throwable ex) {
            log.warn("Failed to nullify TransactionController.res field", ex);
        }
    }

    private void choose() {
        int index;
        CollectionProperty data = this.removeDisableSubGroups(this.getData());
        double[] weights = this.getWeights(data);
        this.current = this.currentCopy = (index = this.isRandomChoice() ? this.getRandomIndex(weights) : this.getIndex(weights));
    }

    private int getRandomIndex(double[] weights) {
        double totalWeight = 0.0;
        for (double i : weights) {
            totalWeight += i;
        }
        int randomIndex = 0;
        double random = Math.random() * totalWeight;
        for (int i = 0; i < weights.length; ++i) {
            if (!((random -= weights[i]) <= 0.0)) continue;
            randomIndex = i;
            break;
        }
        return randomIndex;
    }

    private int getIndex(double[] weights) {
        int n;
        if (this.counts == null) {
            log.debug("Creating array: " + weights.length);
            this.counts = new long[weights.length];
        }
        double maxDiff = Double.MIN_VALUE;
        int maxDiffIndex = Integer.MIN_VALUE;
        for (n = 0; n < weights.length; ++n) {
            double factWeight = this.totalCount > 0L ? (double)this.counts[n] / (double)this.totalCount : 0.0;
            double diff = weights[n] - factWeight;
            if (!(diff > maxDiff)) continue;
            maxDiff = diff;
            maxDiffIndex = n;
        }
        if (maxDiffIndex == Integer.MIN_VALUE) {
            for (n = 0; n < weights.length; ++n) {
                double diff = weights[n];
                if (!(diff > maxDiff)) continue;
                maxDiff = diff;
                maxDiffIndex = n;
            }
        }
        ++this.totalCount;
        int n2 = maxDiffIndex;
        this.counts[n2] = this.counts[n2] + 1L;
        return maxDiffIndex;
    }

    private CollectionProperty removeDisableSubGroups(CollectionProperty data) {
        CollectionProperty result = new CollectionProperty();
        for (int i = 0; i < data.size(); ++i) {
            JMeterProperty property = data.get(i);
            if (!(property instanceof CollectionProperty) || ((CollectionProperty)property).size() != 3 || !"true".equals(((CollectionProperty)property).get(2).getStringValue())) continue;
            result.addProperty(property);
        }
        return result;
    }

    private CollectionProperty setEnabledSubGroups(CollectionProperty data) {
        for (int i = 0; i < data.size(); ++i) {
            CollectionProperty prop;
            JMeterProperty property = data.get(i);
            if (!(property instanceof CollectionProperty) || (prop = (CollectionProperty)property).size() != 2) continue;
            prop.addItem((Object)"true");
        }
        this.setProperty((JMeterProperty)data);
        return data;
    }

    private double[] getWeights(CollectionProperty data) {
        int n;
        long sum = 0L;
        double[] weights = new double[data.size()];
        for (n = 0; n < data.size(); ++n) {
            CollectionProperty row = (CollectionProperty)data.get(n);
            weights[n] = Long.parseLong(row.get(1).getStringValue());
            sum = (long)((double)sum + weights[n]);
        }
        n = 0;
        while (n < weights.length) {
            int n2 = n++;
            weights[n2] = weights[n2] / (double)sum;
        }
        return weights;
    }

    public void reset() {
        this.chosen = false;
        for (TestElement controller : this.getSubControllers()) {
            if (!(controller instanceof WeightedSwitchController)) continue;
            ((WeightedSwitchController)controller).reset();
        }
    }
}

