/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.jmeter.util.JMeterUtils;

public class DescriptiveStatisticsFactory {
    private static final int SLIDING_WINDOW_SIZE = JMeterUtils.getPropDefault("backend_metrics_window", 100);
    private static final Percentile.EstimationType ESTIMATION_TYPE = Percentile.EstimationType.valueOf((String)JMeterUtils.getPropDefault("backend_metrics_percentile_estimator", "LEGACY"));

    private DescriptiveStatisticsFactory() {
    }

    public static DescriptiveStatistics createDescriptiveStatistics() {
        return DescriptiveStatisticsFactory.createDescriptiveStatistics(SLIDING_WINDOW_SIZE);
    }

    public static DescriptiveStatistics createDescriptiveStatistics(int windowSize) {
        DescriptiveStatistics statistics = new DescriptiveStatistics(windowSize);
        statistics.setPercentileImpl((UnivariateStatistic)new Percentile().withEstimationType(ESTIMATION_TYPE));
        return statistics;
    }
}

