/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.control.TransactionController;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;

public class TransactionSampler
extends AbstractSampler {
    private static final long serialVersionUID = 240L;
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.SimpleConfigGui"));
    private boolean transactionDone = false;
    private TransactionController transactionController;
    private Sampler subSampler;
    private SampleResult transactionSampleResult;
    private int calls = 0;
    private int noFailingSamples = 0;
    private long totalTime = 0L;
    private long totalConnectTime = 0L;

    @Deprecated
    public TransactionSampler() {
    }

    public TransactionSampler(TransactionController controller, String name) {
        this.transactionController = controller;
        this.setName(name);
        this.transactionSampleResult = new SampleResult();
        this.transactionSampleResult.setSampleLabel(name);
        this.transactionSampleResult.setSuccessful(true);
        this.transactionSampleResult.sampleStart();
    }

    @Override
    public SampleResult sample(Entry e) {
        throw new RuntimeException("Cannot sample TransactionSampler directly");
    }

    public Sampler getSubSampler() {
        return this.subSampler;
    }

    public SampleResult getTransactionResult() {
        return this.transactionSampleResult;
    }

    public TransactionController getTransactionController() {
        return this.transactionController;
    }

    public boolean isTransactionDone() {
        return this.transactionDone;
    }

    public void addSubSamplerResult(SampleResult res) {
        ++this.calls;
        if (this.noFailingSamples == 0) {
            this.transactionSampleResult.setResponseCode(res.getResponseCode());
        }
        if (!res.isSuccessful()) {
            this.transactionSampleResult.setSuccessful(false);
            ++this.noFailingSamples;
        }
        this.transactionSampleResult.addSubResult(res, false);
        this.totalTime += res.getTime();
        this.totalConnectTime += res.getConnectTime();
    }

    protected void setTransactionDone() {
        this.transactionDone = true;
        this.transactionSampleResult.setResponseMessage("Number of samples in transaction : " + this.calls + ", number of failing samples : " + this.noFailingSamples);
        if (this.transactionSampleResult.isSuccessful()) {
            this.transactionSampleResult.setResponseCodeOK();
        }
        if (!this.transactionController.isIncludeTimers()) {
            long end = this.transactionSampleResult.currentTimeInMillis();
            this.transactionSampleResult.setIdleTime(end - this.transactionSampleResult.getStartTime() - this.totalTime);
            this.transactionSampleResult.setEndTime(end);
        }
        this.transactionSampleResult.setConnectTime(this.totalConnectTime);
    }

    protected void setSubSampler(Sampler subSampler) {
        this.subSampler = subSampler;
    }

    @Override
    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }
}

