/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.regression;

import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.plot.base.stat.math3.LoessInterpolator;
import jetbrains.datalore.plot.base.stat.math3.PolynomialSplineFunction;
import jetbrains.datalore.plot.base.stat.math3.TDistribution;
import jetbrains.datalore.plot.base.stat.regression.EvalResult;
import jetbrains.datalore.plot.base.stat.regression.RegressionEvaluator;
import jetbrains.datalore.plot.base.stat.regression.RegressionUtilKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/base/stat/regression/LocalPolynomialRegression;", "Ljetbrains/datalore/plot/base/stat/regression/RegressionEvaluator;", "xs", "", "", "ys", "confidenceLevel", "bandwidth", "(Ljava/util/List;Ljava/util/List;DD)V", "canCompute", "", "getCanCompute", "()Z", "meanX", "n", "", "polynomial", "Ljetbrains/datalore/plot/base/stat/math3/PolynomialSplineFunction;", "sumXX", "sy", "tcritical", "evalX", "Ljetbrains/datalore/plot/base/stat/regression/EvalResult;", "x", "getPoly", "xVals", "", "yVals", "plot-base-portable"})
public final class LocalPolynomialRegression
extends RegressionEvaluator {
    private final double bandwidth;
    private final boolean canCompute;
    private final int n;
    private final double meanX;
    private final double sumXX;
    private final double sy;
    private final double tcritical;
    private PolynomialSplineFunction polynomial;

    /*
     * WARNING - void declaration
     */
    public LocalPolynomialRegression(@NotNull List<Double> xs, @NotNull List<Double> ys, double confidenceLevel, double bandwidth) {
        double d;
        void $this$_init__u24lambda_u2d3;
        double d2;
        int n;
        boolean bl;
        double d3;
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        super(xs, ys, confidenceLevel);
        this.bandwidth = bandwidth;
        Pair<double[], double[]> pair = RegressionUtilKt.averageByX(xs, ys);
        double[] xVals = (double[])pair.component1();
        double[] yVals = (double[])pair.component2();
        this.n = xVals.length;
        double degreesOfFreedom = (double)this.n - 2.0;
        int bandwidthInPoints = (int)(this.bandwidth * (double)this.n);
        boolean bandwidthInPointsOk = bandwidthInPoints >= 2;
        this.canCompute = this.n >= 3 && degreesOfFreedom > 0.0 && bandwidthInPointsOk;
        this.meanX = ArraysKt.average((double[])xVals);
        double[] dArray = xVals;
        LocalPolynomialRegression localPolynomialRegression = this;
        boolean bl2 = false;
        double d4 = 0.0;
        double[] dArray2 = dArray;
        int n2 = dArray2.length;
        for (int i = 0; i < n2; ++i) {
            void it22;
            double d5;
            double d6 = d5 = dArray2[i];
            d3 = d4;
            boolean bl3 = false;
            void var26_34 = it22 - this.meanX;
            int n3 = 2;
            bl = false;
            double d7 = Math.pow((double)var26_34, n3);
            d4 = d3 + d7;
        }
        localPolynomialRegression.sumXX = d3 = d4;
        double meanY = ArraysKt.average((double[])yVals);
        dArray2 = yVals;
        n2 = 0;
        double d8 = 0.0;
        double[] dArray3 = dArray2;
        int it22 = dArray3.length;
        for (int i = 0; i < it22; ++i) {
            void it;
            double d9;
            double d10 = d9 = dArray3[i];
            double d11 = d8;
            boolean bl4 = false;
            void var30_50 = it - meanY;
            n = 2;
            boolean bl5 = false;
            d2 = Math.pow((double)var30_50, n);
            d8 = d11 + d2;
        }
        double sumYY = d8;
        Object object = ArraysKt.zip((double[])xVals, (double[])yVals);
        boolean bl6 = false;
        double d12 = 0.0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            void $dstr$x$y;
            Object t = iterator.next();
            Pair pair2 = (Pair)t;
            double d13 = d12;
            boolean bl7 = false;
            double x = ((Number)$dstr$x$y.component1()).doubleValue();
            double y = ((Number)$dstr$x$y.component2()).doubleValue();
            d2 = (x - this.meanX) * (y - meanY);
            d12 = d13 + d2;
        }
        double sumXY = d12;
        object = this;
        bl6 = false;
        boolean bl8 = false;
        LocalPolynomialRegression it22 = (LocalPolynomialRegression)object;
        localPolynomialRegression = this;
        boolean bl9 = false;
        double d14 = 0.0;
        double d15 = sumYY - sumXY * sumXY / $this$_init__u24lambda_u2d3.sumXX;
        bl = false;
        double sse = Math.max(d14, d15);
        d14 = sse / (double)($this$_init__u24lambda_u2d3.n - 2);
        n = 0;
        d3 = Math.sqrt(d14);
        localPolynomialRegression.sy = d3;
        if (this.canCompute) {
            this.polynomial = this.getPoly(xVals, yVals);
        }
        if (this.canCompute) {
            double alpha = 1.0 - confidenceLevel;
            d = new TDistribution(degreesOfFreedom, 0.0, 2, null).inverseCumulativeProbability(1.0 - alpha / 2.0);
        } else {
            d = Double.NaN;
        }
        this.tcritical = d;
    }

    public final boolean getCanCompute() {
        return this.canCompute;
    }

    @Override
    @NotNull
    public EvalResult evalX(double x) {
        PolynomialSplineFunction polynomialSplineFunction;
        LocalPolynomialRegression localPolynomialRegression = this;
        boolean bl = false;
        boolean bl2 = false;
        LocalPolynomialRegression $this$evalX_u24lambda_u2d4 = localPolynomialRegression;
        boolean bl3 = false;
        double d = x - $this$evalX_u24lambda_u2d4.meanX;
        int n = 2;
        boolean bl4 = false;
        double dxSquare = Math.pow(d, n);
        d = 1.0 / (double)$this$evalX_u24lambda_u2d4.n + dxSquare / $this$evalX_u24lambda_u2d4.sumXX;
        n = 0;
        double se = $this$evalX_u24lambda_u2d4.sy * Math.sqrt(d);
        double halfConfidenceInterval = this.tcritical * se;
        PolynomialSplineFunction polynomialSplineFunction2 = this.polynomial;
        if (polynomialSplineFunction2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"polynomial");
            polynomialSplineFunction = null;
        } else {
            polynomialSplineFunction = polynomialSplineFunction2;
        }
        Double d2 = polynomialSplineFunction.value(x);
        Intrinsics.checkNotNull((Object)d2);
        double yHat = d2;
        return new EvalResult(yHat, yHat - halfConfidenceInterval, yHat + halfConfidenceInterval, se);
    }

    private final PolynomialSplineFunction getPoly(double[] xVals, double[] yVals) {
        return new LoessInterpolator(this.bandwidth, 4, 0.0, 4, null).interpolate(xVals, yVals);
    }
}

