/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jorphan.util.JOrphanUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormCharSetFinder {
    private static final Logger log = LoggerFactory.getLogger(FormCharSetFinder.class);

    public void addFormActionsAndCharSet(String html, Map<String, String> formEncodings, String pageEncoding) throws HTMLParseException {
        Document document;
        log.debug("Parsing html of: {}", (Object)html);
        try {
            document = Jsoup.parse((String)html);
        }
        catch (RuntimeException e) {
            throw new HTMLParseException("Could not parse HTML to look for forms charsets", e);
        }
        Elements forms = document.select("form");
        for (Element element : forms) {
            String[] charSets;
            String action = element.attr("action");
            if (StringUtils.isEmpty((CharSequence)action)) continue;
            String formCharSet = pageEncoding;
            String acceptCharSet = element.attr("accept-charset");
            if (acceptCharSet != null && (charSets = JOrphanUtils.split((String)acceptCharSet, (String)",")).length > 0 && (formCharSet = charSets[0].trim()).isEmpty()) {
                formCharSet = null;
            }
            if (formCharSet == null) continue;
            formEncodings.put(action, formCharSet);
        }
    }
}

