# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['nonebot_plugin_access_control',
 'nonebot_plugin_access_control.matchers',
 'nonebot_plugin_access_control.models',
 'nonebot_plugin_access_control.subject',
 'nonebot_plugin_access_control.utils']

package_data = \
{'': ['*']}

install_requires = \
['aiosqlite>=0.17.0,<0.18.0',
 'nonebot2>=2.0.0rc1,<3.0.0',
 'sqlalchemy[asyncio]>=1.4.42,<2.0.0']

setup_kwargs = {
    'name': 'nonebot-plugin-access-control',
    'version': '0.1.2',
    'description': '',
    'long_description': '<!-- markdownlint-disable MD033 MD036 MD041 -->\n\n<p align="center">\n  <a href="https://v2.nonebot.dev/"><img src="https://v2.nonebot.dev/logo.png" width="200" height="200" alt="nonebot"></a>\n</p>\n\n<div align="center">\n\nnonebot-plugin-access-control\n============\n\n_✨ Nonebot 权限控制 ✨_\n\n</div>\n\n\n<p align="center">\n  <a href="https://raw.githubusercontent.com/ssttkkl/nonebot-plugin-access-control/master/LICENSE">\n    <img src="https://img.shields.io/github/license/ssttkkl/nonebot-plugin-access-control.svg" alt="license">\n  </a>\n  <a href="https://pypi.python.org/pypi/nonebot-plugin-access-control">\n    <img src="https://img.shields.io/pypi/v/nonebot-plugin-access-control.svg" alt="pypi">\n  </a>\n  <img src="https://img.shields.io/badge/python-3.9+-blue.svg" alt="python">\n</p>\n\n## 特点\n\n- [x] 支持**功能级别**的细粒度权限控制\n- [x] 对未适配插件也支持**插件级别**的权限控制\n- [x] 支持对权限开关等事件进行订阅\n\n## 使用\n\n### 主体\n\n#### 概念\n\n让我们从一个例子引入：QQ上群组G的用户U发送了一条消息，该用户同时具有“用户U”、“群组G成员”、“QQ用户”、“Bot用户”这几个身份。同时QQ上群组G的用户V也发送了一条消息，该用户该用户同时具有“用户V”、“群组G成员”、“QQ用户”、“Bot用户”这几个身份。\n\n如果我们希望对用户进行权限控制，我们可以直接针对“用户U”、“用户V”这个级别分别配置权限。但我们希望对群组进行权限控制时，对群组内的每一个用户都分别配置权限，就有点力不从心了。我们希望能够直接针对“群组G”这个级别进行配置，而无需关心群组内都有什么成员。\n\n我们定义**主体（Subject）为用户所具有的身份，也是设置权限的基本单位。**\n\n一个用户通常拥有多个主体。回到上面的例子，第一位用户拥有“用户U”、“群组G成员”、“QQ用户”、“Bot用户”这四个主体；第二位用户拥有“用户V”、“群组G成员”、“QQ用户”、“Bot用户”这四个主体。用户拥有的所有主体，按照规模从小到大排序，呈现如下图的逐层包含关系：\n\n![](docs/img/1.svg)\n\n当设置权限时，我们直接针对一个主体进行设置。当鉴权时，我们对用户的所有主体按规模从小到大的顺序（下文将此顺序称为优先级顺序），逐一检查是否设置了权限。一旦检查到某个主体设置了权限，就以该主体设置的权限作为该用户的权限。\n\n回到上面的例子，假设我们对主体”群组G“禁用服务，但是对主体”用户V“启用服务。则用户U在群组G内将无法使用服务，但是用户V在群组G内可以使用。\n\n#### 应用\n\n在实际应用中，我们用一个字符串表示主体。并且我们约定，`all`表示所有用户，`<协议名>`表示所有此协议的用户，除此之外的所有主体均以`<协议名>:`开头。\n\n在OneBot协议中，每个用户所拥有的主体如下表所定义：\n\n| 主体                 | 含义       | 示例               | 必定存在             |\n|--------------------|----------|------------------|------------------|\n| onebot:<user_id>   | 用户       | onebot:12345678  | 是                |\n| onebot:g<group_id> | 群组       | onebot:g87654321 | 仅当消息来自群组或临时会话时存在 |\n| onebot             | OneBot用户 | onebot           | 是                |\n| all                | 所有用户     | all              | 是                |\n\n目前仅实现了OneBot协议。如果你能帮助我们进行其他协议适配，欢迎提交PR。\n\n### 服务\n\n**服务（Service）为一组能够进行权限控制的功能的集合。** 服务可以拥有子服务，通过树形结构组织服务，统一管理权限。\n\n整个NoneBot是一个名为nonebot的服务，为树形结构的根节点，其直接子节点为所有插件。\n\n一个插件是一个服务（PluginService），其父节点为nonebot。\n\n当插件未进行适配时，该插件只具有这一个PluginService。 对插件进行适配，则需要从插件的PluginService创建SubService，为插件的Matcher等功能入口应用SubService。（参考下文插件适配章节）\n\n（为防止意外发生，nonebot_plugin_access_control本身不可以进行权限开关）\n\n### 指令\n\n进行权限开关的指令为`/ac`，仅超级用户可用。（通过在配置文件中设置`SUPERUSERS`变量可设置超级用户）\n\n- `/ac subject <主体> allow service <服务>`：为主体启用服务\n- `/ac subject <主体> deny service <服务>`：为主体禁用服务\n- `/ac subject <主体> remove service <服务>`：为主体删除服务权限配置\n- `/ac subject <主体> ls service`：列出主体已配置的服务权限\n- `/ac service <服务> ls`：列出服务的子服务层级\n- `/ac service <服务> ls subject`：列出服务已配置的主体权限\n\n其中`<服务>`的格式如下：\n\n- `nonebot`：对整个NoneBot进行开关\n- `<插件名>`：对整个插件进行开关\n- `<插件名>.<子服务名>.<子服务名>.....<子服务名>`：对插件内的某个子服务进行开关（需参照下文对插件进行配置）\n\n### 示例\n\n首先编辑配置文件，打开对未适配插件的支持：\n```\nACCESS_CONTROL_AUTO_PATCH_ENABLED=true\n```\n\n假设bot加载了内置插件echo\n\n```python\nnonebot.load_builtin_plugins("echo")\n```\n\n执行下面的指令后，用户12345678将无法调用指令`/echo`\n\n```\n/ac subject onebot:12345678 deny service echo\n```\n\n执行下面的指令后，用户12345678将无法调用所有指令\n\n```\n/ac subject all deny service nonebot\n```\n\n执行下面的指令后，群组87654321的所有用户（用户12345678除外）将无法调用指令`/echo`\n\n```\n/ac subject onebot:12345678 allow service echo\n/ac subject onebot:g87654321 deny service echo\n```\n\n执行下面的指令后，所有用户将无法调用指令`/echo`\n\n```\n/ac subject all deny service echo\n```\n\n## 插件适配\n\n完整代码：[src/nonebot_plugin_ac_demo/matcher_demo.py](src/nonebot_plugin_ac_demo/matcher_demo.py)\n\n1. 创建一个名为nonebot_plugin_ac_demo的插件\n\n2. 通过create_plugin_service函数创建一个PluginService实例（注意参数必须为插件包名）\n\n```python\nfrom nonebot import require\n\nrequire("nonebot_plugin_access_control")\n\nfrom nonebot_plugin_access_control.service import create_plugin_service\n\nplugin_service = create_plugin_service("nonebot_plugin_ac_demo")\n```\n\n3. 通过PluginService.create_subservice创建SubService实例。调用`Service.patch_matcher()`应用至Matcher\n\n```python\ngroup1 = plugin_service.create_subservice("group1")\n\na_matcher = on_command(\'a\')\na_service = group1.create_subservice(\'a\')\na_service.patch_matcher(a_matcher)\n\n@a_matcher.handle()\nasync def _(matcher: Matcher):\n    await matcher.send("a")\n\n    \nb_matcher = on_command(\'b\')\nb_service = group1.create_subservice(\'b\')\nb_service.patch_matcher(b_matcher)\n\n@b_matcher.handle()\nasync def _(matcher: Matcher):\n    await matcher.send("b")\n\n    \nc_matcher = on_command(\'c\')\nc_service = plugin_service.create_subservice(\'c\')\nc_service.patch_matcher(c_matcher)\n\n@c_matcher.handle()\nasync def _(matcher: Matcher):\n    await matcher.send("c")\n```\n\n插件服务的结构如下所示：\n\n![](docs/img/2.svg)\n\n4. 通过指令配置服务权限\n\n执行下面的指令后，所有用户将无法调用指令`/a`与`/b`\n\n```\n/ac subject all deny service nonebot_plugin_ac_demo.group1\n```\n\n执行下面的指令后，用户12345678将无法调用指令`/a`\n\n```\n/ac subject onebot:12345678 deny service nonebot_plugin_ac_demo.group1.a\n```\n\n执行下面的指令后，群组87654321的所有用户将无法调用除`/c`以外的任何指令\n\n```\n/ac subject onebot:g87654321 deny service nonebot_plugin_ac_demo\n/ac subject onebot:g87654321 allow service nonebot_plugin_ac_demo.c\n```\n\n5. 手动鉴权\n\n对于非Matcher的功能入口（如APScheduler的定时任务等），需要开发者手动进行鉴权。\n\n- 方法一：调用`service.check(Bot, Event)`方法，传入Bot及Event实例，返回bool值表示该用户是否具有权限\n- 方法二：调用`service.get_permission(*str)`方法，传入主体字符串，返回bool值表示该用户是否具有权限\n\nAPScheduler示例：[src/nonebot_plugin_ac_demo/apscheduler_demo.py](src/nonebot_plugin_ac_demo/apscheduler_demo.py)\n\n6. 事件订阅\n\n通过`service.on_set_permission`、`service.on_remove_permission`、`service.on_change_permission`方法可以订阅事件，具体如下表：\n\n| 装饰器                            | 事件类型                                  | 事件接收函数的参数                                 |\n|--------------------------------|---------------------------------------|-------------------------------------------|\n| `service.on_set_permission`    | 服务设置主体权限                              | service：服务<br>subject：主体<br>allow：是否为允许权限 |\n| `service.on_remove_permission` | 服务删除主体权限                              | service：服务<br>subject：主体                  |\n| `service.on_change_permission` | 服务变更主体权限（包括该服务及其所有祖先服务设置、删除权限导致的权限变更） | service：服务<br>subject：主体<br>allow：是否为允许权限 |\n\n**调用事件接收函数时通过具名参数传参，因此事件接收函数的参数必须严格遵循参数名。**\n\n事件订阅示例：[src/nonebot_plugin_ac_demo/event_demo.py](src/nonebot_plugin_ac_demo/event_demo.py)\n\n## 配置项\n\n### access_control_database_conn_url\n\n数据库连接URL，必须使用异步SQLAlchemy驱动器。\n\n默认值：`sqlite+aiosqlite:///access_control.db`\n\n### access_control_default_permission\n\n未设置权限时的默认行为\n\n可选值：`allow`, `deny`\n\n默认值：`allow`\n\n### access_control_auto_patch_enabled\n\n是否启用对未适配插件的权限控制\n\n默认值：`True`\n\n### access_control_auto_patch_ignore\n\n对指定的未适配插件将不启用权限控制\n\n默认值：`[]`\n\n## Q&A\n\n### **本插件与[nonebot_plugin_rauthman](https://github.com/Lancercmd/nonebot_plugin_rauthman)和[nonebot-plugin-manager](https://github.com/nonepkg/nonebot-plugin-manager)等其他权限管理插件有什么差别？**\n\n[nonebot_plugin_rauthman](https://github.com/Lancercmd/nonebot_plugin_rauthman)支持功能级别的细粒度权限控制，但是需要插件进行适配，对于未适配插件不起作用。[nonebot-plugin-manager](https://github.com/nonepkg/nonebot-plugin-manager)则实现了非侵入式的权限控制。\n\n本插件主要受这两个插件的启发，结合了这两个插件的优点。既支持非侵入式应用到原有插件，也支持对插件进行适配以获得更多feature。同时提供事件订阅机制，以便插件开发者更灵活处理权限。\n\n同时，上述两款插件均只支持OneBot V11协议，而本插件设计之初就考虑到了除OneBot V11以外的协议，具有更强的可扩展性。\n\n## 在线乞讨\n\n<details><summary>点击请我打两把maimai</summary>\n\n![](https://github.com/ssttkkl/ssttkkl/blob/main/afdian-ssttkkl.jfif)\n\n</details>\n\n## LICENSE\n\n> MIT License\n>\n> Copyright (c) 2022 ssttkkl\n>\n> Permission is hereby granted, free of charge, to any person obtaining a copy\n> of this software and associated documentation files (the "Software"), to deal\n> in the Software without restriction, including without limitation the rights\n> to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n> copies of the Software, and to permit persons to whom the Software is\n> furnished to do so, subject to the following conditions:\n>\n> The above copyright notice and this permission notice shall be included in all\n> copies or substantial portions of the Software.\n>\n> THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n> IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n> FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n> AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n> LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n> OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\n> SOFTWARE.\n> ',
    'author': 'ssttkkl',
    'author_email': 'huang.wen.long@hotmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/ssttkkl/nonebot-plugin-access-control',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
