# -*- coding: utf-8 -*-

"""
    my_countries_api_1234567

    This file was automatically generated by APIMATIC v2.0 ( https://apimatic.io ).
"""

import my_countries_api_1234567.models.country_info

class CountryResponse(object):

    """Implementation of the 'CountryResponse' model.

    Response of countries API will be stored in this model.

    Attributes:
        http_code (int): HTTP status code
        response_code (string): Response code of API
        response_msg (string): Response message of API
        data (list of CountryInfo): This is the list of countries object

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "http_code":'http_code',
        "response_code":'response_code',
        "response_msg":'response_msg',
        "data":'data'
    }

    def __init__(self,
                 http_code=None,
                 response_code=None,
                 response_msg=None,
                 data=None):
        """Constructor for the CountryResponse class"""

        # Initialize members of the class
        self.http_code = http_code
        self.response_code = response_code
        self.response_msg = response_msg
        self.data = data


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        http_code = dictionary.get('http_code')
        response_code = dictionary.get('response_code')
        response_msg = dictionary.get('response_msg')
        data = None
        if dictionary.get('data') != None:
            data = list()
            for structure in dictionary.get('data'):
                data.append(my_countries_api_1234567.models.country_info.CountryInfo.from_dictionary(structure))

        # Return an object of this model
        return cls(http_code,
                   response_code,
                   response_msg,
                   data)


