"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = exports.RuntimeFamily = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * All known Lambda runtime families.
 */
var RuntimeFamily;
(function (RuntimeFamily) {
    /**
     * All Lambda runtimes that depend on Node.js.
     */
    RuntimeFamily[RuntimeFamily["NODEJS"] = 0] = "NODEJS";
    /**
     * All lambda runtimes that depend on Python.
     */
    RuntimeFamily[RuntimeFamily["PYTHON"] = 1] = "PYTHON";
    /**
     * Any future runtime family.
     */
    RuntimeFamily[RuntimeFamily["OTHER"] = 2] = "OTHER";
})(RuntimeFamily = exports.RuntimeFamily || (exports.RuntimeFamily = {}));
/**
 * Runtime options for a canary
 */
class Runtime {
    /**
      * @param name The name of the runtime version
      * @param family The Lambda runtime family
      */
    constructor(name, family) {
        this.name = name;
        this.family = family;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_synthetics_alpha_RuntimeFamily(family);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Runtime);
            }
            throw error;
        }
    }
}
exports.Runtime = Runtime;
_a = JSII_RTTI_SYMBOL_1;
Runtime[_a] = { fqn: "@aws-cdk/aws-synthetics-alpha.Runtime", version: "2.63.0-alpha.0" };
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-1.0` includes the following:
 *
 * - Synthetics library 1.0
 * - Synthetics handler code 1.0
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 1.14.0
 * - The Chromium version that matches Puppeteer-core 1.14.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-1.0
 */
Runtime.SYNTHETICS_1_0 = new Runtime('syn-1.0', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-2.0` includes the following:
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 3.3.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.0
 */
Runtime.SYNTHETICS_NODEJS_2_0 = new Runtime('syn-nodejs-2.0', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-2.1` includes the following:
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 3.3.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.1
 */
Runtime.SYNTHETICS_NODEJS_2_1 = new Runtime('syn-nodejs-2.1', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-2.2` includes the following:
 * - Lambda runtime Node.js 10.x
 * - Puppeteer-core version 3.3.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.2
 */
Runtime.SYNTHETICS_NODEJS_2_2 = new Runtime('syn-nodejs-2.2', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-puppeteer-3.0` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.0
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_0 = new Runtime('syn-nodejs-puppeteer-3.0', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-puppeteer-3.1` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.1
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_1 = new Runtime('syn-nodejs-puppeteer-3.1', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-puppeteer-3.2` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.2
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_2 = new Runtime('syn-nodejs-puppeteer-3.2', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.3` includes the following:
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.3
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_3 = new Runtime('syn-nodejs-puppeteer-3.3', RuntimeFamily.NODEJS);
/**
 * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
 *
 * `syn-nodejs-puppeteer-3.4` includes the following:
 * - Lambda runtime Node.js 12.x
 * - Puppeteer-core version 5.5.0
 * - Chromium version 88.0.4298.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.4
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_4 = new Runtime('syn-nodejs-puppeteer-3.4', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.5` includes the following:
 * - Lambda runtime Node.js 14.x
 * - Puppeteer-core version 10.1.0
 * - Chromium version 92.0.4512
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.5
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_5 = new Runtime('syn-nodejs-puppeteer-3.5', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.6` includes the following:
 * - Lambda runtime Node.js 14.x
 * - Puppeteer-core version 10.1.0
 * - Chromium version 92.0.4512
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.6
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_6 = new Runtime('syn-nodejs-puppeteer-3.6', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.7` includes the following:
 * - Lambda runtime Node.js 14.x
 * - Puppeteer-core version 10.1.0
 * - Chromium version 92.0.4512
 *
 * New Features:
 * - **Logging enhancement**: The canary will upload logs to Amazon S3 even if it times out or crashes.
 * - **Lambda layer size reduced**: The size of the Lambda layer used for canaries is reduced by 34%.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.7
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_7 = new Runtime('syn-nodejs-puppeteer-3.7', RuntimeFamily.NODEJS);
/**
 * `syn-nodejs-puppeteer-3.8` includes the following:
 * - Lambda runtime Node.js 14.x
 * - Puppeteer-core version 10.1.0
 * - Chromium version 92.0.4512
 *
 * New Features:
 * - **Profile cleanup**: Chromium profiles are now cleaned up after each canary run.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.8
 */
Runtime.SYNTHETICS_NODEJS_PUPPETEER_3_8 = new Runtime('syn-nodejs-puppeteer-3.8', RuntimeFamily.NODEJS);
/**
 * `syn-python-selenium-1.0` includes the following:
 * - Lambda runtime Python 3.8
 * - Selenium version 3.141.0
 * - Chromium version 83.0.4103.0
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.0
 */
Runtime.SYNTHETICS_PYTHON_SELENIUM_1_0 = new Runtime('syn-python-selenium-1.0', RuntimeFamily.PYTHON);
/**
 * `syn-python-selenium-1.1` includes the following:
 * - Lambda runtime Python 3.8
 * - Selenium version 3.141.0
 * - Chromium version 83.0.4103.0
 *
 * New Features:
 * - **Custom handler function**: You can now use a custom handler function for your canary scripts.
 * - **Configuration options for adding metrics and step failure configurations**: These options were already available in runtimes for Node.js canaries.
 * - **Custom arguments in Chrome**: You can now open a browser in incognito mode or pass in proxy server configuration.
 * - **Cross-Region artifact buckets**: A canary can store its artifacts in an Amazon S3 bucket in a different Region.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.1
 */
Runtime.SYNTHETICS_PYTHON_SELENIUM_1_1 = new Runtime('syn-python-selenium-1.1', RuntimeFamily.PYTHON);
/**
 * `syn-python-selenium-1.2` includes the following:
 * - Lambda runtime Python 3.8
 * - Selenium version 3.141.0
 * - Chromium version 92.0.4512.0
 *
 * New Features:
 * - **Updated dependencies**: The only new features in this runtime are the updated dependencies.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.2
 */
Runtime.SYNTHETICS_PYTHON_SELENIUM_1_2 = new Runtime('syn-python-selenium-1.2', RuntimeFamily.PYTHON);
/**
 * `syn-python-selenium-1.3` includes the following:
 * - Lambda runtime Python 3.8
 * - Selenium version 3.141.0
 * - Chromium version 92.0.4512.0
 *
 * New Features:
 * - **More precise timestamps**: The start time and stop time of canary runs are now precise to the millisecond.
 *
 * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html#CloudWatch_Synthetics_runtimeversion-syn-python-selenium-1.3
 */
Runtime.SYNTHETICS_PYTHON_SELENIUM_1_3 = new Runtime('syn-python-selenium-1.3', RuntimeFamily.PYTHON);
//# sourceMappingURL=data:application/json;base64,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