import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
declare module "./function-base" {
    /**
     * @stability stable
     */
    interface IFunction {
        /**
         * Return the given named metric for this Lambda Return the given named metric for this Function.
         *
         * @stability stable
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * Metric for the number of throttled invocations of this Lambda How often this Lambda is throttled.
         *
         * Sum over 5 minutes
         *
         * @default sum over 5 minutes
         * @stability stable
         */
        metricThrottles(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * Metric for the number of invocations of this Lambda How often this Lambda is invoked.
         *
         * Sum over 5 minutes
         *
         * @default sum over 5 minutes
         * @stability stable
         */
        metricInvocations(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * How many invocations of this Lambda fail.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricErrors(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * Metric for the Duration of this Lambda How long execution of this Lambda takes.
         *
         * Average over 5 minutes
         *
         * @default average over 5 minutes
         * @stability stable
         */
        metricDuration(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
    /**
     * @stability stable
     */
    interface FunctionBase {
        /**
         * Return the given named metric for this Function.
         *
         * @stability stable
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * How often this Lambda is throttled.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricThrottles(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * How often this Lambda is invoked.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricInvocations(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * How many invocations of this Lambda fail.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricErrors(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * How long execution of this Lambda takes.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricDuration(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
