# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ResourcePolicyArgs', 'ResourcePolicy']

@pulumi.input_type
class ResourcePolicyArgs:
    def __init__(__self__, *,
                 policy_document: pulumi.Input[str],
                 bypass_policy_lockout_check: Optional[pulumi.Input[bool]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ResourcePolicy resource.
        :param pulumi.Input[str] policy_document: The resource policy document, which can be up to 5kb in size.
        :param pulumi.Input[bool] bypass_policy_lockout_check: A flag to indicate whether to bypass the resource policy lockout safety check
        :param pulumi.Input[str] policy_name: The name of the resource policy. Must be unique within a specific AWS account.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        if bypass_policy_lockout_check is not None:
            pulumi.set(__self__, "bypass_policy_lockout_check", bypass_policy_lockout_check)
        if policy_name is not None:
            pulumi.set(__self__, "policy_name", policy_name)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Input[str]:
        """
        The resource policy document, which can be up to 5kb in size.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter(name="bypassPolicyLockoutCheck")
    def bypass_policy_lockout_check(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag to indicate whether to bypass the resource policy lockout safety check
        """
        return pulumi.get(self, "bypass_policy_lockout_check")

    @bypass_policy_lockout_check.setter
    def bypass_policy_lockout_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bypass_policy_lockout_check", value)

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource policy. Must be unique within a specific AWS account.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_name", value)


class ResourcePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypass_policy_lockout_check: Optional[pulumi.Input[bool]] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This schema provides construct and validation rules for AWS-XRay Resource Policy resource parameters.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_resource_policy = aws_native.xray.ResourcePolicy("myResourcePolicy",
            bypass_policy_lockout_check=False,
            policy_document="{ \\"Version\\": \\"2012-10-17\\", \\"Statement\\": [ { \\"Sid\\": \\"SNSAccess\\", \\"Effect\\": \\"Allow\\", \\"Principal\\": { \\"Service\\": \\"sns.amazonaws.com\\" }, \\"Action\\": [ \\"xray:PutTraceSegments\\", \\"xray:GetSamplingRules\\", \\"xray:GetSamplingTargets\\" ], \\"Resource\\": \\"*\\", \\"Condition\\": { \\"StringEquals\\": { \\"aws:SourceAccount\\": \\"my-account-id\\" }, \\"StringLike\\": { \\"aws:SourceArn\\": \\"arn:$my-partition:sns:$my-region:$my-account-id:my-topic-name\\" } } } ] }",
            policy_name="MySnsActiveTracingPolicy")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_resource_policy = aws_native.xray.ResourcePolicy("myResourcePolicy",
            bypass_policy_lockout_check=False,
            policy_document="{ \\"Version\\": \\"2012-10-17\\", \\"Statement\\": [ { \\"Sid\\": \\"SNSAccess\\", \\"Effect\\": \\"Allow\\", \\"Principal\\": { \\"Service\\": \\"sns.amazonaws.com\\" }, \\"Action\\": [ \\"xray:PutTraceSegments\\", \\"xray:GetSamplingRules\\", \\"xray:GetSamplingTargets\\" ], \\"Resource\\": \\"*\\", \\"Condition\\": { \\"StringEquals\\": { \\"aws:SourceAccount\\": \\"my-account-id\\" }, \\"StringLike\\": { \\"aws:SourceArn\\": \\"arn:$my-partition:sns:$my-region:$my-account-id:my-topic-name\\" } } } ] }",
            policy_name="MySNSActiveTracingPolicy")

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] bypass_policy_lockout_check: A flag to indicate whether to bypass the resource policy lockout safety check
        :param pulumi.Input[str] policy_document: The resource policy document, which can be up to 5kb in size.
        :param pulumi.Input[str] policy_name: The name of the resource policy. Must be unique within a specific AWS account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourcePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This schema provides construct and validation rules for AWS-XRay Resource Policy resource parameters.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_resource_policy = aws_native.xray.ResourcePolicy("myResourcePolicy",
            bypass_policy_lockout_check=False,
            policy_document="{ \\"Version\\": \\"2012-10-17\\", \\"Statement\\": [ { \\"Sid\\": \\"SNSAccess\\", \\"Effect\\": \\"Allow\\", \\"Principal\\": { \\"Service\\": \\"sns.amazonaws.com\\" }, \\"Action\\": [ \\"xray:PutTraceSegments\\", \\"xray:GetSamplingRules\\", \\"xray:GetSamplingTargets\\" ], \\"Resource\\": \\"*\\", \\"Condition\\": { \\"StringEquals\\": { \\"aws:SourceAccount\\": \\"my-account-id\\" }, \\"StringLike\\": { \\"aws:SourceArn\\": \\"arn:$my-partition:sns:$my-region:$my-account-id:my-topic-name\\" } } } ] }",
            policy_name="MySnsActiveTracingPolicy")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_resource_policy = aws_native.xray.ResourcePolicy("myResourcePolicy",
            bypass_policy_lockout_check=False,
            policy_document="{ \\"Version\\": \\"2012-10-17\\", \\"Statement\\": [ { \\"Sid\\": \\"SNSAccess\\", \\"Effect\\": \\"Allow\\", \\"Principal\\": { \\"Service\\": \\"sns.amazonaws.com\\" }, \\"Action\\": [ \\"xray:PutTraceSegments\\", \\"xray:GetSamplingRules\\", \\"xray:GetSamplingTargets\\" ], \\"Resource\\": \\"*\\", \\"Condition\\": { \\"StringEquals\\": { \\"aws:SourceAccount\\": \\"my-account-id\\" }, \\"StringLike\\": { \\"aws:SourceArn\\": \\"arn:$my-partition:sns:$my-region:$my-account-id:my-topic-name\\" } } } ] }",
            policy_name="MySNSActiveTracingPolicy")

        ```

        :param str resource_name: The name of the resource.
        :param ResourcePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourcePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bypass_policy_lockout_check: Optional[pulumi.Input[bool]] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 policy_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourcePolicyArgs.__new__(ResourcePolicyArgs)

            __props__.__dict__["bypass_policy_lockout_check"] = bypass_policy_lockout_check
            if policy_document is None and not opts.urn:
                raise TypeError("Missing required property 'policy_document'")
            __props__.__dict__["policy_document"] = policy_document
            __props__.__dict__["policy_name"] = policy_name
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["policyName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ResourcePolicy, __self__).__init__(
            'aws-native:xray:ResourcePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ResourcePolicy':
        """
        Get an existing ResourcePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ResourcePolicyArgs.__new__(ResourcePolicyArgs)

        __props__.__dict__["bypass_policy_lockout_check"] = None
        __props__.__dict__["policy_document"] = None
        __props__.__dict__["policy_name"] = None
        return ResourcePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bypassPolicyLockoutCheck")
    def bypass_policy_lockout_check(self) -> pulumi.Output[Optional[bool]]:
        """
        A flag to indicate whether to bypass the resource policy lockout safety check
        """
        return pulumi.get(self, "bypass_policy_lockout_check")

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[str]:
        """
        The resource policy document, which can be up to 5kb in size.
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Output[str]:
        """
        The name of the resource policy. Must be unique within a specific AWS account.
        """
        return pulumi.get(self, "policy_name")

