# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['UserSettingsArgs', 'UserSettings']

@pulumi.input_type
class UserSettingsArgs:
    def __init__(__self__, *,
                 copy_allowed: pulumi.Input['UserSettingsEnabledType'],
                 download_allowed: pulumi.Input['UserSettingsEnabledType'],
                 paste_allowed: pulumi.Input['UserSettingsEnabledType'],
                 print_allowed: pulumi.Input['UserSettingsEnabledType'],
                 upload_allowed: pulumi.Input['UserSettingsEnabledType'],
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cookie_synchronization_configuration: Optional[pulumi.Input['UserSettingsCookieSynchronizationConfigurationArgs']] = None,
                 customer_managed_key: Optional[pulumi.Input[str]] = None,
                 deep_link_allowed: Optional[pulumi.Input['UserSettingsEnabledType']] = None,
                 disconnect_timeout_in_minutes: Optional[pulumi.Input[float]] = None,
                 idle_disconnect_timeout_in_minutes: Optional[pulumi.Input[float]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a UserSettings resource.
        :param pulumi.Input['UserSettingsEnabledType'] copy_allowed: Specifies whether the user can copy text from the streaming session to the local device.
        :param pulumi.Input['UserSettingsEnabledType'] download_allowed: Specifies whether the user can download files from the streaming session to the local device.
        :param pulumi.Input['UserSettingsEnabledType'] paste_allowed: Specifies whether the user can paste text from the local device to the streaming session.
        :param pulumi.Input['UserSettingsEnabledType'] print_allowed: Specifies whether the user can print to the local device.
        :param pulumi.Input['UserSettingsEnabledType'] upload_allowed: Specifies whether the user can upload files from the local device to the streaming session.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_encryption_context: The additional encryption context of the user settings.
        :param pulumi.Input['UserSettingsCookieSynchronizationConfigurationArgs'] cookie_synchronization_configuration: The configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser.
        :param pulumi.Input[str] customer_managed_key: The customer managed key used to encrypt sensitive information in the user settings.
        :param pulumi.Input['UserSettingsEnabledType'] deep_link_allowed: Specifies whether the user can use deep links that open automatically when connecting to a session.
        :param pulumi.Input[float] disconnect_timeout_in_minutes: The amount of time that a streaming session remains active after users disconnect.
        :param pulumi.Input[float] idle_disconnect_timeout_in_minutes: The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the disconnect timeout interval begins.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags to add to the user settings resource. A tag is a key-value pair.
        """
        pulumi.set(__self__, "copy_allowed", copy_allowed)
        pulumi.set(__self__, "download_allowed", download_allowed)
        pulumi.set(__self__, "paste_allowed", paste_allowed)
        pulumi.set(__self__, "print_allowed", print_allowed)
        pulumi.set(__self__, "upload_allowed", upload_allowed)
        if additional_encryption_context is not None:
            pulumi.set(__self__, "additional_encryption_context", additional_encryption_context)
        if cookie_synchronization_configuration is not None:
            pulumi.set(__self__, "cookie_synchronization_configuration", cookie_synchronization_configuration)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if deep_link_allowed is not None:
            pulumi.set(__self__, "deep_link_allowed", deep_link_allowed)
        if disconnect_timeout_in_minutes is not None:
            pulumi.set(__self__, "disconnect_timeout_in_minutes", disconnect_timeout_in_minutes)
        if idle_disconnect_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_disconnect_timeout_in_minutes", idle_disconnect_timeout_in_minutes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="copyAllowed")
    def copy_allowed(self) -> pulumi.Input['UserSettingsEnabledType']:
        """
        Specifies whether the user can copy text from the streaming session to the local device.
        """
        return pulumi.get(self, "copy_allowed")

    @copy_allowed.setter
    def copy_allowed(self, value: pulumi.Input['UserSettingsEnabledType']):
        pulumi.set(self, "copy_allowed", value)

    @property
    @pulumi.getter(name="downloadAllowed")
    def download_allowed(self) -> pulumi.Input['UserSettingsEnabledType']:
        """
        Specifies whether the user can download files from the streaming session to the local device.
        """
        return pulumi.get(self, "download_allowed")

    @download_allowed.setter
    def download_allowed(self, value: pulumi.Input['UserSettingsEnabledType']):
        pulumi.set(self, "download_allowed", value)

    @property
    @pulumi.getter(name="pasteAllowed")
    def paste_allowed(self) -> pulumi.Input['UserSettingsEnabledType']:
        """
        Specifies whether the user can paste text from the local device to the streaming session.
        """
        return pulumi.get(self, "paste_allowed")

    @paste_allowed.setter
    def paste_allowed(self, value: pulumi.Input['UserSettingsEnabledType']):
        pulumi.set(self, "paste_allowed", value)

    @property
    @pulumi.getter(name="printAllowed")
    def print_allowed(self) -> pulumi.Input['UserSettingsEnabledType']:
        """
        Specifies whether the user can print to the local device.
        """
        return pulumi.get(self, "print_allowed")

    @print_allowed.setter
    def print_allowed(self, value: pulumi.Input['UserSettingsEnabledType']):
        pulumi.set(self, "print_allowed", value)

    @property
    @pulumi.getter(name="uploadAllowed")
    def upload_allowed(self) -> pulumi.Input['UserSettingsEnabledType']:
        """
        Specifies whether the user can upload files from the local device to the streaming session.
        """
        return pulumi.get(self, "upload_allowed")

    @upload_allowed.setter
    def upload_allowed(self, value: pulumi.Input['UserSettingsEnabledType']):
        pulumi.set(self, "upload_allowed", value)

    @property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The additional encryption context of the user settings.
        """
        return pulumi.get(self, "additional_encryption_context")

    @additional_encryption_context.setter
    def additional_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "additional_encryption_context", value)

    @property
    @pulumi.getter(name="cookieSynchronizationConfiguration")
    def cookie_synchronization_configuration(self) -> Optional[pulumi.Input['UserSettingsCookieSynchronizationConfigurationArgs']]:
        """
        The configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser.
        """
        return pulumi.get(self, "cookie_synchronization_configuration")

    @cookie_synchronization_configuration.setter
    def cookie_synchronization_configuration(self, value: Optional[pulumi.Input['UserSettingsCookieSynchronizationConfigurationArgs']]):
        pulumi.set(self, "cookie_synchronization_configuration", value)

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input[str]]:
        """
        The customer managed key used to encrypt sensitive information in the user settings.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_managed_key", value)

    @property
    @pulumi.getter(name="deepLinkAllowed")
    def deep_link_allowed(self) -> Optional[pulumi.Input['UserSettingsEnabledType']]:
        """
        Specifies whether the user can use deep links that open automatically when connecting to a session.
        """
        return pulumi.get(self, "deep_link_allowed")

    @deep_link_allowed.setter
    def deep_link_allowed(self, value: Optional[pulumi.Input['UserSettingsEnabledType']]):
        pulumi.set(self, "deep_link_allowed", value)

    @property
    @pulumi.getter(name="disconnectTimeoutInMinutes")
    def disconnect_timeout_in_minutes(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of time that a streaming session remains active after users disconnect.
        """
        return pulumi.get(self, "disconnect_timeout_in_minutes")

    @disconnect_timeout_in_minutes.setter
    def disconnect_timeout_in_minutes(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "disconnect_timeout_in_minutes", value)

    @property
    @pulumi.getter(name="idleDisconnectTimeoutInMinutes")
    def idle_disconnect_timeout_in_minutes(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the disconnect timeout interval begins.
        """
        return pulumi.get(self, "idle_disconnect_timeout_in_minutes")

    @idle_disconnect_timeout_in_minutes.setter
    def idle_disconnect_timeout_in_minutes(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "idle_disconnect_timeout_in_minutes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags to add to the user settings resource. A tag is a key-value pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class UserSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cookie_synchronization_configuration: Optional[pulumi.Input[Union['UserSettingsCookieSynchronizationConfigurationArgs', 'UserSettingsCookieSynchronizationConfigurationArgsDict']]] = None,
                 copy_allowed: Optional[pulumi.Input['UserSettingsEnabledType']] = None,
                 customer_managed_key: Optional[pulumi.Input[str]] = None,
                 deep_link_allowed: Optional[pulumi.Input['UserSettingsEnabledType']] = None,
                 disconnect_timeout_in_minutes: Optional[pulumi.Input[float]] = None,
                 download_allowed: Optional[pulumi.Input['UserSettingsEnabledType']] = None,
                 idle_disconnect_timeout_in_minutes: Optional[pulumi.Input[float]] = None,
                 paste_allowed: Optional[pulumi.Input['UserSettingsEnabledType']] = None,
                 print_allowed: Optional[pulumi.Input['UserSettingsEnabledType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 upload_allowed: Optional[pulumi.Input['UserSettingsEnabledType']] = None,
                 __props__=None):
        """
        Definition of AWS::WorkSpacesWeb::UserSettings Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_encryption_context: The additional encryption context of the user settings.
        :param pulumi.Input[Union['UserSettingsCookieSynchronizationConfigurationArgs', 'UserSettingsCookieSynchronizationConfigurationArgsDict']] cookie_synchronization_configuration: The configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser.
        :param pulumi.Input['UserSettingsEnabledType'] copy_allowed: Specifies whether the user can copy text from the streaming session to the local device.
        :param pulumi.Input[str] customer_managed_key: The customer managed key used to encrypt sensitive information in the user settings.
        :param pulumi.Input['UserSettingsEnabledType'] deep_link_allowed: Specifies whether the user can use deep links that open automatically when connecting to a session.
        :param pulumi.Input[float] disconnect_timeout_in_minutes: The amount of time that a streaming session remains active after users disconnect.
        :param pulumi.Input['UserSettingsEnabledType'] download_allowed: Specifies whether the user can download files from the streaming session to the local device.
        :param pulumi.Input[float] idle_disconnect_timeout_in_minutes: The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the disconnect timeout interval begins.
        :param pulumi.Input['UserSettingsEnabledType'] paste_allowed: Specifies whether the user can paste text from the local device to the streaming session.
        :param pulumi.Input['UserSettingsEnabledType'] print_allowed: Specifies whether the user can print to the local device.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags to add to the user settings resource. A tag is a key-value pair.
        :param pulumi.Input['UserSettingsEnabledType'] upload_allowed: Specifies whether the user can upload files from the local device to the streaming session.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::WorkSpacesWeb::UserSettings Resource Type

        :param str resource_name: The name of the resource.
        :param UserSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 cookie_synchronization_configuration: Optional[pulumi.Input[Union['UserSettingsCookieSynchronizationConfigurationArgs', 'UserSettingsCookieSynchronizationConfigurationArgsDict']]] = None,
                 copy_allowed: Optional[pulumi.Input['UserSettingsEnabledType']] = None,
                 customer_managed_key: Optional[pulumi.Input[str]] = None,
                 deep_link_allowed: Optional[pulumi.Input['UserSettingsEnabledType']] = None,
                 disconnect_timeout_in_minutes: Optional[pulumi.Input[float]] = None,
                 download_allowed: Optional[pulumi.Input['UserSettingsEnabledType']] = None,
                 idle_disconnect_timeout_in_minutes: Optional[pulumi.Input[float]] = None,
                 paste_allowed: Optional[pulumi.Input['UserSettingsEnabledType']] = None,
                 print_allowed: Optional[pulumi.Input['UserSettingsEnabledType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 upload_allowed: Optional[pulumi.Input['UserSettingsEnabledType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserSettingsArgs.__new__(UserSettingsArgs)

            __props__.__dict__["additional_encryption_context"] = additional_encryption_context
            __props__.__dict__["cookie_synchronization_configuration"] = cookie_synchronization_configuration
            if copy_allowed is None and not opts.urn:
                raise TypeError("Missing required property 'copy_allowed'")
            __props__.__dict__["copy_allowed"] = copy_allowed
            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["deep_link_allowed"] = deep_link_allowed
            __props__.__dict__["disconnect_timeout_in_minutes"] = disconnect_timeout_in_minutes
            if download_allowed is None and not opts.urn:
                raise TypeError("Missing required property 'download_allowed'")
            __props__.__dict__["download_allowed"] = download_allowed
            __props__.__dict__["idle_disconnect_timeout_in_minutes"] = idle_disconnect_timeout_in_minutes
            if paste_allowed is None and not opts.urn:
                raise TypeError("Missing required property 'paste_allowed'")
            __props__.__dict__["paste_allowed"] = paste_allowed
            if print_allowed is None and not opts.urn:
                raise TypeError("Missing required property 'print_allowed'")
            __props__.__dict__["print_allowed"] = print_allowed
            __props__.__dict__["tags"] = tags
            if upload_allowed is None and not opts.urn:
                raise TypeError("Missing required property 'upload_allowed'")
            __props__.__dict__["upload_allowed"] = upload_allowed
            __props__.__dict__["associated_portal_arns"] = None
            __props__.__dict__["user_settings_arn"] = None
        super(UserSettings, __self__).__init__(
            'aws-native:workspacesweb:UserSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'UserSettings':
        """
        Get an existing UserSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = UserSettingsArgs.__new__(UserSettingsArgs)

        __props__.__dict__["additional_encryption_context"] = None
        __props__.__dict__["associated_portal_arns"] = None
        __props__.__dict__["cookie_synchronization_configuration"] = None
        __props__.__dict__["copy_allowed"] = None
        __props__.__dict__["customer_managed_key"] = None
        __props__.__dict__["deep_link_allowed"] = None
        __props__.__dict__["disconnect_timeout_in_minutes"] = None
        __props__.__dict__["download_allowed"] = None
        __props__.__dict__["idle_disconnect_timeout_in_minutes"] = None
        __props__.__dict__["paste_allowed"] = None
        __props__.__dict__["print_allowed"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["upload_allowed"] = None
        __props__.__dict__["user_settings_arn"] = None
        return UserSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The additional encryption context of the user settings.
        """
        return pulumi.get(self, "additional_encryption_context")

    @property
    @pulumi.getter(name="associatedPortalArns")
    def associated_portal_arns(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of web portal ARNs that this user settings resource is associated with.
        """
        return pulumi.get(self, "associated_portal_arns")

    @property
    @pulumi.getter(name="cookieSynchronizationConfiguration")
    def cookie_synchronization_configuration(self) -> pulumi.Output[Optional['outputs.UserSettingsCookieSynchronizationConfiguration']]:
        """
        The configuration that specifies which cookies should be synchronized from the end user's local browser to the remote browser.
        """
        return pulumi.get(self, "cookie_synchronization_configuration")

    @property
    @pulumi.getter(name="copyAllowed")
    def copy_allowed(self) -> pulumi.Output['UserSettingsEnabledType']:
        """
        Specifies whether the user can copy text from the streaming session to the local device.
        """
        return pulumi.get(self, "copy_allowed")

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional[str]]:
        """
        The customer managed key used to encrypt sensitive information in the user settings.
        """
        return pulumi.get(self, "customer_managed_key")

    @property
    @pulumi.getter(name="deepLinkAllowed")
    def deep_link_allowed(self) -> pulumi.Output[Optional['UserSettingsEnabledType']]:
        """
        Specifies whether the user can use deep links that open automatically when connecting to a session.
        """
        return pulumi.get(self, "deep_link_allowed")

    @property
    @pulumi.getter(name="disconnectTimeoutInMinutes")
    def disconnect_timeout_in_minutes(self) -> pulumi.Output[Optional[float]]:
        """
        The amount of time that a streaming session remains active after users disconnect.
        """
        return pulumi.get(self, "disconnect_timeout_in_minutes")

    @property
    @pulumi.getter(name="downloadAllowed")
    def download_allowed(self) -> pulumi.Output['UserSettingsEnabledType']:
        """
        Specifies whether the user can download files from the streaming session to the local device.
        """
        return pulumi.get(self, "download_allowed")

    @property
    @pulumi.getter(name="idleDisconnectTimeoutInMinutes")
    def idle_disconnect_timeout_in_minutes(self) -> pulumi.Output[Optional[float]]:
        """
        The amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the disconnect timeout interval begins.
        """
        return pulumi.get(self, "idle_disconnect_timeout_in_minutes")

    @property
    @pulumi.getter(name="pasteAllowed")
    def paste_allowed(self) -> pulumi.Output['UserSettingsEnabledType']:
        """
        Specifies whether the user can paste text from the local device to the streaming session.
        """
        return pulumi.get(self, "paste_allowed")

    @property
    @pulumi.getter(name="printAllowed")
    def print_allowed(self) -> pulumi.Output['UserSettingsEnabledType']:
        """
        Specifies whether the user can print to the local device.
        """
        return pulumi.get(self, "print_allowed")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags to add to the user settings resource. A tag is a key-value pair.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="uploadAllowed")
    def upload_allowed(self) -> pulumi.Output['UserSettingsEnabledType']:
        """
        Specifies whether the user can upload files from the local device to the streaming session.
        """
        return pulumi.get(self, "upload_allowed")

    @property
    @pulumi.getter(name="userSettingsArn")
    def user_settings_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the user settings.
        """
        return pulumi.get(self, "user_settings_arn")

