# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'IpAccessSettingsIpRule',
    'UserSettingsCookieSpecification',
    'UserSettingsCookieSynchronizationConfiguration',
]

@pulumi.output_type
class IpAccessSettingsIpRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpAccessSettingsIpRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpAccessSettingsIpRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpAccessSettingsIpRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_range: str,
                 description: Optional[str] = None):
        """
        :param str ip_range: A single IP address or an IP address range in CIDR notation
        :param str description: The description of the IP rule.
        """
        pulumi.set(__self__, "ip_range", ip_range)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> str:
        """
        A single IP address or an IP address range in CIDR notation
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the IP rule.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class UserSettingsCookieSpecification(dict):
    def __init__(__self__, *,
                 domain: str,
                 name: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str domain: The domain of the cookie.
        :param str name: The name of the cookie.
        :param str path: The path of the cookie.
        """
        pulumi.set(__self__, "domain", domain)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain of the cookie.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the cookie.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path of the cookie.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class UserSettingsCookieSynchronizationConfiguration(dict):
    def __init__(__self__, *,
                 allowlist: Sequence['outputs.UserSettingsCookieSpecification'],
                 blocklist: Optional[Sequence['outputs.UserSettingsCookieSpecification']] = None):
        """
        :param Sequence['UserSettingsCookieSpecification'] allowlist: The list of cookie specifications that are allowed to be synchronized to the remote browser.
        :param Sequence['UserSettingsCookieSpecification'] blocklist: The list of cookie specifications that are blocked from being synchronized to the remote browser.
        """
        pulumi.set(__self__, "allowlist", allowlist)
        if blocklist is not None:
            pulumi.set(__self__, "blocklist", blocklist)

    @property
    @pulumi.getter
    def allowlist(self) -> Sequence['outputs.UserSettingsCookieSpecification']:
        """
        The list of cookie specifications that are allowed to be synchronized to the remote browser.
        """
        return pulumi.get(self, "allowlist")

    @property
    @pulumi.getter
    def blocklist(self) -> Optional[Sequence['outputs.UserSettingsCookieSpecification']]:
        """
        The list of cookie specifications that are blocked from being synchronized to the remote browser.
        """
        return pulumi.get(self, "blocklist")


