# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'IpAccessSettingsIpRuleArgs',
    'IpAccessSettingsIpRuleArgsDict',
    'UserSettingsCookieSpecificationArgs',
    'UserSettingsCookieSpecificationArgsDict',
    'UserSettingsCookieSynchronizationConfigurationArgs',
    'UserSettingsCookieSynchronizationConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class IpAccessSettingsIpRuleArgsDict(TypedDict):
        ip_range: pulumi.Input[str]
        """
        A single IP address or an IP address range in CIDR notation
        """
        description: NotRequired[pulumi.Input[str]]
        """
        The description of the IP rule.
        """
elif False:
    IpAccessSettingsIpRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IpAccessSettingsIpRuleArgs:
    def __init__(__self__, *,
                 ip_range: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_range: A single IP address or an IP address range in CIDR notation
        :param pulumi.Input[str] description: The description of the IP rule.
        """
        pulumi.set(__self__, "ip_range", ip_range)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> pulumi.Input[str]:
        """
        A single IP address or an IP address range in CIDR notation
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the IP rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class UserSettingsCookieSpecificationArgsDict(TypedDict):
        domain: pulumi.Input[str]
        """
        The domain of the cookie.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the cookie.
        """
        path: NotRequired[pulumi.Input[str]]
        """
        The path of the cookie.
        """
elif False:
    UserSettingsCookieSpecificationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserSettingsCookieSpecificationArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] domain: The domain of the cookie.
        :param pulumi.Input[str] name: The name of the cookie.
        :param pulumi.Input[str] path: The path of the cookie.
        """
        pulumi.set(__self__, "domain", domain)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        The domain of the cookie.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cookie.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the cookie.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


if not MYPY:
    class UserSettingsCookieSynchronizationConfigurationArgsDict(TypedDict):
        allowlist: pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgsDict']]]
        """
        The list of cookie specifications that are allowed to be synchronized to the remote browser.
        """
        blocklist: NotRequired[pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgsDict']]]]
        """
        The list of cookie specifications that are blocked from being synchronized to the remote browser.
        """
elif False:
    UserSettingsCookieSynchronizationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserSettingsCookieSynchronizationConfigurationArgs:
    def __init__(__self__, *,
                 allowlist: pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]],
                 blocklist: Optional[pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]] allowlist: The list of cookie specifications that are allowed to be synchronized to the remote browser.
        :param pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]] blocklist: The list of cookie specifications that are blocked from being synchronized to the remote browser.
        """
        pulumi.set(__self__, "allowlist", allowlist)
        if blocklist is not None:
            pulumi.set(__self__, "blocklist", blocklist)

    @property
    @pulumi.getter
    def allowlist(self) -> pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]]:
        """
        The list of cookie specifications that are allowed to be synchronized to the remote browser.
        """
        return pulumi.get(self, "allowlist")

    @allowlist.setter
    def allowlist(self, value: pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]]):
        pulumi.set(self, "allowlist", value)

    @property
    @pulumi.getter
    def blocklist(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]]]:
        """
        The list of cookie specifications that are blocked from being synchronized to the remote browser.
        """
        return pulumi.get(self, "blocklist")

    @blocklist.setter
    def blocklist(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]]]):
        pulumi.set(self, "blocklist", value)


