# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['WorkspacesPoolArgs', 'WorkspacesPool']

@pulumi.input_type
class WorkspacesPoolArgs:
    def __init__(__self__, *,
                 bundle_id: pulumi.Input[str],
                 capacity: pulumi.Input['WorkspacesPoolCapacityArgs'],
                 directory_id: pulumi.Input[str],
                 application_settings: Optional[pulumi.Input['WorkspacesPoolApplicationSettingsArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 pool_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 timeout_settings: Optional[pulumi.Input['WorkspacesPoolTimeoutSettingsArgs']] = None):
        """
        The set of arguments for constructing a WorkspacesPool resource.
        :param pulumi.Input[str] bundle_id: The identifier of the bundle used by the pool.
        :param pulumi.Input['WorkspacesPoolCapacityArgs'] capacity: Describes the user capacity for the pool.
        :param pulumi.Input[str] directory_id: The identifier of the directory used by the pool.
        :param pulumi.Input['WorkspacesPoolApplicationSettingsArgs'] application_settings: The persistent application settings for users of the pool.
        :param pulumi.Input[str] description: The description of the pool.
        :param pulumi.Input[str] pool_name: The name of the pool.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags for the pool.
        :param pulumi.Input['WorkspacesPoolTimeoutSettingsArgs'] timeout_settings: The amount of time that a pool session remains active after users disconnect. If they try to reconnect to the pool session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new pool instance.
        """
        pulumi.set(__self__, "bundle_id", bundle_id)
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "directory_id", directory_id)
        if application_settings is not None:
            pulumi.set(__self__, "application_settings", application_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if pool_name is not None:
            pulumi.set(__self__, "pool_name", pool_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout_settings is not None:
            pulumi.set(__self__, "timeout_settings", timeout_settings)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Input[str]:
        """
        The identifier of the bundle used by the pool.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bundle_id", value)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input['WorkspacesPoolCapacityArgs']:
        """
        Describes the user capacity for the pool.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input['WorkspacesPoolCapacityArgs']):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Input[str]:
        """
        The identifier of the directory used by the pool.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "directory_id", value)

    @property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> Optional[pulumi.Input['WorkspacesPoolApplicationSettingsArgs']]:
        """
        The persistent application settings for users of the pool.
        """
        return pulumi.get(self, "application_settings")

    @application_settings.setter
    def application_settings(self, value: Optional[pulumi.Input['WorkspacesPoolApplicationSettingsArgs']]):
        pulumi.set(self, "application_settings", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the pool.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the pool.
        """
        return pulumi.get(self, "pool_name")

    @pool_name.setter
    def pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pool_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags for the pool.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="timeoutSettings")
    def timeout_settings(self) -> Optional[pulumi.Input['WorkspacesPoolTimeoutSettingsArgs']]:
        """
        The amount of time that a pool session remains active after users disconnect. If they try to reconnect to the pool session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new pool instance.
        """
        return pulumi.get(self, "timeout_settings")

    @timeout_settings.setter
    def timeout_settings(self, value: Optional[pulumi.Input['WorkspacesPoolTimeoutSettingsArgs']]):
        pulumi.set(self, "timeout_settings", value)


class WorkspacesPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_settings: Optional[pulumi.Input[Union['WorkspacesPoolApplicationSettingsArgs', 'WorkspacesPoolApplicationSettingsArgsDict']]] = None,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 capacity: Optional[pulumi.Input[Union['WorkspacesPoolCapacityArgs', 'WorkspacesPoolCapacityArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 directory_id: Optional[pulumi.Input[str]] = None,
                 pool_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 timeout_settings: Optional[pulumi.Input[Union['WorkspacesPoolTimeoutSettingsArgs', 'WorkspacesPoolTimeoutSettingsArgsDict']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::WorkSpaces::WorkspacesPool

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WorkspacesPoolApplicationSettingsArgs', 'WorkspacesPoolApplicationSettingsArgsDict']] application_settings: The persistent application settings for users of the pool.
        :param pulumi.Input[str] bundle_id: The identifier of the bundle used by the pool.
        :param pulumi.Input[Union['WorkspacesPoolCapacityArgs', 'WorkspacesPoolCapacityArgsDict']] capacity: Describes the user capacity for the pool.
        :param pulumi.Input[str] description: The description of the pool.
        :param pulumi.Input[str] directory_id: The identifier of the directory used by the pool.
        :param pulumi.Input[str] pool_name: The name of the pool.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags for the pool.
        :param pulumi.Input[Union['WorkspacesPoolTimeoutSettingsArgs', 'WorkspacesPoolTimeoutSettingsArgsDict']] timeout_settings: The amount of time that a pool session remains active after users disconnect. If they try to reconnect to the pool session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new pool instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspacesPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::WorkSpaces::WorkspacesPool

        :param str resource_name: The name of the resource.
        :param WorkspacesPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspacesPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_settings: Optional[pulumi.Input[Union['WorkspacesPoolApplicationSettingsArgs', 'WorkspacesPoolApplicationSettingsArgsDict']]] = None,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 capacity: Optional[pulumi.Input[Union['WorkspacesPoolCapacityArgs', 'WorkspacesPoolCapacityArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 directory_id: Optional[pulumi.Input[str]] = None,
                 pool_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 timeout_settings: Optional[pulumi.Input[Union['WorkspacesPoolTimeoutSettingsArgs', 'WorkspacesPoolTimeoutSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspacesPoolArgs.__new__(WorkspacesPoolArgs)

            __props__.__dict__["application_settings"] = application_settings
            if bundle_id is None and not opts.urn:
                raise TypeError("Missing required property 'bundle_id'")
            __props__.__dict__["bundle_id"] = bundle_id
            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["description"] = description
            if directory_id is None and not opts.urn:
                raise TypeError("Missing required property 'directory_id'")
            __props__.__dict__["directory_id"] = directory_id
            __props__.__dict__["pool_name"] = pool_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeout_settings"] = timeout_settings
            __props__.__dict__["created_at"] = None
            __props__.__dict__["pool_arn"] = None
            __props__.__dict__["pool_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["poolName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(WorkspacesPool, __self__).__init__(
            'aws-native:workspaces:WorkspacesPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'WorkspacesPool':
        """
        Get an existing WorkspacesPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = WorkspacesPoolArgs.__new__(WorkspacesPoolArgs)

        __props__.__dict__["application_settings"] = None
        __props__.__dict__["bundle_id"] = None
        __props__.__dict__["capacity"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["directory_id"] = None
        __props__.__dict__["pool_arn"] = None
        __props__.__dict__["pool_id"] = None
        __props__.__dict__["pool_name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["timeout_settings"] = None
        return WorkspacesPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> pulumi.Output[Optional['outputs.WorkspacesPoolApplicationSettings']]:
        """
        The persistent application settings for users of the pool.
        """
        return pulumi.get(self, "application_settings")

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Output[str]:
        """
        The identifier of the bundle used by the pool.
        """
        return pulumi.get(self, "bundle_id")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output['outputs.WorkspacesPoolCapacity']:
        """
        Describes the user capacity for the pool.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The time the pool was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the pool.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[str]:
        """
        The identifier of the directory used by the pool.
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter(name="poolArn")
    def pool_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) for the pool.
        """
        return pulumi.get(self, "pool_arn")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Output[str]:
        """
        The identifier of the pool.
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> pulumi.Output[str]:
        """
        The name of the pool.
        """
        return pulumi.get(self, "pool_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags for the pool.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeoutSettings")
    def timeout_settings(self) -> pulumi.Output[Optional['outputs.WorkspacesPoolTimeoutSettings']]:
        """
        The amount of time that a pool session remains active after users disconnect. If they try to reconnect to the pool session after a disconnection or network interruption within this time interval, they are connected to their previous session. Otherwise, they are connected to a new session with a new pool instance.
        """
        return pulumi.get(self, "timeout_settings")

