# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['AssistantAssociationArgs', 'AssistantAssociation']

@pulumi.input_type
class AssistantAssociationArgs:
    def __init__(__self__, *,
                 assistant_id: pulumi.Input[str],
                 association: pulumi.Input['AssistantAssociationAssociationDataArgs'],
                 association_type: pulumi.Input['AssistantAssociationAssociationType'],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]] = None):
        """
        The set of arguments for constructing a AssistantAssociation resource.
        :param pulumi.Input[str] assistant_id: The identifier of the Wisdom assistant.
        :param pulumi.Input['AssistantAssociationAssociationDataArgs'] association: The identifier of the associated resource.
        :param pulumi.Input['AssistantAssociationAssociationType'] association_type: The type of association.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]] tags: The tags used to organize, track, or control access for this resource.
        """
        pulumi.set(__self__, "assistant_id", assistant_id)
        pulumi.set(__self__, "association", association)
        pulumi.set(__self__, "association_type", association_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="assistantId")
    def assistant_id(self) -> pulumi.Input[str]:
        """
        The identifier of the Wisdom assistant.
        """
        return pulumi.get(self, "assistant_id")

    @assistant_id.setter
    def assistant_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "assistant_id", value)

    @property
    @pulumi.getter
    def association(self) -> pulumi.Input['AssistantAssociationAssociationDataArgs']:
        """
        The identifier of the associated resource.
        """
        return pulumi.get(self, "association")

    @association.setter
    def association(self, value: pulumi.Input['AssistantAssociationAssociationDataArgs']):
        pulumi.set(self, "association", value)

    @property
    @pulumi.getter(name="associationType")
    def association_type(self) -> pulumi.Input['AssistantAssociationAssociationType']:
        """
        The type of association.
        """
        return pulumi.get(self, "association_type")

    @association_type.setter
    def association_type(self, value: pulumi.Input['AssistantAssociationAssociationType']):
        pulumi.set(self, "association_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]):
        pulumi.set(self, "tags", value)


class AssistantAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assistant_id: Optional[pulumi.Input[str]] = None,
                 association: Optional[pulumi.Input[Union['AssistantAssociationAssociationDataArgs', 'AssistantAssociationAssociationDataArgsDict']]] = None,
                 association_type: Optional[pulumi.Input['AssistantAssociationAssociationType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::Wisdom::AssistantAssociation Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] assistant_id: The identifier of the Wisdom assistant.
        :param pulumi.Input[Union['AssistantAssociationAssociationDataArgs', 'AssistantAssociationAssociationDataArgsDict']] association: The identifier of the associated resource.
        :param pulumi.Input['AssistantAssociationAssociationType'] association_type: The type of association.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]] tags: The tags used to organize, track, or control access for this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssistantAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Wisdom::AssistantAssociation Resource Type

        :param str resource_name: The name of the resource.
        :param AssistantAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssistantAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assistant_id: Optional[pulumi.Input[str]] = None,
                 association: Optional[pulumi.Input[Union['AssistantAssociationAssociationDataArgs', 'AssistantAssociationAssociationDataArgsDict']]] = None,
                 association_type: Optional[pulumi.Input['AssistantAssociationAssociationType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssistantAssociationArgs.__new__(AssistantAssociationArgs)

            if assistant_id is None and not opts.urn:
                raise TypeError("Missing required property 'assistant_id'")
            __props__.__dict__["assistant_id"] = assistant_id
            if association is None and not opts.urn:
                raise TypeError("Missing required property 'association'")
            __props__.__dict__["association"] = association
            if association_type is None and not opts.urn:
                raise TypeError("Missing required property 'association_type'")
            __props__.__dict__["association_type"] = association_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["assistant_arn"] = None
            __props__.__dict__["assistant_association_arn"] = None
            __props__.__dict__["assistant_association_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["assistantId", "association", "associationType", "tags[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AssistantAssociation, __self__).__init__(
            'aws-native:wisdom:AssistantAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AssistantAssociation':
        """
        Get an existing AssistantAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AssistantAssociationArgs.__new__(AssistantAssociationArgs)

        __props__.__dict__["assistant_arn"] = None
        __props__.__dict__["assistant_association_arn"] = None
        __props__.__dict__["assistant_association_id"] = None
        __props__.__dict__["assistant_id"] = None
        __props__.__dict__["association"] = None
        __props__.__dict__["association_type"] = None
        __props__.__dict__["tags"] = None
        return AssistantAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="assistantArn")
    def assistant_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the Wisdom assistant.
        """
        return pulumi.get(self, "assistant_arn")

    @property
    @pulumi.getter(name="assistantAssociationArn")
    def assistant_association_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the assistant association.
        """
        return pulumi.get(self, "assistant_association_arn")

    @property
    @pulumi.getter(name="assistantAssociationId")
    def assistant_association_id(self) -> pulumi.Output[str]:
        """
        The ID of the association.
        """
        return pulumi.get(self, "assistant_association_id")

    @property
    @pulumi.getter(name="assistantId")
    def assistant_id(self) -> pulumi.Output[str]:
        """
        The identifier of the Wisdom assistant.
        """
        return pulumi.get(self, "assistant_id")

    @property
    @pulumi.getter
    def association(self) -> pulumi.Output['outputs.AssistantAssociationAssociationData']:
        """
        The identifier of the associated resource.
        """
        return pulumi.get(self, "association")

    @property
    @pulumi.getter(name="associationType")
    def association_type(self) -> pulumi.Output['AssistantAssociationAssociationType']:
        """
        The type of association.
        """
        return pulumi.get(self, "association_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.CreateOnlyTag']]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

