# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetIpSetResult',
    'AwaitableGetIpSetResult',
    'get_ip_set',
    'get_ip_set_output',
]

@pulumi.output_type
class GetIpSetResult:
    def __init__(__self__, addresses=None, arn=None, description=None, id=None, ip_address_version=None, tags=None):
        if addresses and not isinstance(addresses, list):
            raise TypeError("Expected argument 'addresses' to be a list")
        pulumi.set(__self__, "addresses", addresses)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address_version and not isinstance(ip_address_version, str):
            raise TypeError("Expected argument 'ip_address_version' to be a str")
        pulumi.set(__self__, "ip_address_version", ip_address_version)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[Sequence[str]]:
        """
        List of IPAddresses.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the IP set.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description of the IP set that helps with identification.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the IP set.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddressVersion")
    def ip_address_version(self) -> Optional['IpSetIpAddressVersion']:
        """
        The version of the IP addresses, either `IPV4` or `IPV6` .
        """
        return pulumi.get(self, "ip_address_version")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.

        > To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
        """
        return pulumi.get(self, "tags")


class AwaitableGetIpSetResult(GetIpSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpSetResult(
            addresses=self.addresses,
            arn=self.arn,
            description=self.description,
            id=self.id,
            ip_address_version=self.ip_address_version,
            tags=self.tags)


def get_ip_set(id: Optional[str] = None,
               name: Optional[str] = None,
               scope: Optional['IpSetScope'] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpSetResult:
    """
    Contains a list of IP addresses. This can be either IPV4 or IPV6. The list will be mutually


    :param str id: The ID of the IP set.
    :param str name: The name of the IP set. You cannot change the name of an `IPSet` after you create it.
    :param 'IpSetScope' scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are `CLOUDFRONT` and `REGIONAL` .
           
           > For `CLOUDFRONT` , you must create your WAFv2 resources in the US East (N. Virginia) Region, `us-east-1` .
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:wafv2:getIpSet', __args__, opts=opts, typ=GetIpSetResult).value

    return AwaitableGetIpSetResult(
        addresses=pulumi.get(__ret__, 'addresses'),
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        ip_address_version=pulumi.get(__ret__, 'ip_address_version'),
        tags=pulumi.get(__ret__, 'tags'))
def get_ip_set_output(id: Optional[pulumi.Input[str]] = None,
                      name: Optional[pulumi.Input[str]] = None,
                      scope: Optional[pulumi.Input['IpSetScope']] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpSetResult]:
    """
    Contains a list of IP addresses. This can be either IPV4 or IPV6. The list will be mutually


    :param str id: The ID of the IP set.
    :param str name: The name of the IP set. You cannot change the name of an `IPSet` after you create it.
    :param 'IpSetScope' scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are `CLOUDFRONT` and `REGIONAL` .
           
           > For `CLOUDFRONT` , you must create your WAFv2 resources in the US East (N. Virginia) Region, `us-east-1` .
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:wafv2:getIpSet', __args__, opts=opts, typ=GetIpSetResult)
    return __ret__.apply(lambda __response__: GetIpSetResult(
        addresses=pulumi.get(__response__, 'addresses'),
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        ip_address_version=pulumi.get(__response__, 'ip_address_version'),
        tags=pulumi.get(__response__, 'tags')))
