# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetTargetGroupResult',
    'AwaitableGetTargetGroupResult',
    'get_target_group',
    'get_target_group_output',
]

@pulumi.output_type
class GetTargetGroupResult:
    def __init__(__self__, arn=None, config=None, created_at=None, id=None, last_updated_at=None, status=None, tags=None, targets=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if config and not isinstance(config, dict):
            raise TypeError("Expected argument 'config' to be a dict")
        pulumi.set(__self__, "config", config)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_at and not isinstance(last_updated_at, str):
            raise TypeError("Expected argument 'last_updated_at' to be a str")
        pulumi.set(__self__, "last_updated_at", last_updated_at)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if targets and not isinstance(targets, list):
            raise TypeError("Expected argument 'targets' to be a list")
        pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the target group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def config(self) -> Optional['outputs.TargetGroupConfig']:
        """
        The target group configuration.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The date and time that the target group was created, specified in ISO-8601 format.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the target group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> Optional[str]:
        """
        The date and time that the target group was last updated, specified in ISO-8601 format.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter
    def status(self) -> Optional['TargetGroupStatus']:
        """
        The operation's status. You can retry the operation if the status is `CREATE_FAILED` . However, if you retry it while the status is `CREATE_IN_PROGRESS` , there is no change in the status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags for the target group.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Sequence['outputs.TargetGroupTarget']]:
        """
        Describes a target.
        """
        return pulumi.get(self, "targets")


class AwaitableGetTargetGroupResult(GetTargetGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTargetGroupResult(
            arn=self.arn,
            config=self.config,
            created_at=self.created_at,
            id=self.id,
            last_updated_at=self.last_updated_at,
            status=self.status,
            tags=self.tags,
            targets=self.targets)


def get_target_group(arn: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTargetGroupResult:
    """
    A target group is a collection of targets, or compute resources, that run your application or service. A target group can only be used by a single service.


    :param str arn: The Amazon Resource Name (ARN) of the target group.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:vpclattice:getTargetGroup', __args__, opts=opts, typ=GetTargetGroupResult).value

    return AwaitableGetTargetGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        config=pulumi.get(__ret__, 'config'),
        created_at=pulumi.get(__ret__, 'created_at'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_at=pulumi.get(__ret__, 'last_updated_at'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        targets=pulumi.get(__ret__, 'targets'))
def get_target_group_output(arn: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTargetGroupResult]:
    """
    A target group is a collection of targets, or compute resources, that run your application or service. A target group can only be used by a single service.


    :param str arn: The Amazon Resource Name (ARN) of the target group.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:vpclattice:getTargetGroup', __args__, opts=opts, typ=GetTargetGroupResult)
    return __ret__.apply(lambda __response__: GetTargetGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        config=pulumi.get(__response__, 'config'),
        created_at=pulumi.get(__response__, 'created_at'),
        id=pulumi.get(__response__, 'id'),
        last_updated_at=pulumi.get(__response__, 'last_updated_at'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        targets=pulumi.get(__response__, 'targets')))
