# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetAuthPolicyResult',
    'AwaitableGetAuthPolicyResult',
    'get_auth_policy',
    'get_auth_policy_output',
]

@pulumi.output_type
class GetAuthPolicyResult:
    def __init__(__self__, policy=None, state=None):
        if policy and not isinstance(policy, dict):
            raise TypeError("Expected argument 'policy' to be a dict")
        pulumi.set(__self__, "policy", policy)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def policy(self) -> Optional[Any]:
        """
        The auth policy.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::VpcLattice::AuthPolicy` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def state(self) -> Optional['AuthPolicyState']:
        """
        The state of the auth policy. The auth policy is only active when the auth type is set to `AWS _IAM` . If you provide a policy, then authentication and authorization decisions are made based on this policy and the client's IAM policy. If the auth type is `NONE` , then any auth policy you provide will remain inactive.
        """
        return pulumi.get(self, "state")


class AwaitableGetAuthPolicyResult(GetAuthPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthPolicyResult(
            policy=self.policy,
            state=self.state)


def get_auth_policy(resource_identifier: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthPolicyResult:
    """
    Creates or updates the auth policy.


    :param str resource_identifier: The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
    """
    __args__ = dict()
    __args__['resourceIdentifier'] = resource_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:vpclattice:getAuthPolicy', __args__, opts=opts, typ=GetAuthPolicyResult).value

    return AwaitableGetAuthPolicyResult(
        policy=pulumi.get(__ret__, 'policy'),
        state=pulumi.get(__ret__, 'state'))
def get_auth_policy_output(resource_identifier: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAuthPolicyResult]:
    """
    Creates or updates the auth policy.


    :param str resource_identifier: The ID or Amazon Resource Name (ARN) of the service network or service for which the policy is created.
    """
    __args__ = dict()
    __args__['resourceIdentifier'] = resource_identifier
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:vpclattice:getAuthPolicy', __args__, opts=opts, typ=GetAuthPolicyResult)
    return __ret__.apply(lambda __response__: GetAuthPolicyResult(
        policy=pulumi.get(__response__, 'policy'),
        state=pulumi.get(__response__, 'state')))
