# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ListenerDefaultActionArgs',
    'ListenerDefaultActionArgsDict',
    'ListenerFixedResponseArgs',
    'ListenerFixedResponseArgsDict',
    'ListenerForwardArgs',
    'ListenerForwardArgsDict',
    'ListenerWeightedTargetGroupArgs',
    'ListenerWeightedTargetGroupArgsDict',
    'RuleActionArgs',
    'RuleActionArgsDict',
    'RuleFixedResponseArgs',
    'RuleFixedResponseArgsDict',
    'RuleForwardArgs',
    'RuleForwardArgsDict',
    'RuleHeaderMatchTypeArgs',
    'RuleHeaderMatchTypeArgsDict',
    'RuleHeaderMatchArgs',
    'RuleHeaderMatchArgsDict',
    'RuleHttpMatchArgs',
    'RuleHttpMatchArgsDict',
    'RuleMatchArgs',
    'RuleMatchArgsDict',
    'RulePathMatchTypeArgs',
    'RulePathMatchTypeArgsDict',
    'RulePathMatchArgs',
    'RulePathMatchArgsDict',
    'RuleWeightedTargetGroupArgs',
    'RuleWeightedTargetGroupArgsDict',
    'ServiceDnsEntryArgs',
    'ServiceDnsEntryArgsDict',
    'ServiceNetworkServiceAssociationDnsEntryArgs',
    'ServiceNetworkServiceAssociationDnsEntryArgsDict',
    'TargetGroupConfigArgs',
    'TargetGroupConfigArgsDict',
    'TargetGroupHealthCheckConfigArgs',
    'TargetGroupHealthCheckConfigArgsDict',
    'TargetGroupMatcherArgs',
    'TargetGroupMatcherArgsDict',
    'TargetGroupTargetArgs',
    'TargetGroupTargetArgsDict',
]

MYPY = False

if not MYPY:
    class ListenerDefaultActionArgsDict(TypedDict):
        fixed_response: NotRequired[pulumi.Input['ListenerFixedResponseArgsDict']]
        """
        Describes an action that returns a custom HTTP response.
        """
        forward: NotRequired[pulumi.Input['ListenerForwardArgsDict']]
        """
        Describes a forward action. You can use forward actions to route requests to one or more target groups.
        """
elif False:
    ListenerDefaultActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerDefaultActionArgs:
    def __init__(__self__, *,
                 fixed_response: Optional[pulumi.Input['ListenerFixedResponseArgs']] = None,
                 forward: Optional[pulumi.Input['ListenerForwardArgs']] = None):
        """
        :param pulumi.Input['ListenerFixedResponseArgs'] fixed_response: Describes an action that returns a custom HTTP response.
        :param pulumi.Input['ListenerForwardArgs'] forward: Describes a forward action. You can use forward actions to route requests to one or more target groups.
        """
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)

    @property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional[pulumi.Input['ListenerFixedResponseArgs']]:
        """
        Describes an action that returns a custom HTTP response.
        """
        return pulumi.get(self, "fixed_response")

    @fixed_response.setter
    def fixed_response(self, value: Optional[pulumi.Input['ListenerFixedResponseArgs']]):
        pulumi.set(self, "fixed_response", value)

    @property
    @pulumi.getter
    def forward(self) -> Optional[pulumi.Input['ListenerForwardArgs']]:
        """
        Describes a forward action. You can use forward actions to route requests to one or more target groups.
        """
        return pulumi.get(self, "forward")

    @forward.setter
    def forward(self, value: Optional[pulumi.Input['ListenerForwardArgs']]):
        pulumi.set(self, "forward", value)


if not MYPY:
    class ListenerFixedResponseArgsDict(TypedDict):
        status_code: pulumi.Input[int]
        """
        The HTTP response code.
        """
elif False:
    ListenerFixedResponseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerFixedResponseArgs:
    def __init__(__self__, *,
                 status_code: pulumi.Input[int]):
        """
        :param pulumi.Input[int] status_code: The HTTP response code.
        """
        pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[int]:
        """
        The HTTP response code.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[int]):
        pulumi.set(self, "status_code", value)


if not MYPY:
    class ListenerForwardArgsDict(TypedDict):
        target_groups: pulumi.Input[Sequence[pulumi.Input['ListenerWeightedTargetGroupArgsDict']]]
        """
        The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.

        The default value is 1. This means that if only one target group is provided, there is no need to set the weight; 100% of the traffic goes to that target group.
        """
elif False:
    ListenerForwardArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerForwardArgs:
    def __init__(__self__, *,
                 target_groups: pulumi.Input[Sequence[pulumi.Input['ListenerWeightedTargetGroupArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ListenerWeightedTargetGroupArgs']]] target_groups: The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.
               
               The default value is 1. This means that if only one target group is provided, there is no need to set the weight; 100% of the traffic goes to that target group.
        """
        pulumi.set(__self__, "target_groups", target_groups)

    @property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> pulumi.Input[Sequence[pulumi.Input['ListenerWeightedTargetGroupArgs']]]:
        """
        The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.

        The default value is 1. This means that if only one target group is provided, there is no need to set the weight; 100% of the traffic goes to that target group.
        """
        return pulumi.get(self, "target_groups")

    @target_groups.setter
    def target_groups(self, value: pulumi.Input[Sequence[pulumi.Input['ListenerWeightedTargetGroupArgs']]]):
        pulumi.set(self, "target_groups", value)


if not MYPY:
    class ListenerWeightedTargetGroupArgsDict(TypedDict):
        target_group_identifier: pulumi.Input[str]
        """
        The ID of the target group.
        """
        weight: NotRequired[pulumi.Input[int]]
        """
        Only required if you specify multiple target groups for a forward action. The weight determines how requests are distributed to the target group. For example, if you specify two target groups, each with a weight of 10, each target group receives half the requests. If you specify two target groups, one with a weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. If there's only one target group specified, then the default value is 100.
        """
elif False:
    ListenerWeightedTargetGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerWeightedTargetGroupArgs:
    def __init__(__self__, *,
                 target_group_identifier: pulumi.Input[str],
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] target_group_identifier: The ID of the target group.
        :param pulumi.Input[int] weight: Only required if you specify multiple target groups for a forward action. The weight determines how requests are distributed to the target group. For example, if you specify two target groups, each with a weight of 10, each target group receives half the requests. If you specify two target groups, one with a weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. If there's only one target group specified, then the default value is 100.
        """
        pulumi.set(__self__, "target_group_identifier", target_group_identifier)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="targetGroupIdentifier")
    def target_group_identifier(self) -> pulumi.Input[str]:
        """
        The ID of the target group.
        """
        return pulumi.get(self, "target_group_identifier")

    @target_group_identifier.setter
    def target_group_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_group_identifier", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        Only required if you specify multiple target groups for a forward action. The weight determines how requests are distributed to the target group. For example, if you specify two target groups, each with a weight of 10, each target group receives half the requests. If you specify two target groups, one with a weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. If there's only one target group specified, then the default value is 100.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


if not MYPY:
    class RuleActionArgsDict(TypedDict):
        fixed_response: NotRequired[pulumi.Input['RuleFixedResponseArgsDict']]
        """
        The fixed response action. The rule returns a custom HTTP response.
        """
        forward: NotRequired[pulumi.Input['RuleForwardArgsDict']]
        """
        The forward action. Traffic that matches the rule is forwarded to the specified target groups.
        """
elif False:
    RuleActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleActionArgs:
    def __init__(__self__, *,
                 fixed_response: Optional[pulumi.Input['RuleFixedResponseArgs']] = None,
                 forward: Optional[pulumi.Input['RuleForwardArgs']] = None):
        """
        :param pulumi.Input['RuleFixedResponseArgs'] fixed_response: The fixed response action. The rule returns a custom HTTP response.
        :param pulumi.Input['RuleForwardArgs'] forward: The forward action. Traffic that matches the rule is forwarded to the specified target groups.
        """
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)

    @property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional[pulumi.Input['RuleFixedResponseArgs']]:
        """
        The fixed response action. The rule returns a custom HTTP response.
        """
        return pulumi.get(self, "fixed_response")

    @fixed_response.setter
    def fixed_response(self, value: Optional[pulumi.Input['RuleFixedResponseArgs']]):
        pulumi.set(self, "fixed_response", value)

    @property
    @pulumi.getter
    def forward(self) -> Optional[pulumi.Input['RuleForwardArgs']]:
        """
        The forward action. Traffic that matches the rule is forwarded to the specified target groups.
        """
        return pulumi.get(self, "forward")

    @forward.setter
    def forward(self, value: Optional[pulumi.Input['RuleForwardArgs']]):
        pulumi.set(self, "forward", value)


if not MYPY:
    class RuleFixedResponseArgsDict(TypedDict):
        status_code: pulumi.Input[int]
        """
        The HTTP response code.
        """
elif False:
    RuleFixedResponseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleFixedResponseArgs:
    def __init__(__self__, *,
                 status_code: pulumi.Input[int]):
        """
        :param pulumi.Input[int] status_code: The HTTP response code.
        """
        pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[int]:
        """
        The HTTP response code.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[int]):
        pulumi.set(self, "status_code", value)


if not MYPY:
    class RuleForwardArgsDict(TypedDict):
        target_groups: pulumi.Input[Sequence[pulumi.Input['RuleWeightedTargetGroupArgsDict']]]
        """
        The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.

        The default value is 1. This means that if only one target group is provided, there is no need to set the weight; 100% of the traffic goes to that target group.
        """
elif False:
    RuleForwardArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleForwardArgs:
    def __init__(__self__, *,
                 target_groups: pulumi.Input[Sequence[pulumi.Input['RuleWeightedTargetGroupArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RuleWeightedTargetGroupArgs']]] target_groups: The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.
               
               The default value is 1. This means that if only one target group is provided, there is no need to set the weight; 100% of the traffic goes to that target group.
        """
        pulumi.set(__self__, "target_groups", target_groups)

    @property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> pulumi.Input[Sequence[pulumi.Input['RuleWeightedTargetGroupArgs']]]:
        """
        The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.

        The default value is 1. This means that if only one target group is provided, there is no need to set the weight; 100% of the traffic goes to that target group.
        """
        return pulumi.get(self, "target_groups")

    @target_groups.setter
    def target_groups(self, value: pulumi.Input[Sequence[pulumi.Input['RuleWeightedTargetGroupArgs']]]):
        pulumi.set(self, "target_groups", value)


if not MYPY:
    class RuleHeaderMatchTypeArgsDict(TypedDict):
        contains: NotRequired[pulumi.Input[str]]
        """
        A contains type match.
        """
        exact: NotRequired[pulumi.Input[str]]
        """
        An exact type match.
        """
        prefix: NotRequired[pulumi.Input[str]]
        """
        A prefix type match. Matches the value with the prefix.
        """
elif False:
    RuleHeaderMatchTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleHeaderMatchTypeArgs:
    def __init__(__self__, *,
                 contains: Optional[pulumi.Input[str]] = None,
                 exact: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] contains: A contains type match.
        :param pulumi.Input[str] exact: An exact type match.
        :param pulumi.Input[str] prefix: A prefix type match. Matches the value with the prefix.
        """
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def contains(self) -> Optional[pulumi.Input[str]]:
        """
        A contains type match.
        """
        return pulumi.get(self, "contains")

    @contains.setter
    def contains(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "contains", value)

    @property
    @pulumi.getter
    def exact(self) -> Optional[pulumi.Input[str]]:
        """
        An exact type match.
        """
        return pulumi.get(self, "exact")

    @exact.setter
    def exact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exact", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        A prefix type match. Matches the value with the prefix.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


if not MYPY:
    class RuleHeaderMatchArgsDict(TypedDict):
        match: pulumi.Input['RuleHeaderMatchTypeArgsDict']
        """
        The header match type.
        """
        name: pulumi.Input[str]
        """
        The name of the header.
        """
        case_sensitive: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether the match is case sensitive.
        """
elif False:
    RuleHeaderMatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleHeaderMatchArgs:
    def __init__(__self__, *,
                 match: pulumi.Input['RuleHeaderMatchTypeArgs'],
                 name: pulumi.Input[str],
                 case_sensitive: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['RuleHeaderMatchTypeArgs'] match: The header match type.
        :param pulumi.Input[str] name: The name of the header.
        :param pulumi.Input[bool] case_sensitive: Indicates whether the match is case sensitive.
        """
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "name", name)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)

    @property
    @pulumi.getter
    def match(self) -> pulumi.Input['RuleHeaderMatchTypeArgs']:
        """
        The header match type.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input['RuleHeaderMatchTypeArgs']):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the header.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the match is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")

    @case_sensitive.setter
    def case_sensitive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "case_sensitive", value)


if not MYPY:
    class RuleHttpMatchArgsDict(TypedDict):
        header_matches: NotRequired[pulumi.Input[Sequence[pulumi.Input['RuleHeaderMatchArgsDict']]]]
        """
        The header matches. Matches incoming requests with rule based on request header value before applying rule action.
        """
        method: NotRequired[pulumi.Input['RuleHttpMatchMethod']]
        """
        The HTTP method type.
        """
        path_match: NotRequired[pulumi.Input['RulePathMatchArgsDict']]
        """
        The path match.
        """
elif False:
    RuleHttpMatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleHttpMatchArgs:
    def __init__(__self__, *,
                 header_matches: Optional[pulumi.Input[Sequence[pulumi.Input['RuleHeaderMatchArgs']]]] = None,
                 method: Optional[pulumi.Input['RuleHttpMatchMethod']] = None,
                 path_match: Optional[pulumi.Input['RulePathMatchArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RuleHeaderMatchArgs']]] header_matches: The header matches. Matches incoming requests with rule based on request header value before applying rule action.
        :param pulumi.Input['RuleHttpMatchMethod'] method: The HTTP method type.
        :param pulumi.Input['RulePathMatchArgs'] path_match: The path match.
        """
        if header_matches is not None:
            pulumi.set(__self__, "header_matches", header_matches)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if path_match is not None:
            pulumi.set(__self__, "path_match", path_match)

    @property
    @pulumi.getter(name="headerMatches")
    def header_matches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleHeaderMatchArgs']]]]:
        """
        The header matches. Matches incoming requests with rule based on request header value before applying rule action.
        """
        return pulumi.get(self, "header_matches")

    @header_matches.setter
    def header_matches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleHeaderMatchArgs']]]]):
        pulumi.set(self, "header_matches", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input['RuleHttpMatchMethod']]:
        """
        The HTTP method type.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input['RuleHttpMatchMethod']]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter(name="pathMatch")
    def path_match(self) -> Optional[pulumi.Input['RulePathMatchArgs']]:
        """
        The path match.
        """
        return pulumi.get(self, "path_match")

    @path_match.setter
    def path_match(self, value: Optional[pulumi.Input['RulePathMatchArgs']]):
        pulumi.set(self, "path_match", value)


if not MYPY:
    class RuleMatchArgsDict(TypedDict):
        http_match: pulumi.Input['RuleHttpMatchArgsDict']
        """
        The HTTP criteria that a rule must match.
        """
elif False:
    RuleMatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleMatchArgs:
    def __init__(__self__, *,
                 http_match: pulumi.Input['RuleHttpMatchArgs']):
        """
        :param pulumi.Input['RuleHttpMatchArgs'] http_match: The HTTP criteria that a rule must match.
        """
        pulumi.set(__self__, "http_match", http_match)

    @property
    @pulumi.getter(name="httpMatch")
    def http_match(self) -> pulumi.Input['RuleHttpMatchArgs']:
        """
        The HTTP criteria that a rule must match.
        """
        return pulumi.get(self, "http_match")

    @http_match.setter
    def http_match(self, value: pulumi.Input['RuleHttpMatchArgs']):
        pulumi.set(self, "http_match", value)


if not MYPY:
    class RulePathMatchTypeArgsDict(TypedDict):
        exact: NotRequired[pulumi.Input[str]]
        """
        An exact match of the path.
        """
        prefix: NotRequired[pulumi.Input[str]]
        """
        A prefix match of the path.
        """
elif False:
    RulePathMatchTypeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RulePathMatchTypeArgs:
    def __init__(__self__, *,
                 exact: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] exact: An exact match of the path.
        :param pulumi.Input[str] prefix: A prefix match of the path.
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def exact(self) -> Optional[pulumi.Input[str]]:
        """
        An exact match of the path.
        """
        return pulumi.get(self, "exact")

    @exact.setter
    def exact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exact", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        A prefix match of the path.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


if not MYPY:
    class RulePathMatchArgsDict(TypedDict):
        match: pulumi.Input['RulePathMatchTypeArgsDict']
        """
        The type of path match.
        """
        case_sensitive: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether the match is case sensitive.
        """
elif False:
    RulePathMatchArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RulePathMatchArgs:
    def __init__(__self__, *,
                 match: pulumi.Input['RulePathMatchTypeArgs'],
                 case_sensitive: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['RulePathMatchTypeArgs'] match: The type of path match.
        :param pulumi.Input[bool] case_sensitive: Indicates whether the match is case sensitive.
        """
        pulumi.set(__self__, "match", match)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)

    @property
    @pulumi.getter
    def match(self) -> pulumi.Input['RulePathMatchTypeArgs']:
        """
        The type of path match.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input['RulePathMatchTypeArgs']):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the match is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")

    @case_sensitive.setter
    def case_sensitive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "case_sensitive", value)


if not MYPY:
    class RuleWeightedTargetGroupArgsDict(TypedDict):
        target_group_identifier: pulumi.Input[str]
        """
        The ID of the target group.
        """
        weight: NotRequired[pulumi.Input[int]]
        """
        Only required if you specify multiple target groups for a forward action. The weight determines how requests are distributed to the target group. For example, if you specify two target groups, each with a weight of 10, each target group receives half the requests. If you specify two target groups, one with a weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. If there's only one target group specified, then the default value is 100.
        """
elif False:
    RuleWeightedTargetGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleWeightedTargetGroupArgs:
    def __init__(__self__, *,
                 target_group_identifier: pulumi.Input[str],
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] target_group_identifier: The ID of the target group.
        :param pulumi.Input[int] weight: Only required if you specify multiple target groups for a forward action. The weight determines how requests are distributed to the target group. For example, if you specify two target groups, each with a weight of 10, each target group receives half the requests. If you specify two target groups, one with a weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. If there's only one target group specified, then the default value is 100.
        """
        pulumi.set(__self__, "target_group_identifier", target_group_identifier)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="targetGroupIdentifier")
    def target_group_identifier(self) -> pulumi.Input[str]:
        """
        The ID of the target group.
        """
        return pulumi.get(self, "target_group_identifier")

    @target_group_identifier.setter
    def target_group_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_group_identifier", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        Only required if you specify multiple target groups for a forward action. The weight determines how requests are distributed to the target group. For example, if you specify two target groups, each with a weight of 10, each target group receives half the requests. If you specify two target groups, one with a weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. If there's only one target group specified, then the default value is 100.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


if not MYPY:
    class ServiceDnsEntryArgsDict(TypedDict):
        domain_name: NotRequired[pulumi.Input[str]]
        """
        The domain name of the service.
        """
        hosted_zone_id: NotRequired[pulumi.Input[str]]
        """
        The ID of the hosted zone.
        """
elif False:
    ServiceDnsEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceDnsEntryArgs:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 hosted_zone_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] domain_name: The domain name of the service.
        :param pulumi.Input[str] hosted_zone_id: The ID of the hosted zone.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name of the service.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")

    @hosted_zone_id.setter
    def hosted_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hosted_zone_id", value)


if not MYPY:
    class ServiceNetworkServiceAssociationDnsEntryArgsDict(TypedDict):
        domain_name: NotRequired[pulumi.Input[str]]
        """
        The domain name of the service.
        """
        hosted_zone_id: NotRequired[pulumi.Input[str]]
        """
        The ID of the hosted zone.
        """
elif False:
    ServiceNetworkServiceAssociationDnsEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServiceNetworkServiceAssociationDnsEntryArgs:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 hosted_zone_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] domain_name: The domain name of the service.
        :param pulumi.Input[str] hosted_zone_id: The ID of the hosted zone.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name of the service.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")

    @hosted_zone_id.setter
    def hosted_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hosted_zone_id", value)


if not MYPY:
    class TargetGroupConfigArgsDict(TypedDict):
        health_check: NotRequired[pulumi.Input['TargetGroupHealthCheckConfigArgsDict']]
        """
        The health check configuration. Not supported if the target group type is `LAMBDA` or `ALB` .
        """
        ip_address_type: NotRequired[pulumi.Input['TargetGroupConfigIpAddressType']]
        """
        The type of IP address used for the target group. Supported only if the target group type is `IP` . The default is `IPV4` .
        """
        lambda_event_structure_version: NotRequired[pulumi.Input['TargetGroupConfigLambdaEventStructureVersion']]
        """
        The version of the event structure that your Lambda function receives. Supported only if the target group type is `LAMBDA` . The default is `V1` .
        """
        port: NotRequired[pulumi.Input[int]]
        """
        The port on which the targets are listening. For HTTP, the default is 80. For HTTPS, the default is 443. Not supported if the target group type is `LAMBDA` .
        """
        protocol: NotRequired[pulumi.Input['TargetGroupConfigProtocol']]
        """
        The protocol to use for routing traffic to the targets. The default is the protocol of the target group. Not supported if the target group type is `LAMBDA` .
        """
        protocol_version: NotRequired[pulumi.Input['TargetGroupConfigProtocolVersion']]
        """
        The protocol version. The default is `HTTP1` . Not supported if the target group type is `LAMBDA` .
        """
        vpc_identifier: NotRequired[pulumi.Input[str]]
        """
        The ID of the VPC. Not supported if the target group type is `LAMBDA` .
        """
elif False:
    TargetGroupConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupConfigArgs:
    def __init__(__self__, *,
                 health_check: Optional[pulumi.Input['TargetGroupHealthCheckConfigArgs']] = None,
                 ip_address_type: Optional[pulumi.Input['TargetGroupConfigIpAddressType']] = None,
                 lambda_event_structure_version: Optional[pulumi.Input['TargetGroupConfigLambdaEventStructureVersion']] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input['TargetGroupConfigProtocol']] = None,
                 protocol_version: Optional[pulumi.Input['TargetGroupConfigProtocolVersion']] = None,
                 vpc_identifier: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['TargetGroupHealthCheckConfigArgs'] health_check: The health check configuration. Not supported if the target group type is `LAMBDA` or `ALB` .
        :param pulumi.Input['TargetGroupConfigIpAddressType'] ip_address_type: The type of IP address used for the target group. Supported only if the target group type is `IP` . The default is `IPV4` .
        :param pulumi.Input['TargetGroupConfigLambdaEventStructureVersion'] lambda_event_structure_version: The version of the event structure that your Lambda function receives. Supported only if the target group type is `LAMBDA` . The default is `V1` .
        :param pulumi.Input[int] port: The port on which the targets are listening. For HTTP, the default is 80. For HTTPS, the default is 443. Not supported if the target group type is `LAMBDA` .
        :param pulumi.Input['TargetGroupConfigProtocol'] protocol: The protocol to use for routing traffic to the targets. The default is the protocol of the target group. Not supported if the target group type is `LAMBDA` .
        :param pulumi.Input['TargetGroupConfigProtocolVersion'] protocol_version: The protocol version. The default is `HTTP1` . Not supported if the target group type is `LAMBDA` .
        :param pulumi.Input[str] vpc_identifier: The ID of the VPC. Not supported if the target group type is `LAMBDA` .
        """
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if lambda_event_structure_version is not None:
            pulumi.set(__self__, "lambda_event_structure_version", lambda_event_structure_version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if vpc_identifier is not None:
            pulumi.set(__self__, "vpc_identifier", vpc_identifier)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['TargetGroupHealthCheckConfigArgs']]:
        """
        The health check configuration. Not supported if the target group type is `LAMBDA` or `ALB` .
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['TargetGroupHealthCheckConfigArgs']]):
        pulumi.set(self, "health_check", value)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input['TargetGroupConfigIpAddressType']]:
        """
        The type of IP address used for the target group. Supported only if the target group type is `IP` . The default is `IPV4` .
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input['TargetGroupConfigIpAddressType']]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter(name="lambdaEventStructureVersion")
    def lambda_event_structure_version(self) -> Optional[pulumi.Input['TargetGroupConfigLambdaEventStructureVersion']]:
        """
        The version of the event structure that your Lambda function receives. Supported only if the target group type is `LAMBDA` . The default is `V1` .
        """
        return pulumi.get(self, "lambda_event_structure_version")

    @lambda_event_structure_version.setter
    def lambda_event_structure_version(self, value: Optional[pulumi.Input['TargetGroupConfigLambdaEventStructureVersion']]):
        pulumi.set(self, "lambda_event_structure_version", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port on which the targets are listening. For HTTP, the default is 80. For HTTPS, the default is 443. Not supported if the target group type is `LAMBDA` .
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input['TargetGroupConfigProtocol']]:
        """
        The protocol to use for routing traffic to the targets. The default is the protocol of the target group. Not supported if the target group type is `LAMBDA` .
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input['TargetGroupConfigProtocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[pulumi.Input['TargetGroupConfigProtocolVersion']]:
        """
        The protocol version. The default is `HTTP1` . Not supported if the target group type is `LAMBDA` .
        """
        return pulumi.get(self, "protocol_version")

    @protocol_version.setter
    def protocol_version(self, value: Optional[pulumi.Input['TargetGroupConfigProtocolVersion']]):
        pulumi.set(self, "protocol_version", value)

    @property
    @pulumi.getter(name="vpcIdentifier")
    def vpc_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC. Not supported if the target group type is `LAMBDA` .
        """
        return pulumi.get(self, "vpc_identifier")

    @vpc_identifier.setter
    def vpc_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_identifier", value)


if not MYPY:
    class TargetGroupHealthCheckConfigArgsDict(TypedDict):
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether health checking is enabled.
        """
        health_check_interval_seconds: NotRequired[pulumi.Input[int]]
        """
        The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300 seconds. The default is 30 seconds.
        """
        health_check_timeout_seconds: NotRequired[pulumi.Input[int]]
        """
        The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The default is 5 seconds.
        """
        healthy_threshold_count: NotRequired[pulumi.Input[int]]
        """
        The number of consecutive successful health checks required before considering an unhealthy target healthy. The range is 2–10. The default is 5.
        """
        matcher: NotRequired[pulumi.Input['TargetGroupMatcherArgsDict']]
        """
        The codes to use when checking for a successful response from a target.
        """
        path: NotRequired[pulumi.Input[str]]
        """
        The destination for health checks on the targets. If the protocol version is `HTTP/1.1` or `HTTP/2` , specify a valid URI (for example, `/path?query` ). The default path is `/` . Health checks are not supported if the protocol version is `gRPC` , however, you can choose `HTTP/1.1` or `HTTP/2` and specify a valid URI.
        """
        port: NotRequired[pulumi.Input[int]]
        """
        The port used when performing health checks on targets. The default setting is the port that a target receives traffic on.
        """
        protocol: NotRequired[pulumi.Input['TargetGroupHealthCheckConfigProtocol']]
        """
        The protocol used when performing health checks on targets. The possible protocols are `HTTP` and `HTTPS` . The default is `HTTP` .
        """
        protocol_version: NotRequired[pulumi.Input['TargetGroupHealthCheckConfigProtocolVersion']]
        """
        The protocol version used when performing health checks on targets. The possible protocol versions are `HTTP1` and `HTTP2` .
        """
        unhealthy_threshold_count: NotRequired[pulumi.Input[int]]
        """
        The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10. The default is 2.
        """
elif False:
    TargetGroupHealthCheckConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupHealthCheckConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 health_check_interval_seconds: Optional[pulumi.Input[int]] = None,
                 health_check_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 healthy_threshold_count: Optional[pulumi.Input[int]] = None,
                 matcher: Optional[pulumi.Input['TargetGroupMatcherArgs']] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input['TargetGroupHealthCheckConfigProtocol']] = None,
                 protocol_version: Optional[pulumi.Input['TargetGroupHealthCheckConfigProtocolVersion']] = None,
                 unhealthy_threshold_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[bool] enabled: Indicates whether health checking is enabled.
        :param pulumi.Input[int] health_check_interval_seconds: The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300 seconds. The default is 30 seconds.
        :param pulumi.Input[int] health_check_timeout_seconds: The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The default is 5 seconds.
        :param pulumi.Input[int] healthy_threshold_count: The number of consecutive successful health checks required before considering an unhealthy target healthy. The range is 2–10. The default is 5.
        :param pulumi.Input['TargetGroupMatcherArgs'] matcher: The codes to use when checking for a successful response from a target.
        :param pulumi.Input[str] path: The destination for health checks on the targets. If the protocol version is `HTTP/1.1` or `HTTP/2` , specify a valid URI (for example, `/path?query` ). The default path is `/` . Health checks are not supported if the protocol version is `gRPC` , however, you can choose `HTTP/1.1` or `HTTP/2` and specify a valid URI.
        :param pulumi.Input[int] port: The port used when performing health checks on targets. The default setting is the port that a target receives traffic on.
        :param pulumi.Input['TargetGroupHealthCheckConfigProtocol'] protocol: The protocol used when performing health checks on targets. The possible protocols are `HTTP` and `HTTPS` . The default is `HTTP` .
        :param pulumi.Input['TargetGroupHealthCheckConfigProtocolVersion'] protocol_version: The protocol version used when performing health checks on targets. The possible protocol versions are `HTTP1` and `HTTP2` .
        :param pulumi.Input[int] unhealthy_threshold_count: The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10. The default is 2.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if health_check_interval_seconds is not None:
            pulumi.set(__self__, "health_check_interval_seconds", health_check_interval_seconds)
        if health_check_timeout_seconds is not None:
            pulumi.set(__self__, "health_check_timeout_seconds", health_check_timeout_seconds)
        if healthy_threshold_count is not None:
            pulumi.set(__self__, "healthy_threshold_count", healthy_threshold_count)
        if matcher is not None:
            pulumi.set(__self__, "matcher", matcher)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if unhealthy_threshold_count is not None:
            pulumi.set(__self__, "unhealthy_threshold_count", unhealthy_threshold_count)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether health checking is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="healthCheckIntervalSeconds")
    def health_check_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300 seconds. The default is 30 seconds.
        """
        return pulumi.get(self, "health_check_interval_seconds")

    @health_check_interval_seconds.setter
    def health_check_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_interval_seconds", value)

    @property
    @pulumi.getter(name="healthCheckTimeoutSeconds")
    def health_check_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The default is 5 seconds.
        """
        return pulumi.get(self, "health_check_timeout_seconds")

    @health_check_timeout_seconds.setter
    def health_check_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_timeout_seconds", value)

    @property
    @pulumi.getter(name="healthyThresholdCount")
    def healthy_threshold_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive successful health checks required before considering an unhealthy target healthy. The range is 2–10. The default is 5.
        """
        return pulumi.get(self, "healthy_threshold_count")

    @healthy_threshold_count.setter
    def healthy_threshold_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "healthy_threshold_count", value)

    @property
    @pulumi.getter
    def matcher(self) -> Optional[pulumi.Input['TargetGroupMatcherArgs']]:
        """
        The codes to use when checking for a successful response from a target.
        """
        return pulumi.get(self, "matcher")

    @matcher.setter
    def matcher(self, value: Optional[pulumi.Input['TargetGroupMatcherArgs']]):
        pulumi.set(self, "matcher", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The destination for health checks on the targets. If the protocol version is `HTTP/1.1` or `HTTP/2` , specify a valid URI (for example, `/path?query` ). The default path is `/` . Health checks are not supported if the protocol version is `gRPC` , however, you can choose `HTTP/1.1` or `HTTP/2` and specify a valid URI.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port used when performing health checks on targets. The default setting is the port that a target receives traffic on.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input['TargetGroupHealthCheckConfigProtocol']]:
        """
        The protocol used when performing health checks on targets. The possible protocols are `HTTP` and `HTTPS` . The default is `HTTP` .
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input['TargetGroupHealthCheckConfigProtocol']]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[pulumi.Input['TargetGroupHealthCheckConfigProtocolVersion']]:
        """
        The protocol version used when performing health checks on targets. The possible protocol versions are `HTTP1` and `HTTP2` .
        """
        return pulumi.get(self, "protocol_version")

    @protocol_version.setter
    def protocol_version(self, value: Optional[pulumi.Input['TargetGroupHealthCheckConfigProtocolVersion']]):
        pulumi.set(self, "protocol_version", value)

    @property
    @pulumi.getter(name="unhealthyThresholdCount")
    def unhealthy_threshold_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10. The default is 2.
        """
        return pulumi.get(self, "unhealthy_threshold_count")

    @unhealthy_threshold_count.setter
    def unhealthy_threshold_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unhealthy_threshold_count", value)


if not MYPY:
    class TargetGroupMatcherArgsDict(TypedDict):
        http_code: pulumi.Input[str]
        """
        The HTTP code to use when checking for a successful response from a target.
        """
elif False:
    TargetGroupMatcherArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupMatcherArgs:
    def __init__(__self__, *,
                 http_code: pulumi.Input[str]):
        """
        :param pulumi.Input[str] http_code: The HTTP code to use when checking for a successful response from a target.
        """
        pulumi.set(__self__, "http_code", http_code)

    @property
    @pulumi.getter(name="httpCode")
    def http_code(self) -> pulumi.Input[str]:
        """
        The HTTP code to use when checking for a successful response from a target.
        """
        return pulumi.get(self, "http_code")

    @http_code.setter
    def http_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "http_code", value)


if not MYPY:
    class TargetGroupTargetArgsDict(TypedDict):
        id: pulumi.Input[str]
        """
        The ID of the target. If the target group type is `INSTANCE` , this is an instance ID. If the target group type is `IP` , this is an IP address. If the target group type is `LAMBDA` , this is the ARN of a Lambda function. If the target group type is `ALB` , this is the ARN of an Application Load Balancer.
        """
        port: NotRequired[pulumi.Input[int]]
        """
        The port on which the target is listening. For HTTP, the default is 80. For HTTPS, the default is 443.
        """
elif False:
    TargetGroupTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupTargetArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] id: The ID of the target. If the target group type is `INSTANCE` , this is an instance ID. If the target group type is `IP` , this is an IP address. If the target group type is `LAMBDA` , this is the ARN of a Lambda function. If the target group type is `ALB` , this is the ARN of an Application Load Balancer.
        :param pulumi.Input[int] port: The port on which the target is listening. For HTTP, the default is 80. For HTTPS, the default is 443.
        """
        pulumi.set(__self__, "id", id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The ID of the target. If the target group type is `INSTANCE` , this is an instance ID. If the target group type is `IP` , this is an IP address. If the target group type is `LAMBDA` , this is the ARN of a Lambda function. If the target group type is `ALB` , this is the ARN of an Application Load Balancer.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port on which the target is listening. For HTTP, the default is 80. For HTTPS, the default is 443.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


