# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetPolicyResult',
    'AwaitableGetPolicyResult',
    'get_policy',
    'get_policy_output',
]

@pulumi.output_type
class GetPolicyResult:
    def __init__(__self__, definition=None, policy_id=None, policy_type=None):
        if definition and not isinstance(definition, dict):
            raise TypeError("Expected argument 'definition' to be a dict")
        pulumi.set(__self__, "definition", definition)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if policy_type and not isinstance(policy_type, str):
            raise TypeError("Expected argument 'policy_type' to be a str")
        pulumi.set(__self__, "policy_type", policy_type)

    @property
    @pulumi.getter
    def definition(self) -> Optional[Any]:
        """
        Specifies the policy type and content to use for the new or updated policy. The definition structure must include either a `Static` or a `TemplateLinked` element.
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[str]:
        """
        The unique ID of the new or updated policy.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional['PolicyType']:
        """
        The type of the policy. This is one of the following values:

        - Static
        - TemplateLinked
        """
        return pulumi.get(self, "policy_type")


class AwaitableGetPolicyResult(GetPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyResult(
            definition=self.definition,
            policy_id=self.policy_id,
            policy_type=self.policy_type)


def get_policy(policy_id: Optional[str] = None,
               policy_store_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyResult:
    """
    Definition of AWS::VerifiedPermissions::Policy Resource Type


    :param str policy_id: The unique ID of the new or updated policy.
    :param str policy_store_id: Specifies the `PolicyStoreId` of the policy store you want to store the policy in.
    """
    __args__ = dict()
    __args__['policyId'] = policy_id
    __args__['policyStoreId'] = policy_store_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:verifiedpermissions:getPolicy', __args__, opts=opts, typ=GetPolicyResult).value

    return AwaitableGetPolicyResult(
        definition=pulumi.get(__ret__, 'definition'),
        policy_id=pulumi.get(__ret__, 'policy_id'),
        policy_type=pulumi.get(__ret__, 'policy_type'))
def get_policy_output(policy_id: Optional[pulumi.Input[str]] = None,
                      policy_store_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPolicyResult]:
    """
    Definition of AWS::VerifiedPermissions::Policy Resource Type


    :param str policy_id: The unique ID of the new or updated policy.
    :param str policy_store_id: Specifies the `PolicyStoreId` of the policy store you want to store the policy in.
    """
    __args__ = dict()
    __args__['policyId'] = policy_id
    __args__['policyStoreId'] = policy_store_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:verifiedpermissions:getPolicy', __args__, opts=opts, typ=GetPolicyResult)
    return __ret__.apply(lambda __response__: GetPolicyResult(
        definition=pulumi.get(__response__, 'definition'),
        policy_id=pulumi.get(__response__, 'policy_id'),
        policy_type=pulumi.get(__response__, 'policy_type')))
