# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'As2ConfigPropertiesArgs',
    'As2ConfigPropertiesArgsDict',
    'SftpConfigPropertiesArgs',
    'SftpConfigPropertiesArgsDict',
    'WorkflowEfsInputFileLocationArgs',
    'WorkflowEfsInputFileLocationArgsDict',
    'WorkflowInputFileLocationArgs',
    'WorkflowInputFileLocationArgsDict',
    'WorkflowS3FileLocationArgs',
    'WorkflowS3FileLocationArgsDict',
    'WorkflowS3InputFileLocationArgs',
    'WorkflowS3InputFileLocationArgsDict',
    'WorkflowS3TagArgs',
    'WorkflowS3TagArgsDict',
    'WorkflowStepCopyStepDetailsPropertiesArgs',
    'WorkflowStepCopyStepDetailsPropertiesArgsDict',
    'WorkflowStepCustomStepDetailsPropertiesArgs',
    'WorkflowStepCustomStepDetailsPropertiesArgsDict',
    'WorkflowStepDecryptStepDetailsPropertiesArgs',
    'WorkflowStepDecryptStepDetailsPropertiesArgsDict',
    'WorkflowStepDeleteStepDetailsPropertiesArgs',
    'WorkflowStepDeleteStepDetailsPropertiesArgsDict',
    'WorkflowStepTagStepDetailsPropertiesArgs',
    'WorkflowStepTagStepDetailsPropertiesArgsDict',
    'WorkflowStepArgs',
    'WorkflowStepArgsDict',
]

MYPY = False

if not MYPY:
    class As2ConfigPropertiesArgsDict(TypedDict):
        """
        Configuration for an AS2 connector.
        """
        basic_auth_secret_id: NotRequired[pulumi.Input[str]]
        """
        ARN or name of the secret in AWS Secrets Manager which contains the credentials for Basic authentication. If empty, Basic authentication is disabled for the AS2 connector
        """
        compression: NotRequired[pulumi.Input['ConnectorAs2ConfigPropertiesCompression']]
        """
        Compression setting for this AS2 connector configuration.
        """
        encryption_algorithm: NotRequired[pulumi.Input['ConnectorAs2ConfigPropertiesEncryptionAlgorithm']]
        """
        Encryption algorithm for this AS2 connector configuration.
        """
        local_profile_id: NotRequired[pulumi.Input[str]]
        """
        A unique identifier for the local profile.
        """
        mdn_response: NotRequired[pulumi.Input['ConnectorAs2ConfigPropertiesMdnResponse']]
        """
        MDN Response setting for this AS2 connector configuration.
        """
        mdn_signing_algorithm: NotRequired[pulumi.Input['ConnectorAs2ConfigPropertiesMdnSigningAlgorithm']]
        """
        MDN Signing algorithm for this AS2 connector configuration.
        """
        message_subject: NotRequired[pulumi.Input[str]]
        """
        The message subject for this AS2 connector configuration.
        """
        partner_profile_id: NotRequired[pulumi.Input[str]]
        """
        A unique identifier for the partner profile.
        """
        signing_algorithm: NotRequired[pulumi.Input['ConnectorAs2ConfigPropertiesSigningAlgorithm']]
        """
        Signing algorithm for this AS2 connector configuration.
        """
elif False:
    As2ConfigPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class As2ConfigPropertiesArgs:
    def __init__(__self__, *,
                 basic_auth_secret_id: Optional[pulumi.Input[str]] = None,
                 compression: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesCompression']] = None,
                 encryption_algorithm: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesEncryptionAlgorithm']] = None,
                 local_profile_id: Optional[pulumi.Input[str]] = None,
                 mdn_response: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesMdnResponse']] = None,
                 mdn_signing_algorithm: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesMdnSigningAlgorithm']] = None,
                 message_subject: Optional[pulumi.Input[str]] = None,
                 partner_profile_id: Optional[pulumi.Input[str]] = None,
                 signing_algorithm: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesSigningAlgorithm']] = None):
        """
        Configuration for an AS2 connector.
        :param pulumi.Input[str] basic_auth_secret_id: ARN or name of the secret in AWS Secrets Manager which contains the credentials for Basic authentication. If empty, Basic authentication is disabled for the AS2 connector
        :param pulumi.Input['ConnectorAs2ConfigPropertiesCompression'] compression: Compression setting for this AS2 connector configuration.
        :param pulumi.Input['ConnectorAs2ConfigPropertiesEncryptionAlgorithm'] encryption_algorithm: Encryption algorithm for this AS2 connector configuration.
        :param pulumi.Input[str] local_profile_id: A unique identifier for the local profile.
        :param pulumi.Input['ConnectorAs2ConfigPropertiesMdnResponse'] mdn_response: MDN Response setting for this AS2 connector configuration.
        :param pulumi.Input['ConnectorAs2ConfigPropertiesMdnSigningAlgorithm'] mdn_signing_algorithm: MDN Signing algorithm for this AS2 connector configuration.
        :param pulumi.Input[str] message_subject: The message subject for this AS2 connector configuration.
        :param pulumi.Input[str] partner_profile_id: A unique identifier for the partner profile.
        :param pulumi.Input['ConnectorAs2ConfigPropertiesSigningAlgorithm'] signing_algorithm: Signing algorithm for this AS2 connector configuration.
        """
        if basic_auth_secret_id is not None:
            pulumi.set(__self__, "basic_auth_secret_id", basic_auth_secret_id)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        if local_profile_id is not None:
            pulumi.set(__self__, "local_profile_id", local_profile_id)
        if mdn_response is not None:
            pulumi.set(__self__, "mdn_response", mdn_response)
        if mdn_signing_algorithm is not None:
            pulumi.set(__self__, "mdn_signing_algorithm", mdn_signing_algorithm)
        if message_subject is not None:
            pulumi.set(__self__, "message_subject", message_subject)
        if partner_profile_id is not None:
            pulumi.set(__self__, "partner_profile_id", partner_profile_id)
        if signing_algorithm is not None:
            pulumi.set(__self__, "signing_algorithm", signing_algorithm)

    @property
    @pulumi.getter(name="basicAuthSecretId")
    def basic_auth_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN or name of the secret in AWS Secrets Manager which contains the credentials for Basic authentication. If empty, Basic authentication is disabled for the AS2 connector
        """
        return pulumi.get(self, "basic_auth_secret_id")

    @basic_auth_secret_id.setter
    def basic_auth_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "basic_auth_secret_id", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input['ConnectorAs2ConfigPropertiesCompression']]:
        """
        Compression setting for this AS2 connector configuration.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesCompression']]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional[pulumi.Input['ConnectorAs2ConfigPropertiesEncryptionAlgorithm']]:
        """
        Encryption algorithm for this AS2 connector configuration.
        """
        return pulumi.get(self, "encryption_algorithm")

    @encryption_algorithm.setter
    def encryption_algorithm(self, value: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesEncryptionAlgorithm']]):
        pulumi.set(self, "encryption_algorithm", value)

    @property
    @pulumi.getter(name="localProfileId")
    def local_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for the local profile.
        """
        return pulumi.get(self, "local_profile_id")

    @local_profile_id.setter
    def local_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_profile_id", value)

    @property
    @pulumi.getter(name="mdnResponse")
    def mdn_response(self) -> Optional[pulumi.Input['ConnectorAs2ConfigPropertiesMdnResponse']]:
        """
        MDN Response setting for this AS2 connector configuration.
        """
        return pulumi.get(self, "mdn_response")

    @mdn_response.setter
    def mdn_response(self, value: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesMdnResponse']]):
        pulumi.set(self, "mdn_response", value)

    @property
    @pulumi.getter(name="mdnSigningAlgorithm")
    def mdn_signing_algorithm(self) -> Optional[pulumi.Input['ConnectorAs2ConfigPropertiesMdnSigningAlgorithm']]:
        """
        MDN Signing algorithm for this AS2 connector configuration.
        """
        return pulumi.get(self, "mdn_signing_algorithm")

    @mdn_signing_algorithm.setter
    def mdn_signing_algorithm(self, value: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesMdnSigningAlgorithm']]):
        pulumi.set(self, "mdn_signing_algorithm", value)

    @property
    @pulumi.getter(name="messageSubject")
    def message_subject(self) -> Optional[pulumi.Input[str]]:
        """
        The message subject for this AS2 connector configuration.
        """
        return pulumi.get(self, "message_subject")

    @message_subject.setter
    def message_subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_subject", value)

    @property
    @pulumi.getter(name="partnerProfileId")
    def partner_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique identifier for the partner profile.
        """
        return pulumi.get(self, "partner_profile_id")

    @partner_profile_id.setter
    def partner_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partner_profile_id", value)

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> Optional[pulumi.Input['ConnectorAs2ConfigPropertiesSigningAlgorithm']]:
        """
        Signing algorithm for this AS2 connector configuration.
        """
        return pulumi.get(self, "signing_algorithm")

    @signing_algorithm.setter
    def signing_algorithm(self, value: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesSigningAlgorithm']]):
        pulumi.set(self, "signing_algorithm", value)


if not MYPY:
    class SftpConfigPropertiesArgsDict(TypedDict):
        """
        Configuration for an SFTP connector.
        """
        trusted_host_keys: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        List of public host keys, for the external server to which you are connecting.
        """
        user_secret_id: NotRequired[pulumi.Input[str]]
        """
        ARN or name of the secret in AWS Secrets Manager which contains the SFTP user's private keys or passwords.
        """
elif False:
    SftpConfigPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SftpConfigPropertiesArgs:
    def __init__(__self__, *,
                 trusted_host_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_secret_id: Optional[pulumi.Input[str]] = None):
        """
        Configuration for an SFTP connector.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] trusted_host_keys: List of public host keys, for the external server to which you are connecting.
        :param pulumi.Input[str] user_secret_id: ARN or name of the secret in AWS Secrets Manager which contains the SFTP user's private keys or passwords.
        """
        if trusted_host_keys is not None:
            pulumi.set(__self__, "trusted_host_keys", trusted_host_keys)
        if user_secret_id is not None:
            pulumi.set(__self__, "user_secret_id", user_secret_id)

    @property
    @pulumi.getter(name="trustedHostKeys")
    def trusted_host_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of public host keys, for the external server to which you are connecting.
        """
        return pulumi.get(self, "trusted_host_keys")

    @trusted_host_keys.setter
    def trusted_host_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "trusted_host_keys", value)

    @property
    @pulumi.getter(name="userSecretId")
    def user_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        ARN or name of the secret in AWS Secrets Manager which contains the SFTP user's private keys or passwords.
        """
        return pulumi.get(self, "user_secret_id")

    @user_secret_id.setter
    def user_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_secret_id", value)


if not MYPY:
    class WorkflowEfsInputFileLocationArgsDict(TypedDict):
        """
        Specifies the details for an EFS file.
        """
        file_system_id: NotRequired[pulumi.Input[str]]
        """
        Specifies the EFS filesystem that contains the file.
        """
        path: NotRequired[pulumi.Input[str]]
        """
        The name assigned to the file when it was created in EFS. You use the object path to retrieve the object.
        """
elif False:
    WorkflowEfsInputFileLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowEfsInputFileLocationArgs:
    def __init__(__self__, *,
                 file_system_id: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        Specifies the details for an EFS file.
        :param pulumi.Input[str] file_system_id: Specifies the EFS filesystem that contains the file.
        :param pulumi.Input[str] path: The name assigned to the file when it was created in EFS. You use the object path to retrieve the object.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the EFS filesystem that contains the file.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The name assigned to the file when it was created in EFS. You use the object path to retrieve the object.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


if not MYPY:
    class WorkflowInputFileLocationArgsDict(TypedDict):
        """
        Specifies the location for the file being decrypted. Only applicable for the Decrypt type of workflow steps.
        """
        efs_file_location: NotRequired[pulumi.Input['WorkflowEfsInputFileLocationArgsDict']]
        s3_file_location: NotRequired[pulumi.Input['WorkflowS3InputFileLocationArgsDict']]
elif False:
    WorkflowInputFileLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowInputFileLocationArgs:
    def __init__(__self__, *,
                 efs_file_location: Optional[pulumi.Input['WorkflowEfsInputFileLocationArgs']] = None,
                 s3_file_location: Optional[pulumi.Input['WorkflowS3InputFileLocationArgs']] = None):
        """
        Specifies the location for the file being decrypted. Only applicable for the Decrypt type of workflow steps.
        """
        if efs_file_location is not None:
            pulumi.set(__self__, "efs_file_location", efs_file_location)
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="efsFileLocation")
    def efs_file_location(self) -> Optional[pulumi.Input['WorkflowEfsInputFileLocationArgs']]:
        return pulumi.get(self, "efs_file_location")

    @efs_file_location.setter
    def efs_file_location(self, value: Optional[pulumi.Input['WorkflowEfsInputFileLocationArgs']]):
        pulumi.set(self, "efs_file_location", value)

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional[pulumi.Input['WorkflowS3InputFileLocationArgs']]:
        return pulumi.get(self, "s3_file_location")

    @s3_file_location.setter
    def s3_file_location(self, value: Optional[pulumi.Input['WorkflowS3InputFileLocationArgs']]):
        pulumi.set(self, "s3_file_location", value)


if not MYPY:
    class WorkflowS3FileLocationArgsDict(TypedDict):
        """
        Specifies the location for the file being copied. Only applicable for the Copy type of workflow steps.
        """
        s3_file_location: NotRequired[pulumi.Input['WorkflowS3InputFileLocationArgsDict']]
        """
        Specifies the details for the file location for the file that's being used in the workflow. Only applicable if you are using Amazon S3 storage.
        """
elif False:
    WorkflowS3FileLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowS3FileLocationArgs:
    def __init__(__self__, *,
                 s3_file_location: Optional[pulumi.Input['WorkflowS3InputFileLocationArgs']] = None):
        """
        Specifies the location for the file being copied. Only applicable for the Copy type of workflow steps.
        :param pulumi.Input['WorkflowS3InputFileLocationArgs'] s3_file_location: Specifies the details for the file location for the file that's being used in the workflow. Only applicable if you are using Amazon S3 storage.
        """
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional[pulumi.Input['WorkflowS3InputFileLocationArgs']]:
        """
        Specifies the details for the file location for the file that's being used in the workflow. Only applicable if you are using Amazon S3 storage.
        """
        return pulumi.get(self, "s3_file_location")

    @s3_file_location.setter
    def s3_file_location(self, value: Optional[pulumi.Input['WorkflowS3InputFileLocationArgs']]):
        pulumi.set(self, "s3_file_location", value)


if not MYPY:
    class WorkflowS3InputFileLocationArgsDict(TypedDict):
        """
        Specifies the details for a S3 file.
        """
        bucket: NotRequired[pulumi.Input[str]]
        """
        Specifies the S3 bucket that contains the file.
        """
        key: NotRequired[pulumi.Input[str]]
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
elif False:
    WorkflowS3InputFileLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowS3InputFileLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None):
        """
        Specifies the details for a S3 file.
        :param pulumi.Input[str] bucket: Specifies the S3 bucket that contains the file.
        :param pulumi.Input[str] key: The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the S3 bucket that contains the file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


if not MYPY:
    class WorkflowS3TagArgsDict(TypedDict):
        """
        Specifies the key-value pair that are assigned to a file during the execution of a Tagging step.
        """
        key: pulumi.Input[str]
        """
        The name assigned to the tag that you create.
        """
        value: pulumi.Input[str]
        """
        The value that corresponds to the key.
        """
elif False:
    WorkflowS3TagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowS3TagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Specifies the key-value pair that are assigned to a file during the execution of a Tagging step.
        :param pulumi.Input[str] key: The name assigned to the tag that you create.
        :param pulumi.Input[str] value: The value that corresponds to the key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The name assigned to the tag that you create.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value that corresponds to the key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class WorkflowStepCopyStepDetailsPropertiesArgsDict(TypedDict):
        """
        Details for a step that performs a file copy.
        """
        destination_file_location: NotRequired[pulumi.Input['WorkflowS3FileLocationArgsDict']]
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the step, used as an identifier.
        """
        overwrite_existing: NotRequired[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesOverwriteExisting']]
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        """
        source_file_location: NotRequired[pulumi.Input[str]]
        """
        Specifies which file to use as input to the workflow step.
        """
elif False:
    WorkflowStepCopyStepDetailsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowStepCopyStepDetailsPropertiesArgs:
    def __init__(__self__, *,
                 destination_file_location: Optional[pulumi.Input['WorkflowS3FileLocationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 overwrite_existing: Optional[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesOverwriteExisting']] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None):
        """
        Details for a step that performs a file copy.
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input['WorkflowStepCopyStepDetailsPropertiesOverwriteExisting'] overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step.
        """
        if destination_file_location is not None:
            pulumi.set(__self__, "destination_file_location", destination_file_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> Optional[pulumi.Input['WorkflowS3FileLocationArgs']]:
        return pulumi.get(self, "destination_file_location")

    @destination_file_location.setter
    def destination_file_location(self, value: Optional[pulumi.Input['WorkflowS3FileLocationArgs']]):
        pulumi.set(self, "destination_file_location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesOverwriteExisting']]:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        """
        return pulumi.get(self, "overwrite_existing")

    @overwrite_existing.setter
    def overwrite_existing(self, value: Optional[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesOverwriteExisting']]):
        pulumi.set(self, "overwrite_existing", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)


if not MYPY:
    class WorkflowStepCustomStepDetailsPropertiesArgsDict(TypedDict):
        """
        Details for a step that invokes a lambda function.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the step, used as an identifier.
        """
        source_file_location: NotRequired[pulumi.Input[str]]
        """
        Specifies which file to use as input to the workflow step.
        """
        target: NotRequired[pulumi.Input[str]]
        """
        The ARN for the lambda function that is being called.
        """
        timeout_seconds: NotRequired[pulumi.Input[int]]
        """
        Timeout, in seconds, for the step.
        """
elif False:
    WorkflowStepCustomStepDetailsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowStepCustomStepDetailsPropertiesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        Details for a step that invokes a lambda function.
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step.
        :param pulumi.Input[str] target: The ARN for the lambda function that is being called.
        :param pulumi.Input[int] timeout_seconds: Timeout, in seconds, for the step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN for the lambda function that is being called.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Timeout, in seconds, for the step.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


if not MYPY:
    class WorkflowStepDecryptStepDetailsPropertiesArgsDict(TypedDict):
        """
        Details for a step that performs a file decryption.
        """
        destination_file_location: pulumi.Input['WorkflowInputFileLocationArgsDict']
        type: pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesType']
        """
        Specifies which encryption method to use.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the step, used as an identifier.
        """
        overwrite_existing: NotRequired[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting']]
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        """
        source_file_location: NotRequired[pulumi.Input[str]]
        """
        Specifies which file to use as input to the workflow step.
        """
elif False:
    WorkflowStepDecryptStepDetailsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowStepDecryptStepDetailsPropertiesArgs:
    def __init__(__self__, *,
                 destination_file_location: pulumi.Input['WorkflowInputFileLocationArgs'],
                 type: pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesType'],
                 name: Optional[pulumi.Input[str]] = None,
                 overwrite_existing: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting']] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None):
        """
        Details for a step that performs a file decryption.
        :param pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesType'] type: Specifies which encryption method to use.
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting'] overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step.
        """
        pulumi.set(__self__, "destination_file_location", destination_file_location)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> pulumi.Input['WorkflowInputFileLocationArgs']:
        return pulumi.get(self, "destination_file_location")

    @destination_file_location.setter
    def destination_file_location(self, value: pulumi.Input['WorkflowInputFileLocationArgs']):
        pulumi.set(self, "destination_file_location", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesType']:
        """
        Specifies which encryption method to use.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting']]:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        """
        return pulumi.get(self, "overwrite_existing")

    @overwrite_existing.setter
    def overwrite_existing(self, value: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting']]):
        pulumi.set(self, "overwrite_existing", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)


if not MYPY:
    class WorkflowStepDeleteStepDetailsPropertiesArgsDict(TypedDict):
        """
        Details for a step that deletes the file.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the step, used as an identifier.
        """
        source_file_location: NotRequired[pulumi.Input[str]]
        """
        Specifies which file to use as input to the workflow step.
        """
elif False:
    WorkflowStepDeleteStepDetailsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowStepDeleteStepDetailsPropertiesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None):
        """
        Details for a step that deletes the file.
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)


if not MYPY:
    class WorkflowStepTagStepDetailsPropertiesArgsDict(TypedDict):
        """
        Details for a step that creates one or more tags.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the step, used as an identifier.
        """
        source_file_location: NotRequired[pulumi.Input[str]]
        """
        Specifies which file to use as input to the workflow step.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['WorkflowS3TagArgsDict']]]]
        """
        Array that contains from 1 to 10 key/value pairs.
        """
elif False:
    WorkflowStepTagStepDetailsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowStepTagStepDetailsPropertiesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 source_file_location: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowS3TagArgs']]]] = None):
        """
        Details for a step that creates one or more tags.
        :param pulumi.Input[str] name: The name of the step, used as an identifier.
        :param pulumi.Input[str] source_file_location: Specifies which file to use as input to the workflow step.
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowS3TagArgs']]] tags: Array that contains from 1 to 10 key/value pairs.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_file_location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowS3TagArgs']]]]:
        """
        Array that contains from 1 to 10 key/value pairs.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowS3TagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class WorkflowStepArgsDict(TypedDict):
        """
        The basic building block of a workflow.
        """
        copy_step_details: NotRequired[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesArgsDict']]
        """
        Details for a step that performs a file copy.
        """
        custom_step_details: NotRequired[pulumi.Input['WorkflowStepCustomStepDetailsPropertiesArgsDict']]
        """
        Details for a step that invokes a lambda function.
        """
        decrypt_step_details: NotRequired[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesArgsDict']]
        """
        Details for a step that performs a file decryption.
        """
        delete_step_details: NotRequired[pulumi.Input['WorkflowStepDeleteStepDetailsPropertiesArgsDict']]
        """
        Details for a step that deletes the file.
        """
        tag_step_details: NotRequired[pulumi.Input['WorkflowStepTagStepDetailsPropertiesArgsDict']]
        """
        Details for a step that creates one or more tags.
        """
        type: NotRequired[pulumi.Input['WorkflowStepType']]
elif False:
    WorkflowStepArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowStepArgs:
    def __init__(__self__, *,
                 copy_step_details: Optional[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesArgs']] = None,
                 custom_step_details: Optional[pulumi.Input['WorkflowStepCustomStepDetailsPropertiesArgs']] = None,
                 decrypt_step_details: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesArgs']] = None,
                 delete_step_details: Optional[pulumi.Input['WorkflowStepDeleteStepDetailsPropertiesArgs']] = None,
                 tag_step_details: Optional[pulumi.Input['WorkflowStepTagStepDetailsPropertiesArgs']] = None,
                 type: Optional[pulumi.Input['WorkflowStepType']] = None):
        """
        The basic building block of a workflow.
        :param pulumi.Input['WorkflowStepCopyStepDetailsPropertiesArgs'] copy_step_details: Details for a step that performs a file copy.
        :param pulumi.Input['WorkflowStepCustomStepDetailsPropertiesArgs'] custom_step_details: Details for a step that invokes a lambda function.
        :param pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesArgs'] decrypt_step_details: Details for a step that performs a file decryption.
        :param pulumi.Input['WorkflowStepDeleteStepDetailsPropertiesArgs'] delete_step_details: Details for a step that deletes the file.
        :param pulumi.Input['WorkflowStepTagStepDetailsPropertiesArgs'] tag_step_details: Details for a step that creates one or more tags.
        """
        if copy_step_details is not None:
            pulumi.set(__self__, "copy_step_details", copy_step_details)
        if custom_step_details is not None:
            pulumi.set(__self__, "custom_step_details", custom_step_details)
        if decrypt_step_details is not None:
            pulumi.set(__self__, "decrypt_step_details", decrypt_step_details)
        if delete_step_details is not None:
            pulumi.set(__self__, "delete_step_details", delete_step_details)
        if tag_step_details is not None:
            pulumi.set(__self__, "tag_step_details", tag_step_details)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="copyStepDetails")
    def copy_step_details(self) -> Optional[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesArgs']]:
        """
        Details for a step that performs a file copy.
        """
        return pulumi.get(self, "copy_step_details")

    @copy_step_details.setter
    def copy_step_details(self, value: Optional[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesArgs']]):
        pulumi.set(self, "copy_step_details", value)

    @property
    @pulumi.getter(name="customStepDetails")
    def custom_step_details(self) -> Optional[pulumi.Input['WorkflowStepCustomStepDetailsPropertiesArgs']]:
        """
        Details for a step that invokes a lambda function.
        """
        return pulumi.get(self, "custom_step_details")

    @custom_step_details.setter
    def custom_step_details(self, value: Optional[pulumi.Input['WorkflowStepCustomStepDetailsPropertiesArgs']]):
        pulumi.set(self, "custom_step_details", value)

    @property
    @pulumi.getter(name="decryptStepDetails")
    def decrypt_step_details(self) -> Optional[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesArgs']]:
        """
        Details for a step that performs a file decryption.
        """
        return pulumi.get(self, "decrypt_step_details")

    @decrypt_step_details.setter
    def decrypt_step_details(self, value: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesArgs']]):
        pulumi.set(self, "decrypt_step_details", value)

    @property
    @pulumi.getter(name="deleteStepDetails")
    def delete_step_details(self) -> Optional[pulumi.Input['WorkflowStepDeleteStepDetailsPropertiesArgs']]:
        """
        Details for a step that deletes the file.
        """
        return pulumi.get(self, "delete_step_details")

    @delete_step_details.setter
    def delete_step_details(self, value: Optional[pulumi.Input['WorkflowStepDeleteStepDetailsPropertiesArgs']]):
        pulumi.set(self, "delete_step_details", value)

    @property
    @pulumi.getter(name="tagStepDetails")
    def tag_step_details(self) -> Optional[pulumi.Input['WorkflowStepTagStepDetailsPropertiesArgs']]:
        """
        Details for a step that creates one or more tags.
        """
        return pulumi.get(self, "tag_step_details")

    @tag_step_details.setter
    def tag_step_details(self, value: Optional[pulumi.Input['WorkflowStepTagStepDetailsPropertiesArgs']]):
        pulumi.set(self, "tag_step_details", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['WorkflowStepType']]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['WorkflowStepType']]):
        pulumi.set(self, "type", value)


