# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ScheduledQueryArgs', 'ScheduledQuery']

@pulumi.input_type
class ScheduledQueryArgs:
    def __init__(__self__, *,
                 error_report_configuration: pulumi.Input['ScheduledQueryErrorReportConfigurationArgs'],
                 notification_configuration: pulumi.Input['ScheduledQueryNotificationConfigurationArgs'],
                 query_string: pulumi.Input[str],
                 schedule_configuration: pulumi.Input['ScheduledQueryScheduleConfigurationArgs'],
                 scheduled_query_execution_role_arn: pulumi.Input[str],
                 client_token: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 scheduled_query_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 target_configuration: Optional[pulumi.Input['ScheduledQueryTargetConfigurationArgs']] = None):
        """
        The set of arguments for constructing a ScheduledQuery resource.
        :param pulumi.Input['ScheduledQueryErrorReportConfigurationArgs'] error_report_configuration: Configuration for error reporting. Error reports will be generated when a problem is encountered when writing the query results.
        :param pulumi.Input['ScheduledQueryNotificationConfigurationArgs'] notification_configuration: Notification configuration for the scheduled query. A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
        :param pulumi.Input[str] query_string: The query string to run. Parameter names can be specified in the query string `@` character followed by an identifier. The named Parameter `@scheduled_runtime` is reserved and can be used in the query to get the time at which the query is scheduled to run.
               
               The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of `@scheduled_runtime` paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the `@scheduled_runtime` parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
        :param pulumi.Input['ScheduledQueryScheduleConfigurationArgs'] schedule_configuration: Schedule configuration.
        :param pulumi.Input[str] scheduled_query_execution_role_arn: The ARN for the IAM role that Timestream will assume when running the scheduled query.
        :param pulumi.Input[str] client_token: Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same request repeatedly will produce the same result. Making multiple identical CreateScheduledQuery requests has the same effect as making a single request.
               
               - If CreateScheduledQuery is called without a `ClientToken` , the Query SDK generates a `ClientToken` on your behalf.
               - After 8 hours, any request with the same `ClientToken` is treated as a new request.
        :param pulumi.Input[str] kms_key_id: The Amazon KMS key used to encrypt the scheduled query resource, at-rest. If the Amazon KMS key is not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with *alias/*
               
               If ErrorReportConfiguration uses `SSE_KMS` as encryption type, the same KmsKeyId is used to encrypt the error report at rest.
        :param pulumi.Input[str] scheduled_query_name: A name for the query. Scheduled query names must be unique within each Region.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of key-value pairs to label the scheduled query.
        :param pulumi.Input['ScheduledQueryTargetConfigurationArgs'] target_configuration: Scheduled query target store configuration.
        """
        pulumi.set(__self__, "error_report_configuration", error_report_configuration)
        pulumi.set(__self__, "notification_configuration", notification_configuration)
        pulumi.set(__self__, "query_string", query_string)
        pulumi.set(__self__, "schedule_configuration", schedule_configuration)
        pulumi.set(__self__, "scheduled_query_execution_role_arn", scheduled_query_execution_role_arn)
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if scheduled_query_name is not None:
            pulumi.set(__self__, "scheduled_query_name", scheduled_query_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_configuration is not None:
            pulumi.set(__self__, "target_configuration", target_configuration)

    @property
    @pulumi.getter(name="errorReportConfiguration")
    def error_report_configuration(self) -> pulumi.Input['ScheduledQueryErrorReportConfigurationArgs']:
        """
        Configuration for error reporting. Error reports will be generated when a problem is encountered when writing the query results.
        """
        return pulumi.get(self, "error_report_configuration")

    @error_report_configuration.setter
    def error_report_configuration(self, value: pulumi.Input['ScheduledQueryErrorReportConfigurationArgs']):
        pulumi.set(self, "error_report_configuration", value)

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> pulumi.Input['ScheduledQueryNotificationConfigurationArgs']:
        """
        Notification configuration for the scheduled query. A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
        """
        return pulumi.get(self, "notification_configuration")

    @notification_configuration.setter
    def notification_configuration(self, value: pulumi.Input['ScheduledQueryNotificationConfigurationArgs']):
        pulumi.set(self, "notification_configuration", value)

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Input[str]:
        """
        The query string to run. Parameter names can be specified in the query string `@` character followed by an identifier. The named Parameter `@scheduled_runtime` is reserved and can be used in the query to get the time at which the query is scheduled to run.

        The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of `@scheduled_runtime` paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the `@scheduled_runtime` parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: pulumi.Input[str]):
        pulumi.set(self, "query_string", value)

    @property
    @pulumi.getter(name="scheduleConfiguration")
    def schedule_configuration(self) -> pulumi.Input['ScheduledQueryScheduleConfigurationArgs']:
        """
        Schedule configuration.
        """
        return pulumi.get(self, "schedule_configuration")

    @schedule_configuration.setter
    def schedule_configuration(self, value: pulumi.Input['ScheduledQueryScheduleConfigurationArgs']):
        pulumi.set(self, "schedule_configuration", value)

    @property
    @pulumi.getter(name="scheduledQueryExecutionRoleArn")
    def scheduled_query_execution_role_arn(self) -> pulumi.Input[str]:
        """
        The ARN for the IAM role that Timestream will assume when running the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_execution_role_arn")

    @scheduled_query_execution_role_arn.setter
    def scheduled_query_execution_role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "scheduled_query_execution_role_arn", value)

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[str]]:
        """
        Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same request repeatedly will produce the same result. Making multiple identical CreateScheduledQuery requests has the same effect as making a single request.

        - If CreateScheduledQuery is called without a `ClientToken` , the Query SDK generates a `ClientToken` on your behalf.
        - After 8 hours, any request with the same `ClientToken` is treated as a new request.
        """
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_token", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon KMS key used to encrypt the scheduled query resource, at-rest. If the Amazon KMS key is not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with *alias/*

        If ErrorReportConfiguration uses `SSE_KMS` as encryption type, the same KmsKeyId is used to encrypt the error report at rest.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="scheduledQueryName")
    def scheduled_query_name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the query. Scheduled query names must be unique within each Region.
        """
        return pulumi.get(self, "scheduled_query_name")

    @scheduled_query_name.setter
    def scheduled_query_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_query_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of key-value pairs to label the scheduled query.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> Optional[pulumi.Input['ScheduledQueryTargetConfigurationArgs']]:
        """
        Scheduled query target store configuration.
        """
        return pulumi.get(self, "target_configuration")

    @target_configuration.setter
    def target_configuration(self, value: Optional[pulumi.Input['ScheduledQueryTargetConfigurationArgs']]):
        pulumi.set(self, "target_configuration", value)


class ScheduledQuery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 error_report_configuration: Optional[pulumi.Input[Union['ScheduledQueryErrorReportConfigurationArgs', 'ScheduledQueryErrorReportConfigurationArgsDict']]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 notification_configuration: Optional[pulumi.Input[Union['ScheduledQueryNotificationConfigurationArgs', 'ScheduledQueryNotificationConfigurationArgsDict']]] = None,
                 query_string: Optional[pulumi.Input[str]] = None,
                 schedule_configuration: Optional[pulumi.Input[Union['ScheduledQueryScheduleConfigurationArgs', 'ScheduledQueryScheduleConfigurationArgsDict']]] = None,
                 scheduled_query_execution_role_arn: Optional[pulumi.Input[str]] = None,
                 scheduled_query_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 target_configuration: Optional[pulumi.Input[Union['ScheduledQueryTargetConfigurationArgs', 'ScheduledQueryTargetConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        The AWS::Timestream::ScheduledQuery resource creates a Timestream Scheduled Query.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_token: Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same request repeatedly will produce the same result. Making multiple identical CreateScheduledQuery requests has the same effect as making a single request.
               
               - If CreateScheduledQuery is called without a `ClientToken` , the Query SDK generates a `ClientToken` on your behalf.
               - After 8 hours, any request with the same `ClientToken` is treated as a new request.
        :param pulumi.Input[Union['ScheduledQueryErrorReportConfigurationArgs', 'ScheduledQueryErrorReportConfigurationArgsDict']] error_report_configuration: Configuration for error reporting. Error reports will be generated when a problem is encountered when writing the query results.
        :param pulumi.Input[str] kms_key_id: The Amazon KMS key used to encrypt the scheduled query resource, at-rest. If the Amazon KMS key is not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with *alias/*
               
               If ErrorReportConfiguration uses `SSE_KMS` as encryption type, the same KmsKeyId is used to encrypt the error report at rest.
        :param pulumi.Input[Union['ScheduledQueryNotificationConfigurationArgs', 'ScheduledQueryNotificationConfigurationArgsDict']] notification_configuration: Notification configuration for the scheduled query. A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
        :param pulumi.Input[str] query_string: The query string to run. Parameter names can be specified in the query string `@` character followed by an identifier. The named Parameter `@scheduled_runtime` is reserved and can be used in the query to get the time at which the query is scheduled to run.
               
               The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of `@scheduled_runtime` paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the `@scheduled_runtime` parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
        :param pulumi.Input[Union['ScheduledQueryScheduleConfigurationArgs', 'ScheduledQueryScheduleConfigurationArgsDict']] schedule_configuration: Schedule configuration.
        :param pulumi.Input[str] scheduled_query_execution_role_arn: The ARN for the IAM role that Timestream will assume when running the scheduled query.
        :param pulumi.Input[str] scheduled_query_name: A name for the query. Scheduled query names must be unique within each Region.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of key-value pairs to label the scheduled query.
        :param pulumi.Input[Union['ScheduledQueryTargetConfigurationArgs', 'ScheduledQueryTargetConfigurationArgsDict']] target_configuration: Scheduled query target store configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduledQueryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::Timestream::ScheduledQuery resource creates a Timestream Scheduled Query.

        :param str resource_name: The name of the resource.
        :param ScheduledQueryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduledQueryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 error_report_configuration: Optional[pulumi.Input[Union['ScheduledQueryErrorReportConfigurationArgs', 'ScheduledQueryErrorReportConfigurationArgsDict']]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 notification_configuration: Optional[pulumi.Input[Union['ScheduledQueryNotificationConfigurationArgs', 'ScheduledQueryNotificationConfigurationArgsDict']]] = None,
                 query_string: Optional[pulumi.Input[str]] = None,
                 schedule_configuration: Optional[pulumi.Input[Union['ScheduledQueryScheduleConfigurationArgs', 'ScheduledQueryScheduleConfigurationArgsDict']]] = None,
                 scheduled_query_execution_role_arn: Optional[pulumi.Input[str]] = None,
                 scheduled_query_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 target_configuration: Optional[pulumi.Input[Union['ScheduledQueryTargetConfigurationArgs', 'ScheduledQueryTargetConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduledQueryArgs.__new__(ScheduledQueryArgs)

            __props__.__dict__["client_token"] = client_token
            if error_report_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'error_report_configuration'")
            __props__.__dict__["error_report_configuration"] = error_report_configuration
            __props__.__dict__["kms_key_id"] = kms_key_id
            if notification_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'notification_configuration'")
            __props__.__dict__["notification_configuration"] = notification_configuration
            if query_string is None and not opts.urn:
                raise TypeError("Missing required property 'query_string'")
            __props__.__dict__["query_string"] = query_string
            if schedule_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'schedule_configuration'")
            __props__.__dict__["schedule_configuration"] = schedule_configuration
            if scheduled_query_execution_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'scheduled_query_execution_role_arn'")
            __props__.__dict__["scheduled_query_execution_role_arn"] = scheduled_query_execution_role_arn
            __props__.__dict__["scheduled_query_name"] = scheduled_query_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_configuration"] = target_configuration
            __props__.__dict__["arn"] = None
            __props__.__dict__["sq_error_report_configuration"] = None
            __props__.__dict__["sq_kms_key_id"] = None
            __props__.__dict__["sq_name"] = None
            __props__.__dict__["sq_notification_configuration"] = None
            __props__.__dict__["sq_query_string"] = None
            __props__.__dict__["sq_schedule_configuration"] = None
            __props__.__dict__["sq_scheduled_query_execution_role_arn"] = None
            __props__.__dict__["sq_target_configuration"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["clientToken", "errorReportConfiguration", "kmsKeyId", "notificationConfiguration", "queryString", "scheduleConfiguration", "scheduledQueryExecutionRoleArn", "scheduledQueryName", "targetConfiguration"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ScheduledQuery, __self__).__init__(
            'aws-native:timestream:ScheduledQuery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ScheduledQuery':
        """
        Get an existing ScheduledQuery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ScheduledQueryArgs.__new__(ScheduledQueryArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["client_token"] = None
        __props__.__dict__["error_report_configuration"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["notification_configuration"] = None
        __props__.__dict__["query_string"] = None
        __props__.__dict__["schedule_configuration"] = None
        __props__.__dict__["scheduled_query_execution_role_arn"] = None
        __props__.__dict__["scheduled_query_name"] = None
        __props__.__dict__["sq_error_report_configuration"] = None
        __props__.__dict__["sq_kms_key_id"] = None
        __props__.__dict__["sq_name"] = None
        __props__.__dict__["sq_notification_configuration"] = None
        __props__.__dict__["sq_query_string"] = None
        __props__.__dict__["sq_schedule_configuration"] = None
        __props__.__dict__["sq_scheduled_query_execution_role_arn"] = None
        __props__.__dict__["sq_target_configuration"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["target_configuration"] = None
        return ScheduledQuery(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The `ARN` of the scheduled query.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> pulumi.Output[Optional[str]]:
        """
        Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same request repeatedly will produce the same result. Making multiple identical CreateScheduledQuery requests has the same effect as making a single request.

        - If CreateScheduledQuery is called without a `ClientToken` , the Query SDK generates a `ClientToken` on your behalf.
        - After 8 hours, any request with the same `ClientToken` is treated as a new request.
        """
        return pulumi.get(self, "client_token")

    @property
    @pulumi.getter(name="errorReportConfiguration")
    def error_report_configuration(self) -> pulumi.Output['outputs.ScheduledQueryErrorReportConfiguration']:
        """
        Configuration for error reporting. Error reports will be generated when a problem is encountered when writing the query results.
        """
        return pulumi.get(self, "error_report_configuration")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon KMS key used to encrypt the scheduled query resource, at-rest. If the Amazon KMS key is not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with *alias/*

        If ErrorReportConfiguration uses `SSE_KMS` as encryption type, the same KmsKeyId is used to encrypt the error report at rest.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="notificationConfiguration")
    def notification_configuration(self) -> pulumi.Output['outputs.ScheduledQueryNotificationConfiguration']:
        """
        Notification configuration for the scheduled query. A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
        """
        return pulumi.get(self, "notification_configuration")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Output[str]:
        """
        The query string to run. Parameter names can be specified in the query string `@` character followed by an identifier. The named Parameter `@scheduled_runtime` is reserved and can be used in the query to get the time at which the query is scheduled to run.

        The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of `@scheduled_runtime` paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the `@scheduled_runtime` parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
        """
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter(name="scheduleConfiguration")
    def schedule_configuration(self) -> pulumi.Output['outputs.ScheduledQueryScheduleConfiguration']:
        """
        Schedule configuration.
        """
        return pulumi.get(self, "schedule_configuration")

    @property
    @pulumi.getter(name="scheduledQueryExecutionRoleArn")
    def scheduled_query_execution_role_arn(self) -> pulumi.Output[str]:
        """
        The ARN for the IAM role that Timestream will assume when running the scheduled query.
        """
        return pulumi.get(self, "scheduled_query_execution_role_arn")

    @property
    @pulumi.getter(name="scheduledQueryName")
    def scheduled_query_name(self) -> pulumi.Output[Optional[str]]:
        """
        A name for the query. Scheduled query names must be unique within each Region.
        """
        return pulumi.get(self, "scheduled_query_name")

    @property
    @pulumi.getter(name="sqErrorReportConfiguration")
    def sq_error_report_configuration(self) -> pulumi.Output[str]:
        """
        Configuration for error reporting. Error reports will be generated when a problem is encountered when writing the query results.
        """
        return pulumi.get(self, "sq_error_report_configuration")

    @property
    @pulumi.getter(name="sqKmsKeyId")
    def sq_kms_key_id(self) -> pulumi.Output[str]:
        """
        The Amazon KMS key used to encrypt the scheduled query resource, at-rest. If the Amazon KMS key is not specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with alias/. If ErrorReportConfiguration uses SSE_KMS as encryption type, the same KmsKeyId is used to encrypt the error report at rest.
        """
        return pulumi.get(self, "sq_kms_key_id")

    @property
    @pulumi.getter(name="sqName")
    def sq_name(self) -> pulumi.Output[str]:
        """
        The name of the scheduled query. Scheduled query names must be unique within each Region.
        """
        return pulumi.get(self, "sq_name")

    @property
    @pulumi.getter(name="sqNotificationConfiguration")
    def sq_notification_configuration(self) -> pulumi.Output[str]:
        """
        Notification configuration for the scheduled query. A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
        """
        return pulumi.get(self, "sq_notification_configuration")

    @property
    @pulumi.getter(name="sqQueryString")
    def sq_query_string(self) -> pulumi.Output[str]:
        """
        The query string to run. Parameter names can be specified in the query string @ character followed by an identifier. The named Parameter @scheduled_runtime is reserved and can be used in the query to get the time at which the query is scheduled to run. The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of @scheduled_runtime paramater for each query run. For example, consider an instance of a scheduled query executing on 2021-12-01 00:00:00. For this instance, the @scheduled_runtime parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
        """
        return pulumi.get(self, "sq_query_string")

    @property
    @pulumi.getter(name="sqScheduleConfiguration")
    def sq_schedule_configuration(self) -> pulumi.Output[str]:
        """
        Configuration for when the scheduled query is executed.
        """
        return pulumi.get(self, "sq_schedule_configuration")

    @property
    @pulumi.getter(name="sqScheduledQueryExecutionRoleArn")
    def sq_scheduled_query_execution_role_arn(self) -> pulumi.Output[str]:
        """
        The ARN for the IAM role that Timestream will assume when running the scheduled query.
        """
        return pulumi.get(self, "sq_scheduled_query_execution_role_arn")

    @property
    @pulumi.getter(name="sqTargetConfiguration")
    def sq_target_configuration(self) -> pulumi.Output[str]:
        """
        Configuration of target store where scheduled query results are written to.
        """
        return pulumi.get(self, "sq_target_configuration")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of key-value pairs to label the scheduled query.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetConfiguration")
    def target_configuration(self) -> pulumi.Output[Optional['outputs.ScheduledQueryTargetConfiguration']]:
        """
        Scheduled query target store configuration.
        """
        return pulumi.get(self, "target_configuration")

