# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['InfluxDbInstanceArgs', 'InfluxDbInstance']

@pulumi.input_type
class InfluxDbInstanceArgs:
    def __init__(__self__, *,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 db_instance_type: Optional[pulumi.Input['InfluxDbInstanceDbInstanceType']] = None,
                 db_parameter_group_identifier: Optional[pulumi.Input[str]] = None,
                 db_storage_type: Optional[pulumi.Input['InfluxDbInstanceDbStorageType']] = None,
                 deployment_type: Optional[pulumi.Input['InfluxDbInstanceDeploymentType']] = None,
                 log_delivery_configuration: Optional[pulumi.Input['LogDeliveryConfigurationPropertiesArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a InfluxDbInstance resource.
        :param pulumi.Input[int] allocated_storage: The allocated storage for the InfluxDB instance.
        :param pulumi.Input[str] bucket: The bucket for the InfluxDB instance.
        :param pulumi.Input['InfluxDbInstanceDbInstanceType'] db_instance_type: The compute instance of the InfluxDB instance.
        :param pulumi.Input[str] db_parameter_group_identifier: The name of an existing InfluxDB parameter group.
        :param pulumi.Input['InfluxDbInstanceDbStorageType'] db_storage_type: The storage type of the InfluxDB instance.
        :param pulumi.Input['InfluxDbInstanceDeploymentType'] deployment_type: Deployment type of the InfluxDB Instance.
        :param pulumi.Input['LogDeliveryConfigurationPropertiesArgs'] log_delivery_configuration: Configuration for sending logs to customer account from the InfluxDB instance.
        :param pulumi.Input[str] name: The unique name that is associated with the InfluxDB instance.
        :param pulumi.Input[str] organization: The organization for the InfluxDB instance.
        :param pulumi.Input[str] password: The password for the InfluxDB instance.
        :param pulumi.Input[bool] publicly_accessible: Attach a public IP to the customer ENI.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An arbitrary set of tags (key-value pairs) for this DB instance.
        :param pulumi.Input[str] username: The username for the InfluxDB instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: A list of Amazon EC2 VPC security groups to associate with this InfluxDB instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_subnet_ids: A list of EC2 subnet IDs for this InfluxDB instance.
        """
        if allocated_storage is not None:
            pulumi.set(__self__, "allocated_storage", allocated_storage)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if db_instance_type is not None:
            pulumi.set(__self__, "db_instance_type", db_instance_type)
        if db_parameter_group_identifier is not None:
            pulumi.set(__self__, "db_parameter_group_identifier", db_parameter_group_identifier)
        if db_storage_type is not None:
            pulumi.set(__self__, "db_storage_type", db_storage_type)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if log_delivery_configuration is not None:
            pulumi.set(__self__, "log_delivery_configuration", log_delivery_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if publicly_accessible is not None:
            pulumi.set(__self__, "publicly_accessible", publicly_accessible)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)
        if vpc_subnet_ids is not None:
            pulumi.set(__self__, "vpc_subnet_ids", vpc_subnet_ids)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> Optional[pulumi.Input[int]]:
        """
        The allocated storage for the InfluxDB instance.
        """
        return pulumi.get(self, "allocated_storage")

    @allocated_storage.setter
    def allocated_storage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "allocated_storage", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The bucket for the InfluxDB instance.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="dbInstanceType")
    def db_instance_type(self) -> Optional[pulumi.Input['InfluxDbInstanceDbInstanceType']]:
        """
        The compute instance of the InfluxDB instance.
        """
        return pulumi.get(self, "db_instance_type")

    @db_instance_type.setter
    def db_instance_type(self, value: Optional[pulumi.Input['InfluxDbInstanceDbInstanceType']]):
        pulumi.set(self, "db_instance_type", value)

    @property
    @pulumi.getter(name="dbParameterGroupIdentifier")
    def db_parameter_group_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing InfluxDB parameter group.
        """
        return pulumi.get(self, "db_parameter_group_identifier")

    @db_parameter_group_identifier.setter
    def db_parameter_group_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_parameter_group_identifier", value)

    @property
    @pulumi.getter(name="dbStorageType")
    def db_storage_type(self) -> Optional[pulumi.Input['InfluxDbInstanceDbStorageType']]:
        """
        The storage type of the InfluxDB instance.
        """
        return pulumi.get(self, "db_storage_type")

    @db_storage_type.setter
    def db_storage_type(self, value: Optional[pulumi.Input['InfluxDbInstanceDbStorageType']]):
        pulumi.set(self, "db_storage_type", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input['InfluxDbInstanceDeploymentType']]:
        """
        Deployment type of the InfluxDB Instance.
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input['InfluxDbInstanceDeploymentType']]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="logDeliveryConfiguration")
    def log_delivery_configuration(self) -> Optional[pulumi.Input['LogDeliveryConfigurationPropertiesArgs']]:
        """
        Configuration for sending logs to customer account from the InfluxDB instance.
        """
        return pulumi.get(self, "log_delivery_configuration")

    @log_delivery_configuration.setter
    def log_delivery_configuration(self, value: Optional[pulumi.Input['LogDeliveryConfigurationPropertiesArgs']]):
        pulumi.set(self, "log_delivery_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name that is associated with the InfluxDB instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        The organization for the InfluxDB instance.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the InfluxDB instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> Optional[pulumi.Input[bool]]:
        """
        Attach a public IP to the customer ENI.
        """
        return pulumi.get(self, "publicly_accessible")

    @publicly_accessible.setter
    def publicly_accessible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publicly_accessible", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An arbitrary set of tags (key-value pairs) for this DB instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username for the InfluxDB instance.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Amazon EC2 VPC security groups to associate with this InfluxDB instance.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)

    @property
    @pulumi.getter(name="vpcSubnetIds")
    def vpc_subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of EC2 subnet IDs for this InfluxDB instance.
        """
        return pulumi.get(self, "vpc_subnet_ids")

    @vpc_subnet_ids.setter
    def vpc_subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_subnet_ids", value)


class InfluxDbInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 db_instance_type: Optional[pulumi.Input['InfluxDbInstanceDbInstanceType']] = None,
                 db_parameter_group_identifier: Optional[pulumi.Input[str]] = None,
                 db_storage_type: Optional[pulumi.Input['InfluxDbInstanceDbStorageType']] = None,
                 deployment_type: Optional[pulumi.Input['InfluxDbInstanceDeploymentType']] = None,
                 log_delivery_configuration: Optional[pulumi.Input[Union['LogDeliveryConfigurationPropertiesArgs', 'LogDeliveryConfigurationPropertiesArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The AWS::Timestream::InfluxDBInstance resource creates an InfluxDB instance.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] allocated_storage: The allocated storage for the InfluxDB instance.
        :param pulumi.Input[str] bucket: The bucket for the InfluxDB instance.
        :param pulumi.Input['InfluxDbInstanceDbInstanceType'] db_instance_type: The compute instance of the InfluxDB instance.
        :param pulumi.Input[str] db_parameter_group_identifier: The name of an existing InfluxDB parameter group.
        :param pulumi.Input['InfluxDbInstanceDbStorageType'] db_storage_type: The storage type of the InfluxDB instance.
        :param pulumi.Input['InfluxDbInstanceDeploymentType'] deployment_type: Deployment type of the InfluxDB Instance.
        :param pulumi.Input[Union['LogDeliveryConfigurationPropertiesArgs', 'LogDeliveryConfigurationPropertiesArgsDict']] log_delivery_configuration: Configuration for sending logs to customer account from the InfluxDB instance.
        :param pulumi.Input[str] name: The unique name that is associated with the InfluxDB instance.
        :param pulumi.Input[str] organization: The organization for the InfluxDB instance.
        :param pulumi.Input[str] password: The password for the InfluxDB instance.
        :param pulumi.Input[bool] publicly_accessible: Attach a public IP to the customer ENI.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An arbitrary set of tags (key-value pairs) for this DB instance.
        :param pulumi.Input[str] username: The username for the InfluxDB instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: A list of Amazon EC2 VPC security groups to associate with this InfluxDB instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_subnet_ids: A list of EC2 subnet IDs for this InfluxDB instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InfluxDbInstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::Timestream::InfluxDBInstance resource creates an InfluxDB instance.

        :param str resource_name: The name of the resource.
        :param InfluxDbInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InfluxDbInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_storage: Optional[pulumi.Input[int]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 db_instance_type: Optional[pulumi.Input['InfluxDbInstanceDbInstanceType']] = None,
                 db_parameter_group_identifier: Optional[pulumi.Input[str]] = None,
                 db_storage_type: Optional[pulumi.Input['InfluxDbInstanceDbStorageType']] = None,
                 deployment_type: Optional[pulumi.Input['InfluxDbInstanceDeploymentType']] = None,
                 log_delivery_configuration: Optional[pulumi.Input[Union['LogDeliveryConfigurationPropertiesArgs', 'LogDeliveryConfigurationPropertiesArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 publicly_accessible: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InfluxDbInstanceArgs.__new__(InfluxDbInstanceArgs)

            __props__.__dict__["allocated_storage"] = allocated_storage
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["db_instance_type"] = db_instance_type
            __props__.__dict__["db_parameter_group_identifier"] = db_parameter_group_identifier
            __props__.__dict__["db_storage_type"] = db_storage_type
            __props__.__dict__["deployment_type"] = deployment_type
            __props__.__dict__["log_delivery_configuration"] = log_delivery_configuration
            __props__.__dict__["name"] = name
            __props__.__dict__["organization"] = organization
            __props__.__dict__["password"] = password
            __props__.__dict__["publicly_accessible"] = publicly_accessible
            __props__.__dict__["tags"] = tags
            __props__.__dict__["username"] = username
            __props__.__dict__["vpc_security_group_ids"] = vpc_security_group_ids
            __props__.__dict__["vpc_subnet_ids"] = vpc_subnet_ids
            __props__.__dict__["arn"] = None
            __props__.__dict__["availability_zone"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["influx_auth_parameters_secret_arn"] = None
            __props__.__dict__["secondary_availability_zone"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["allocatedStorage", "bucket", "dbInstanceType", "dbStorageType", "deploymentType", "name", "organization", "password", "publiclyAccessible", "username", "vpcSecurityGroupIds[*]", "vpcSubnetIds[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(InfluxDbInstance, __self__).__init__(
            'aws-native:timestream:InfluxDbInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InfluxDbInstance':
        """
        Get an existing InfluxDbInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InfluxDbInstanceArgs.__new__(InfluxDbInstanceArgs)

        __props__.__dict__["allocated_storage"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["availability_zone"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["bucket"] = None
        __props__.__dict__["db_instance_type"] = None
        __props__.__dict__["db_parameter_group_identifier"] = None
        __props__.__dict__["db_storage_type"] = None
        __props__.__dict__["deployment_type"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["influx_auth_parameters_secret_arn"] = None
        __props__.__dict__["log_delivery_configuration"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["organization"] = None
        __props__.__dict__["password"] = None
        __props__.__dict__["publicly_accessible"] = None
        __props__.__dict__["secondary_availability_zone"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["username"] = None
        __props__.__dict__["vpc_security_group_ids"] = None
        __props__.__dict__["vpc_subnet_ids"] = None
        return InfluxDbInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allocatedStorage")
    def allocated_storage(self) -> pulumi.Output[Optional[int]]:
        """
        The allocated storage for the InfluxDB instance.
        """
        return pulumi.get(self, "allocated_storage")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) that is associated with the InfluxDB instance.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        The Availability Zone (AZ) where the InfluxDB instance is created.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        """
        The service generated unique identifier for InfluxDB instance.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[Optional[str]]:
        """
        The bucket for the InfluxDB instance.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="dbInstanceType")
    def db_instance_type(self) -> pulumi.Output[Optional['InfluxDbInstanceDbInstanceType']]:
        """
        The compute instance of the InfluxDB instance.
        """
        return pulumi.get(self, "db_instance_type")

    @property
    @pulumi.getter(name="dbParameterGroupIdentifier")
    def db_parameter_group_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        The name of an existing InfluxDB parameter group.
        """
        return pulumi.get(self, "db_parameter_group_identifier")

    @property
    @pulumi.getter(name="dbStorageType")
    def db_storage_type(self) -> pulumi.Output[Optional['InfluxDbInstanceDbStorageType']]:
        """
        The storage type of the InfluxDB instance.
        """
        return pulumi.get(self, "db_storage_type")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[Optional['InfluxDbInstanceDeploymentType']]:
        """
        Deployment type of the InfluxDB Instance.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        The connection endpoint for the InfluxDB instance.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="influxAuthParametersSecretArn")
    def influx_auth_parameters_secret_arn(self) -> pulumi.Output[str]:
        """
        The Auth parameters secret Amazon Resource name (ARN) that is associated with the InfluxDB instance.
        """
        return pulumi.get(self, "influx_auth_parameters_secret_arn")

    @property
    @pulumi.getter(name="logDeliveryConfiguration")
    def log_delivery_configuration(self) -> pulumi.Output[Optional['outputs.LogDeliveryConfigurationProperties']]:
        """
        Configuration for sending logs to customer account from the InfluxDB instance.
        """
        return pulumi.get(self, "log_delivery_configuration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        The unique name that is associated with the InfluxDB instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[Optional[str]]:
        """
        The organization for the InfluxDB instance.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password for the InfluxDB instance.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="publiclyAccessible")
    def publicly_accessible(self) -> pulumi.Output[Optional[bool]]:
        """
        Attach a public IP to the customer ENI.
        """
        return pulumi.get(self, "publicly_accessible")

    @property
    @pulumi.getter(name="secondaryAvailabilityZone")
    def secondary_availability_zone(self) -> pulumi.Output[str]:
        """
        The Secondary Availability Zone (AZ) where the InfluxDB instance is created, if DeploymentType is set as WITH_MULTIAZ_STANDBY.
        """
        return pulumi.get(self, "secondary_availability_zone")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['InfluxDbInstanceStatus']:
        """
        Status of the InfluxDB Instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An arbitrary set of tags (key-value pairs) for this DB instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        The username for the InfluxDB instance.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of Amazon EC2 VPC security groups to associate with this InfluxDB instance.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @property
    @pulumi.getter(name="vpcSubnetIds")
    def vpc_subnet_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of EC2 subnet IDs for this InfluxDB instance.
        """
        return pulumi.get(self, "vpc_subnet_ids")

